/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.cl;

import java.lang.reflect.Array;
import java.util.Arrays;
import jodd.util.ReflectUtil;
import jodd.util.StringUtil;
import jodd.util.cl.ClassLoaderStrategy;

public class DefaultClassLoaderStrategy
implements ClassLoaderStrategy {
    public static final String[] PRIMITIVE_TYPE_NAMES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short"};
    public static final Class[] PRIMITIVE_TYPES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE};
    public static final char[] PRIMITIVE_BYTECODE_NAME = new char[]{'Z', 'B', 'C', 'D', 'F', 'I', 'J', 'S'};
    protected boolean loadArrayClassByComponentTypes = false;

    public boolean isLoadArrayClassByComponentTypes() {
        return this.loadArrayClassByComponentTypes;
    }

    public void setLoadArrayClassByComponentTypes(boolean loadArrayClassByComponentTypes) {
        this.loadArrayClassByComponentTypes = loadArrayClassByComponentTypes;
    }

    public static String prepareArrayClassnameForLoading(String className) {
        int bracketCount = StringUtil.count(className, '[');
        if (bracketCount == 0) {
            return null;
        }
        String brackets = StringUtil.repeat('[', bracketCount);
        int bracketIndex = className.indexOf(91);
        int primitiveNdx = DefaultClassLoaderStrategy.getPrimitiveClassNameIndex(className = className.substring(0, bracketIndex));
        if (primitiveNdx >= 0) {
            className = String.valueOf(PRIMITIVE_BYTECODE_NAME[primitiveNdx]);
            return brackets + className;
        }
        return brackets + 'L' + className + ';';
    }

    private static int getPrimitiveClassNameIndex(String className) {
        int dotIndex = className.indexOf(46);
        if (dotIndex != -1) {
            return -1;
        }
        return Arrays.binarySearch(PRIMITIVE_TYPE_NAMES, className);
    }

    @Override
    public Class loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        Class klass;
        Class klass2;
        Class klass3;
        int primitiveNdx;
        String arrayClassName = DefaultClassLoaderStrategy.prepareArrayClassnameForLoading(className);
        if (className.indexOf(46) == -1 && arrayClassName == null && (primitiveNdx = DefaultClassLoaderStrategy.getPrimitiveClassNameIndex(className)) >= 0) {
            return PRIMITIVE_TYPES[primitiveNdx];
        }
        if (classLoader != null && (klass3 = this.loadClass(className, arrayClassName, classLoader)) != null) {
            return klass3;
        }
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        if (currentThreadClassLoader != null && currentThreadClassLoader != classLoader && (klass2 = this.loadClass(className, arrayClassName, currentThreadClassLoader)) != null) {
            return klass2;
        }
        Class callerClass = ReflectUtil.getCallerClass();
        ClassLoader callerClassLoader = callerClass.getClassLoader();
        if (callerClassLoader != classLoader && callerClassLoader != currentThreadClassLoader && (klass = this.loadClass(className, arrayClassName, callerClassLoader)) != null) {
            return klass;
        }
        if (arrayClassName != null) {
            try {
                return this.loadArrayClassByComponentType(className, classLoader);
            }
            catch (ClassNotFoundException ignore) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException("Class not found: " + className);
    }

    protected Class loadClass(String className, String arrayClassName, ClassLoader classLoader) {
        if (arrayClassName != null) {
            try {
                if (this.loadArrayClassByComponentTypes) {
                    return this.loadArrayClassByComponentType(className, classLoader);
                }
                return Class.forName(arrayClassName, true, classLoader);
            }
            catch (ClassNotFoundException ignore) {
                // empty catch block
            }
        }
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException ignore) {
            return null;
        }
    }

    protected Class loadArrayClassByComponentType(String className, ClassLoader classLoader) throws ClassNotFoundException {
        int ndx = className.indexOf(91);
        int multi = StringUtil.count(className, '[');
        String componentTypeName = className.substring(0, ndx);
        Class componentType = this.loadClass(componentTypeName, classLoader);
        if (multi == 1) {
            return Array.newInstance(componentType, 0).getClass();
        }
        int[] multiSizes = multi == 2 ? new int[]{0, 0} : (multi == 3 ? new int[]{0, 0, 0} : (int[])Array.newInstance(Integer.TYPE, multi));
        return Array.newInstance(componentType, multiSizes).getClass();
    }
}

