/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.redisson.api.RExpirableAsync;
import org.redisson.api.RExpirableReactive;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.RedissonObjectReactive;
import reactor.fn.Supplier;

abstract class RedissonExpirableReactive
extends RedissonObjectReactive
implements RExpirableReactive {
    protected final RExpirableAsync instance;

    RedissonExpirableReactive(CommandReactiveExecutor connectionManager, String name, RExpirableAsync instance) {
        super(connectionManager, name, instance);
        this.instance = instance;
    }

    RedissonExpirableReactive(Codec codec, CommandReactiveExecutor connectionManager, String name, RExpirableAsync instance) {
        super(codec, connectionManager, name, instance);
        this.instance = instance;
    }

    @Override
    public Publisher<Boolean> expire(final long timeToLive, final TimeUnit timeUnit) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonExpirableReactive.this.instance.expireAsync(timeToLive, timeUnit);
            }
        });
    }

    @Override
    public Publisher<Boolean> expireAt(final long timestamp) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonExpirableReactive.this.instance.expireAtAsync(timestamp);
            }
        });
    }

    @Override
    public Publisher<Boolean> expireAt(Date timestamp) {
        return this.expireAt(timestamp.getTime());
    }

    @Override
    public Publisher<Boolean> clearExpire() {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonExpirableReactive.this.instance.clearExpireAsync();
            }
        });
    }

    @Override
    public Publisher<Long> remainTimeToLive() {
        return this.reactive(new Supplier<RFuture<Long>>(){

            @Override
            public RFuture<Long> get() {
                return RedissonExpirableReactive.this.instance.remainTimeToLiveAsync();
            }
        });
    }
}

