/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.coders;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTDecoder;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.coders.Unknown;
import org.nustaq.serialization.util.FSTInputStream;
import org.nustaq.serialization.util.FSTUtil;

public class FSTJsonDecoder
implements FSTDecoder {
    protected FSTConfiguration conf;
    protected JsonParser input;
    protected JsonFactory fac;
    protected FSTInputStream fstInput;
    protected String unknownFallbackReadFieldName;
    protected HashMap<String, Class> clzCache = new HashMap(31);
    protected String lastUnknown;
    protected int unknownNestLevel;
    int lastObjectLen;
    Class lastDirectClass;
    boolean firstCall = true;
    List tmpList;
    Object lastReadDirectObject;

    public FSTJsonDecoder(FSTConfiguration conf) {
        this.conf = conf;
        this.fac = (JsonFactory)conf.getCoderSpecific();
    }

    @Override
    public void setConf(FSTConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public String readStringUTF() throws IOException {
        if (this.unknownFallbackReadFieldName != null) {
            String unkReadAhead = this.unknownFallbackReadFieldName;
            this.unknownFallbackReadFieldName = null;
            return unkReadAhead;
        }
        JsonToken jsonToken = this.input.nextToken();
        if (jsonToken == JsonToken.VALUE_NULL) {
            return null;
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            return this.input.getCurrentName();
        }
        return this.input.getText();
    }

    @Override
    public String readStringAsc() throws IOException {
        return this.input.nextTextValue();
    }

    @Override
    public Object readFPrimitiveArray(Object array, Class componentType, int len) {
        try {
            if (componentType == Integer.TYPE) {
                int[] da = (int[])array;
                for (int i = 0; i < da.length; ++i) {
                    this.input.nextToken();
                    da[i] = this.input.getIntValue();
                }
                return da;
            }
            if (componentType == Long.TYPE) {
                long[] da = (long[])array;
                for (int i = 0; i < da.length; ++i) {
                    this.input.nextToken();
                    da[i] = this.input.getLongValue();
                }
                return da;
            }
            if (componentType == Double.TYPE) {
                double[] da = (double[])array;
                for (int i = 0; i < da.length; ++i) {
                    this.input.nextToken();
                    da[i] = this.input.getDoubleValue();
                }
                return da;
            }
            if (componentType == Float.TYPE) {
                float[] da = (float[])array;
                for (int i = 0; i < da.length; ++i) {
                    this.input.nextToken();
                    da[i] = this.input.getFloatValue();
                }
                return da;
            }
            if (componentType == Boolean.TYPE) {
                boolean[] da = (boolean[])array;
                for (int i = 0; i < da.length; ++i) {
                    this.input.nextToken();
                    da[i] = this.input.getBooleanValue();
                }
                return da;
            }
            if (componentType == Byte.TYPE) {
                byte[] da = (byte[])array;
                for (int i = 0; i < da.length; ++i) {
                    this.input.nextToken();
                    da[i] = this.input.getByteValue();
                }
                return da;
            }
            if (componentType == Short.TYPE) {
                short[] da = (short[])array;
                for (int i = 0; i < da.length; ++i) {
                    this.input.nextToken();
                    da[i] = this.input.getShortValue();
                }
                return da;
            }
            if (componentType == Character.TYPE) {
                char[] da = (char[])array;
                for (int i = 0; i < da.length; ++i) {
                    this.input.nextToken();
                    da[i] = (char)this.input.getIntValue();
                }
                return da;
            }
            throw new RuntimeException("unsupported type " + componentType.getName());
        }
        catch (Exception e) {
            FSTUtil.rethrow(e);
            return null;
        }
    }

    @Override
    public void readFIntArr(int len, int[] arr) throws IOException {
        JsonToken jsonToken = this.input.nextToken();
        if (!jsonToken.isStructStart()) {
            throw new RuntimeException("Expected array start");
        }
        for (int i = 0; i < len; ++i) {
            this.input.nextToken();
            arr[i] = this.input.getIntValue();
        }
    }

    @Override
    public int readFInt() throws IOException {
        return this.input.nextIntValue(-1);
    }

    @Override
    public double readFDouble() throws IOException {
        this.input.nextToken();
        return this.input.getDoubleValue();
    }

    @Override
    public float readFFloat() throws IOException {
        this.input.nextToken();
        return this.input.getFloatValue();
    }

    @Override
    public byte readFByte() throws IOException {
        this.input.nextToken();
        int currentTokenId = this.input.getCurrentTokenId();
        if (currentTokenId == 10) {
            return 0;
        }
        if (currentTokenId == 9) {
            return 1;
        }
        return this.input.getByteValue();
    }

    @Override
    public int readIntByte() throws IOException {
        this.input.nextToken();
        return this.input.getByteValue();
    }

    @Override
    public long readFLong() throws IOException {
        this.input.nextToken();
        return this.input.getLongValue();
    }

    @Override
    public char readFChar() throws IOException {
        this.input.nextToken();
        return (char)this.input.getIntValue();
    }

    @Override
    public short readFShort() throws IOException {
        this.input.nextToken();
        return this.input.getShortValue();
    }

    @Override
    public int readPlainInt() throws IOException {
        throw new RuntimeException("not supported");
    }

    @Override
    public byte[] getBuffer() {
        return this.fstInput.buf;
    }

    @Override
    public int getInputPos() {
        JsonLocation currentLocation = this.input.getCurrentLocation();
        long byteOffset = currentLocation.getByteOffset();
        if (this.input.getCurrentToken() == JsonToken.FIELD_NAME) {
            byteOffset -= 2L;
        }
        return (int)byteOffset;
    }

    @Override
    public void moveTo(int position) {
        throw new RuntimeException("not supported");
    }

    @Override
    public void setInputStream(InputStream in) {
        try {
            if (this.fstInput != null) {
                this.fstInput.initFromStream(in);
            } else {
                this.fstInput = new FSTInputStream(in);
            }
            if (in != FSTObjectInput.emptyStream) {
                this.createParser();
            }
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
        }
    }

    @Override
    public int ensureReadAhead(int bytes) {
        return 0;
    }

    @Override
    public void reset() {
        this.fstInput.reset();
        this.input = null;
        this.unknownNestLevel = 0;
        this.firstCall = true;
    }

    @Override
    public void resetToCopyOf(byte[] bytes, int off, int len) {
        if (off != 0) {
            throw new RuntimeException("not supported");
        }
        byte[] b = new byte[len];
        System.arraycopy(bytes, off, b, 0, len);
        if (this.fstInput == null) {
            this.fstInput = new FSTInputStream(b);
        } else {
            this.fstInput.resetForReuse(bytes, len);
        }
        try {
            this.createParser();
            this.unknownNestLevel = 0;
            this.firstCall = true;
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
        }
    }

    public void createParser() throws IOException {
        if (this.input != null) {
            this.input.close();
        }
        this.input = this.fac.createParser(this.fstInput);
    }

    @Override
    public void resetWith(byte[] bytes, int len) {
        if (this.fstInput == null) {
            this.fstInput = new FSTInputStream(bytes, 0, len);
        } else {
            this.fstInput.resetForReuse(bytes, len);
        }
        try {
            this.createParser();
            this.unknownNestLevel = 0;
            this.firstCall = true;
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
        }
    }

    @Override
    public int getObjectHeaderLen() {
        return this.lastObjectLen;
    }

    @Override
    public byte readObjectHeaderTag() throws IOException {
        boolean isFirst = this.firstCall;
        this.firstCall = false;
        this.lastObjectLen = -1;
        this.lastReadDirectObject = null;
        this.lastDirectClass = null;
        JsonToken jsonToken = this.input.nextToken();
        if (jsonToken == JsonToken.END_OBJECT) {
            jsonToken = this.input.nextToken();
        }
        switch (jsonToken) {
            case VALUE_STRING: {
                this.lastReadDirectObject = this.input.getValueAsString();
                return -2;
            }
            case VALUE_TRUE: {
                this.lastReadDirectObject = Boolean.TRUE;
                return -2;
            }
            case VALUE_FALSE: {
                this.lastReadDirectObject = Boolean.FALSE;
                return -2;
            }
            case VALUE_NUMBER_INT: {
                this.lastReadDirectObject = this.input.getNumberValue();
                return -2;
            }
            case VALUE_NUMBER_FLOAT: {
                this.lastReadDirectObject = this.input.getDoubleValue();
                return -2;
            }
            case START_ARRAY: {
                if (this.unknownNestLevel > 0 || isFirst) {
                    this.lastReadDirectObject = this.createUnknownArray();
                    return -8;
                }
                this.lastReadDirectObject = this.createPrimitiveArrayFrom(this.readJSonArr2List(this.getTmpList()));
                return -8;
            }
            case VALUE_NULL: {
                this.lastReadDirectObject = null;
                return -1;
            }
        }
        if (jsonToken != JsonToken.START_OBJECT) {
            if (jsonToken == JsonToken.END_ARRAY) {
                this.lastReadDirectObject = "]";
                return -2;
            }
            throw new RuntimeException("Expected Object start, got '" + (Object)((Object)jsonToken) + "'");
        }
        String typeTag = this.input.nextFieldName();
        if (typeTag.equals("typ")) {
            String type = this.input.nextTextValue();
            String valueTag = this.input.nextFieldName();
            if (!"obj".equals(valueTag)) {
                throw new RuntimeException("expected value attribute for object of type:" + type);
            }
            if (!this.input.nextToken().isStructStart()) {
                throw new RuntimeException("expected struct start");
            }
            try {
                this.lastDirectClass = this.classForName(this.conf.getClassForCPName(type));
            }
            catch (ClassNotFoundException e) {
                FSTUtil.rethrow(e);
            }
            return 0;
        }
        if (typeTag.equals("styp")) {
            String type = this.input.nextTextValue();
            try {
                this.lastDirectClass = this.classForName(this.conf.getClassForCPName(type));
                String valueTag = this.input.nextFieldName();
                if (!"seq".equals(valueTag)) {
                    throw new RuntimeException("expected value attribute for object of type:" + type);
                }
                if (!this.input.nextToken().isStructStart()) {
                    throw new RuntimeException("expected array start");
                }
            }
            catch (ClassNotFoundException e) {
                FSTUtil.rethrow(e);
            }
            return -5;
        }
        if (typeTag.equals("ref")) {
            return -7;
        }
        if (typeTag.equals("enum")) {
            try {
                String clName = this.input.nextTextValue();
                Class aClass = this.classForName(this.conf.getClassForCPName(clName));
                String valueTag = this.input.nextFieldName();
                if (!"val".equals(valueTag)) {
                    throw new RuntimeException("expected value attribute for enum of type:" + clName);
                }
                String enumString = this.input.nextTextValue();
                this.lastReadDirectObject = Enum.valueOf(aClass, enumString);
                this.input.nextToken();
            }
            catch (ClassNotFoundException e) {
                FSTUtil.rethrow(e);
            }
            return -2;
        }
        this.lastDirectClass = Unknown.class;
        this.unknownFallbackReadFieldName = typeTag;
        return 0;
    }

    private List getTmpList() {
        if (this.tmpList == null) {
            this.tmpList = new ArrayList(32);
        } else {
            this.tmpList.clear();
        }
        return this.tmpList;
    }

    protected Unknown createUnknownArray() throws IOException {
        ++this.unknownNestLevel;
        ArrayList<Object> arrayTokens = new ArrayList<Object>(14);
        JsonToken elem = this.input.nextToken();
        while (!elem.isStructEnd()) {
            if (elem == JsonToken.VALUE_NUMBER_INT) {
                arrayTokens.add(this.input.getLongValue());
            } else if (elem == JsonToken.VALUE_NUMBER_FLOAT) {
                arrayTokens.add(this.input.getDoubleValue());
            } else if (elem == JsonToken.VALUE_TRUE) {
                arrayTokens.add(true);
            } else if (elem == JsonToken.VALUE_FALSE) {
                arrayTokens.add(false);
            } else if (elem == JsonToken.VALUE_NULL) {
                arrayTokens.add(null);
            } else if (elem == JsonToken.VALUE_STRING) {
                arrayTokens.add(this.input.getText());
            } else if (elem == JsonToken.START_OBJECT) {
                arrayTokens.add(this.readUnknownObject());
            } else if (elem == JsonToken.START_ARRAY) {
                arrayTokens.add(this.createUnknownArray());
            } else {
                throw new RuntimeException("unexpected array content in Unknown array");
            }
            elem = this.input.nextValue();
        }
        --this.unknownNestLevel;
        return new Unknown().items(arrayTokens);
    }

    private Unknown readUnknownObject() throws IOException {
        Unknown unk = new Unknown();
        JsonToken elem = this.input.nextToken();
        boolean expectField = true;
        String field = null;
        while (!elem.isStructEnd()) {
            if (expectField) {
                field = this.input.getValueAsString();
                expectField = false;
            } else {
                if (elem == JsonToken.VALUE_NUMBER_INT) {
                    unk.set(field, this.input.getLongValue());
                } else if (elem == JsonToken.VALUE_NUMBER_FLOAT) {
                    unk.set(field, this.input.getDoubleValue());
                } else if (elem == JsonToken.VALUE_TRUE) {
                    unk.set(field, true);
                } else if (elem == JsonToken.VALUE_FALSE) {
                    unk.set(field, false);
                } else if (elem == JsonToken.VALUE_NULL) {
                    unk.set(field, null);
                } else if (elem == JsonToken.VALUE_STRING) {
                    unk.set(field, this.input.getText());
                } else if (elem == JsonToken.START_OBJECT) {
                    unk.set(field, this.readUnknownObject());
                } else if (elem == JsonToken.START_ARRAY) {
                    unk.set(field, this.createUnknownArray());
                } else {
                    throw new RuntimeException("unexpected array content in Unknown array");
                }
                expectField = true;
            }
            elem = this.input.nextToken();
        }
        return unk;
    }

    private Object createPrimitiveArrayFrom(List directObject) {
        if (directObject.size() == 0 || !(directObject.get(0) instanceof String)) {
            directObject.add(0, "int");
        }
        Class<Object> arrT = null;
        switch ((String)directObject.get(0)) {
            case "boolean": {
                arrT = Boolean.TYPE;
                break;
            }
            case "byte": {
                arrT = Byte.TYPE;
                break;
            }
            case "char": {
                arrT = Character.TYPE;
                break;
            }
            case "short": {
                arrT = Short.TYPE;
                break;
            }
            case "int": {
                arrT = Integer.TYPE;
                break;
            }
            case "long": {
                arrT = Long.TYPE;
                break;
            }
            case "float": {
                arrT = Float.TYPE;
                break;
            }
            case "double": {
                arrT = Double.TYPE;
                break;
            }
            default: {
                directObject.add(0, "dummy");
                arrT = String.class;
            }
        }
        Object newObj = Array.newInstance(arrT, directObject.size() - 1);
        for (int i = 0; i < directObject.size() - 1; ++i) {
            Object n = directObject.get(i + 1);
            if (arrT == Boolean.TYPE) {
                Array.setBoolean(newObj, i, (Boolean)n);
                continue;
            }
            if (arrT == Byte.TYPE) {
                Array.setByte(newObj, i, ((Number)n).byteValue());
                continue;
            }
            if (arrT == Character.TYPE) {
                Array.setChar(newObj, i, (char)((Number)n).intValue());
                continue;
            }
            if (arrT == Short.TYPE) {
                Array.setShort(newObj, i, ((Number)n).shortValue());
                continue;
            }
            if (arrT == Integer.TYPE) {
                Array.setInt(newObj, i, ((Number)n).intValue());
                continue;
            }
            if (arrT == Long.TYPE) {
                Array.setLong(newObj, i, ((Number)n).longValue());
                continue;
            }
            if (arrT == Float.TYPE) {
                Array.setFloat(newObj, i, ((Number)n).floatValue());
                continue;
            }
            if (arrT == Double.TYPE) {
                Array.setDouble(newObj, i, ((Number)n).doubleValue());
                continue;
            }
            if (arrT == String.class) {
                Array.set(newObj, i, n);
                continue;
            }
            System.err.println("unexpected primitive array type:" + arrT);
        }
        return newObj;
    }

    public List readJSonArr2List(List arrayTokens) throws IOException {
        JsonToken elem = this.input.nextToken();
        while (!elem.isStructEnd()) {
            if (elem == JsonToken.VALUE_NUMBER_INT) {
                arrayTokens.add(this.input.getLongValue());
            } else if (elem == JsonToken.VALUE_NUMBER_FLOAT) {
                arrayTokens.add(this.input.getDoubleValue());
            } else if (elem == JsonToken.VALUE_TRUE) {
                arrayTokens.add(true);
            } else if (elem == JsonToken.VALUE_FALSE) {
                arrayTokens.add(false);
            } else if (elem == JsonToken.VALUE_NULL) {
                arrayTokens.add(null);
            } else {
                arrayTokens.add(this.input.getText());
            }
            elem = this.input.nextValue();
        }
        return arrayTokens;
    }

    @Override
    public Object getDirectObject() {
        Object tmp = this.lastReadDirectObject;
        this.lastReadDirectObject = null;
        return tmp;
    }

    @Override
    public FSTClazzInfo readClass() throws IOException, ClassNotFoundException {
        if (this.lastDirectClass != null) {
            FSTClazzInfo clInfo = this.conf.getCLInfoRegistry().getCLInfo(this.lastDirectClass, this.conf);
            this.lastDirectClass = null;
            return clInfo;
        }
        return null;
    }

    @Override
    public Class classForName(String name) throws ClassNotFoundException {
        Class aClass = this.clzCache.get(name);
        if (aClass == Unknown.class) {
            this.lastUnknown = name;
        }
        if (aClass != null) {
            return aClass;
        }
        aClass = this.conf.getClassRegistry().classForName(name, this.conf);
        if (aClass == Unknown.class) {
            this.lastUnknown = name;
        }
        this.clzCache.put(name, aClass);
        return aClass;
    }

    @Override
    public void registerClass(Class possible) {
    }

    @Override
    public void close() {
    }

    @Override
    public void skip(int n) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void readPlainBytes(byte[] b, int off, int len) {
        try {
            for (int i = 0; i < len; ++i) {
                this.input.nextToken();
                b[i + off] = this.input.getByteValue();
            }
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
        }
    }

    @Override
    public boolean isMapBased() {
        return true;
    }

    @Override
    public void consumeEndMarker() {
    }

    @Override
    public Object readArrayHeader() throws Exception {
        if (this.lastDirectClass == null) {
            JsonToken jsonToken = this.input.nextToken();
            String type = null;
            if (jsonToken == JsonToken.START_ARRAY) {
                if (this.unknownNestLevel > 0) {
                    return this.createUnknownArray();
                }
                return this.createPrimitiveArrayFrom(this.readJSonArr2List(this.getTmpList()));
            }
            if (jsonToken == JsonToken.VALUE_NULL) {
                return null;
            }
            jsonToken = this.input.nextToken();
            if ("typ".equals(this.input.getText())) {
                type = this.input.nextTextValue();
                String valueTag = this.input.nextFieldName();
                if (!"obj".equals(valueTag)) {
                    throw new RuntimeException("expected value attribute for object of type:" + type);
                }
                return this.classForName(this.conf.getClassForCPName(type));
            }
            if (!"styp".equals(this.input.getText())) {
                System.out.println(">" + (Object)((Object)this.input.getCurrentToken()) + " " + this.input.getText());
                this.input.nextToken();
                System.out.println(">" + (Object)((Object)this.input.getCurrentToken()) + " " + this.input.getText());
                this.input.nextToken();
                System.out.println(">" + (Object)((Object)this.input.getCurrentToken()) + " " + this.input.getText());
                this.input.nextToken();
                System.out.println(">" + (Object)((Object)this.input.getCurrentToken()) + " " + this.input.getText());
                throw new RuntimeException("expected seqType");
            }
            jsonToken = this.input.nextToken();
            type = this.input.getText();
            jsonToken = this.input.nextToken();
            jsonToken = this.input.nextToken();
            return this.classForName(this.conf.getClassForCPName(type));
        }
        Class ldc = this.lastDirectClass;
        this.lastDirectClass = null;
        return ldc;
    }

    @Override
    public void readExternalEnd() {
        this.consumeEndMarker();
    }

    @Override
    public boolean isEndMarker(String s) {
        return s == null || s.equals("}") || s.equals("]");
    }

    @Override
    public int readVersionTag() throws IOException {
        return 0;
    }

    @Override
    public void pushBack(int bytes) {
        throw new RuntimeException("not supported");
    }

    private void consumeEnd() {
        try {
            JsonToken jsonToken = this.input.nextToken();
            if (!jsonToken.isStructEnd()) {
                throw new RuntimeException("end of structure expected found:" + (Object)((Object)jsonToken) + " : value:" + this.input.getValueAsString() + " fname:'" + this.input.getCurrentName() + "'");
            }
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
        }
    }

    @Override
    public void readArrayEnd(FSTClazzInfo clzSerInfo) {
        try {
            JsonToken jsonToken = this.input.nextToken();
            if (jsonToken == JsonToken.END_ARRAY) {
                jsonToken = this.input.nextToken();
            }
            JsonToken jsonToken2 = jsonToken;
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
        }
    }

    @Override
    public void readObjectEnd() {
        this.consumeEnd();
    }

    @Override
    public Object coerceElement(Class arrType, Object value) {
        if (arrType == byte[].class && value instanceof String) {
            try {
                return ((String)value).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            if (arrType == Byte.class) {
                return new Byte(n.byteValue());
            }
            if (arrType == Short.class) {
                return new Short(n.shortValue());
            }
            if (arrType == Integer.class) {
                return new Integer(n.intValue());
            }
            if (arrType == Long.class) {
                return new Long(n.longValue());
            }
            if (arrType == Double.class) {
                return new Double(n.doubleValue());
            }
            if (arrType == Float.class) {
                return new Float(n.floatValue());
            }
            if (arrType == Character.class) {
                return new Character((char)n.intValue());
            }
        }
        return value;
    }

    @Override
    public int available() {
        this.fstInput.ensureReadAhead(1);
        return this.fstInput.available();
    }

    @Override
    public boolean inArray() {
        return this.input.getParsingContext().inArray();
    }

    @Override
    public void startFieldReading(Object newObj) {
        if (newObj instanceof Unknown) {
            ((Unknown)newObj).setType(this.lastUnknown);
            this.lastUnknown = null;
            ++this.unknownNestLevel;
        }
    }

    @Override
    public void endFieldReading(Object newObj) {
        if (newObj instanceof Unknown) {
            --this.unknownNestLevel;
        }
    }
}

