/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.transformation;

import reactor.core.support.Assert;
import reactor.fn.Function;
import reactor.rx.action.Action;

public class MapAction<T, V>
extends Action<T, V> {
    private final Function<? super T, ? extends V> fn;

    public MapAction(Function<? super T, ? extends V> fn) {
        Assert.notNull(fn, "Map function cannot be null.");
        this.fn = fn;
    }

    @Override
    protected void doNext(T value) {
        V res = this.fn.apply(value);
        if (res != null) {
            this.broadcastNext(res);
        }
    }
}

