/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.redisson.api.RCollectionReactive;
import reactor.rx.Promise;
import reactor.rx.Promises;
import reactor.rx.action.support.DefaultSubscriber;

public class PublisherAdder<V> {
    private final RCollectionReactive<V> destination;

    public PublisherAdder(RCollectionReactive<V> destination) {
        this.destination = destination;
    }

    public Integer sum(Integer first, Integer second) {
        return first + second;
    }

    public Publisher<Integer> addAll(Publisher<? extends V> c) {
        final Promise<Integer> promise = Promises.prepare();
        c.subscribe(new DefaultSubscriber<V>(){
            volatile boolean completed;
            AtomicLong values = new AtomicLong();
            Subscription s;
            Integer lastSize = 0;

            @Override
            public void onSubscribe(Subscription s) {
                this.s = s;
                s.request(1L);
            }

            @Override
            public void onNext(V o) {
                this.values.getAndIncrement();
                PublisherAdder.this.destination.add(o).subscribe((Subscriber<Integer>)new DefaultSubscriber<Integer>(){

                    @Override
                    public void onSubscribe(Subscription s) {
                        s.request(1L);
                    }

                    @Override
                    public void onError(Throwable t) {
                        promise.onError(t);
                    }

                    @Override
                    public void onNext(Integer o) {
                        lastSize = PublisherAdder.this.sum(lastSize, o);
                        s.request(1L);
                        if (values.decrementAndGet() == 0L && completed) {
                            promise.onNext(lastSize);
                        }
                    }
                });
            }

            @Override
            public void onComplete() {
                this.completed = true;
                if (this.values.get() == 0L) {
                    promise.onNext(this.lastSize);
                }
            }
        });
        return promise;
    }
}

