/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.redisson.Redisson;
import org.redisson.RedissonPriorityQueue;
import org.redisson.api.RFuture;
import org.redisson.api.RPriorityDeque;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.ListFirstObjectDecoder;
import org.redisson.command.CommandExecutor;
import org.redisson.misc.RedissonPromise;

public class RedissonPriorityDeque<V>
extends RedissonPriorityQueue<V>
implements RPriorityDeque<V> {
    private static final RedisCommand<Object> LRANGE_SINGLE = new RedisCommand<Object>("LRANGE", new ListFirstObjectDecoder());

    protected RedissonPriorityDeque(CommandExecutor commandExecutor, String name, Redisson redisson) {
        super(commandExecutor, name, redisson);
    }

    public RedissonPriorityDeque(Codec codec, CommandExecutor commandExecutor, String name, Redisson redisson) {
        super(codec, commandExecutor, name, redisson);
    }

    @Override
    public void addFirst(V e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addLast(V e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<V> descendingIterator() {
        return new Iterator<V>(){
            private int currentIndex;
            private boolean removeExecuted;
            {
                this.currentIndex = RedissonPriorityDeque.this.size();
            }

            @Override
            public boolean hasNext() {
                int size = RedissonPriorityDeque.this.size();
                return this.currentIndex > 0 && size > 0;
            }

            @Override
            public V next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No such element at index " + this.currentIndex);
                }
                --this.currentIndex;
                this.removeExecuted = false;
                return RedissonPriorityDeque.this.get(this.currentIndex);
            }

            @Override
            public void remove() {
                if (this.removeExecuted) {
                    throw new IllegalStateException("Element been already deleted");
                }
                RedissonPriorityDeque.this.remove(this.currentIndex);
                ++this.currentIndex;
                this.removeExecuted = true;
            }
        };
    }

    public RFuture<V> getLastAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, LRANGE_SINGLE, this.getName(), -1, -1);
    }

    @Override
    public V getLast() {
        V result = this.get(this.getLastAsync());
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public boolean offerFirst(V e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offerLast(V e) {
        throw new UnsupportedOperationException();
    }

    public RFuture<V> peekFirstAsync() {
        return this.getAsync(0);
    }

    @Override
    public V peekFirst() {
        return this.get(this.peekFirstAsync());
    }

    @Override
    public V peekLast() {
        return this.get(this.getLastAsync());
    }

    @Override
    public V pollFirst() {
        return this.poll();
    }

    public RFuture<V> pollLastAsync() {
        final long threadId = Thread.currentThread().getId();
        final RedissonPromise result = new RedissonPromise();
        this.lock.lockAsync(threadId).addListener(new FutureListener<Void>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                RFuture f = RedissonPriorityDeque.this.commandExecutor.writeAsync(RedissonPriorityDeque.this.getName(), RedissonPriorityDeque.this.codec, RedisCommands.RPOP, RedissonPriorityDeque.this.getName());
                f.addListener(new FutureListener<V>(){

                    @Override
                    public void operationComplete(Future<V> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.tryFailure(future.cause());
                            return;
                        }
                        final Object value = future.getNow();
                        RedissonPriorityDeque.this.lock.unlockAsync(threadId).addListener(new FutureListener<Void>(){

                            @Override
                            public void operationComplete(Future<Void> future) throws Exception {
                                if (!future.isSuccess()) {
                                    result.tryFailure(future.cause());
                                    return;
                                }
                                result.trySuccess(value);
                            }
                        });
                    }
                });
            }
        });
        return result;
    }

    @Override
    public V pollLast() {
        return this.get(this.pollLastAsync());
    }

    public RFuture<V> popAsync() {
        return this.pollAsync();
    }

    @Override
    public V pop() {
        return this.removeFirst();
    }

    @Override
    public void push(V e) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Boolean> removeFirstOccurrenceAsync(Object o) {
        return this.removeAsync(o, 1);
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.remove(o, 1);
    }

    public RFuture<V> removeFirstAsync() {
        return this.pollAsync();
    }

    public RFuture<V> removeLastAsync() {
        return this.pollLastAsync();
    }

    @Override
    public V removeLast() {
        V value = this.get(this.removeLastAsync());
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    public RFuture<Boolean> removeLastOccurrenceAsync(Object o) {
        return this.removeAsync(o, -1);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        return this.remove(o, -1);
    }
}

