/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Set;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.api.scope.IBasicScope;
import org.red5.server.api.scope.IBroadcastScope;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.scope.ScopeType;
import org.red5.server.api.service.IStreamableFileService;
import org.red5.server.api.stream.IBroadcastStream;
import org.red5.server.api.stream.IClientBroadcastStream;
import org.red5.server.api.stream.IStreamFilenameGenerator;
import org.red5.server.api.stream.IStreamableFileFactory;
import org.red5.server.messaging.IMessageInput;
import org.red5.server.messaging.InMemoryPullPullPipe;
import org.red5.server.scope.BasicScope;
import org.red5.server.scope.BroadcastScope;
import org.red5.server.scope.Scope;
import org.red5.server.stream.DefaultStreamFilenameGenerator;
import org.red5.server.stream.IProviderService;
import org.red5.server.stream.provider.FileProvider;
import org.red5.server.util.ScopeUtils;
import org.slf4j.Logger;

public class ProviderService
implements IProviderService {
    private static final Logger log = Red5LoggerFactory.getLogger(ProviderService.class);
    private boolean liveWaitSupport;

    public IProviderService.INPUT_TYPE lookupProviderInput(IScope scope, String name, int type) {
        IProviderService.INPUT_TYPE result = IProviderService.INPUT_TYPE.NOT_FOUND;
        if (scope.getBasicScope(ScopeType.BROADCAST, name) != null) {
            result = IProviderService.INPUT_TYPE.LIVE;
        } else {
            File file = this.getStreamFile(scope, name);
            if (file == null) {
                if (type == -2 && this.liveWaitSupport) {
                    result = IProviderService.INPUT_TYPE.LIVE_WAIT;
                }
                log.debug("Requested stream: {} does not appear to be of VOD type", (Object)name);
            } else {
                result = IProviderService.INPUT_TYPE.VOD;
            }
        }
        return result;
    }

    public IMessageInput getProviderInput(IScope scope, String name) {
        IMessageInput msgIn = this.getLiveProviderInput(scope, name, false);
        if (msgIn == null) {
            return this.getVODProviderInput(scope, name);
        }
        return msgIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMessageInput getLiveProviderInput(IScope scope, String name, boolean needCreate) {
        log.debug("Get live provider input for {} scope: {}", (Object)name, (Object)scope);
        IBroadcastScope broadcastScope = scope.getBroadcastScope(name);
        if (broadcastScope == null && needCreate) {
            IScope iScope = scope;
            synchronized (iScope) {
                broadcastScope = scope.getBroadcastScope(name);
                if (broadcastScope == null) {
                    broadcastScope = new BroadcastScope(scope, name);
                    scope.addChildScope((IBasicScope)broadcastScope);
                }
            }
        }
        return broadcastScope;
    }

    public IMessageInput getVODProviderInput(IScope scope, String name) {
        log.debug("getVODProviderInput - scope: {} name: {}", (Object)scope, (Object)name);
        File file = this.getVODProviderFile(scope, name);
        if (file == null) {
            return null;
        }
        InMemoryPullPullPipe pipe = new InMemoryPullPullPipe();
        pipe.subscribe(new FileProvider(scope, file), null);
        return pipe;
    }

    public File getVODProviderFile(IScope scope, String name) {
        File file;
        if (log.isDebugEnabled()) {
            log.debug("getVODProviderFile - scope: {} name: {}", (Object)scope, (Object)name);
        }
        if ((file = this.getStreamFile(scope, name)) == null || !file.exists()) {
            if (name.indexOf(46) > 0) {
                log.info("File was null or did not exist: {}", (Object)name);
            } else {
                log.trace("VOD file {} was not found, may be live stream", (Object)name);
            }
        }
        return file;
    }

    public boolean registerBroadcastStream(IScope scope, String name, IBroadcastStream bs) {
        IBroadcastScope broadcastScope;
        if (log.isDebugEnabled()) {
            log.debug("Registering - name: {} stream: {} scope: {}", new Object[]{name, bs, scope});
            ((Scope)scope).dump();
        }
        if ((broadcastScope = scope.getBroadcastScope(name)) == null) {
            log.debug("Creating a new scope");
            broadcastScope = new BroadcastScope(scope, name);
            if (scope.addChildScope((IBasicScope)broadcastScope)) {
                log.debug("Broadcast scope added");
            } else {
                log.warn("Broadcast scope was not added to {}", (Object)scope);
            }
        }
        if (broadcastScope != null && bs instanceof IClientBroadcastStream) {
            broadcastScope.setClientBroadcastStream((IClientBroadcastStream)bs);
        }
        if (log.isDebugEnabled()) {
            log.debug("Subscribing scope {} to provider {}", (Object)broadcastScope, (Object)bs.getProvider());
        }
        return broadcastScope.subscribe(bs.getProvider(), null);
    }

    public Set<String> getBroadcastStreamNames(IScope scope) {
        return scope.getBasicScopeNames(ScopeType.BROADCAST);
    }

    public boolean unregisterBroadcastStream(IScope scope, String name) {
        return this.unregisterBroadcastStream(scope, name, null);
    }

    public boolean unregisterBroadcastStream(IScope scope, String name, IBroadcastStream bs) {
        if (log.isDebugEnabled()) {
            log.debug("Unregistering - name: {} stream: {} scope: {}", new Object[]{name, bs, scope});
            ((Scope)scope).dump();
        }
        IBroadcastScope broadcastScope = scope.getBroadcastScope(name);
        if (bs != null) {
            log.debug("Unsubscribing scope {} from provider {}", (Object)broadcastScope, (Object)bs.getProvider());
            broadcastScope.unsubscribe(bs.getProvider());
            if (!((BasicScope)broadcastScope).hasEventListeners()) {
                if (log.isDebugEnabled()) {
                    log.debug("Scope has no event listeners attempting removal");
                }
                scope.removeChildScope((IBasicScope)broadcastScope);
            }
        } else {
            log.debug("Broadcast scope was null for {}", (Object)name);
        }
        return scope.getBasicScope(ScopeType.BROADCAST, name) == null;
    }

    private File getStreamFile(IScope scope, String name) {
        File file;
        block12: {
            if (log.isDebugEnabled()) {
                log.debug("getStreamFile - name: {}", name);
            }
            IStreamableFileFactory factory = (IStreamableFileFactory)ScopeUtils.getScopeService((IScope)scope, IStreamableFileFactory.class);
            if (((String)name).indexOf(58) == -1 && ((String)name).indexOf(46) == -1) {
                name = "flv:" + (String)name;
            }
            if (((String)name).charAt(0) == '*') {
                name = ((String)name).substring(1);
                if (log.isTraceEnabled()) {
                    log.trace("Removed star prefix: {}", name);
                }
            }
            for (IStreamableFileService service : factory.getServices()) {
                if (!((String)name).startsWith(service.getPrefix() + ":")) continue;
                name = service.prepareFilename((String)name);
                break;
            }
            IStreamFilenameGenerator filenameGenerator = (IStreamFilenameGenerator)ScopeUtils.getScopeService((IScope)scope, IStreamFilenameGenerator.class, DefaultStreamFilenameGenerator.class);
            String filename = filenameGenerator.generateFilename(scope, (String)name, IStreamFilenameGenerator.GenerationType.PLAYBACK);
            file = null;
            try {
                File tmp = Paths.get(filename, new String[0]).toFile();
                if (tmp.exists()) {
                    file = tmp;
                } else if (!filenameGenerator.resolvesToAbsolutePath()) {
                    try {
                        file = scope.getContext().getResource(filename).getFile();
                    }
                    catch (FileNotFoundException e) {
                        log.debug("File {} not found, nulling it", (Object)filename);
                    }
                }
            }
            catch (IOException e) {
                log.info("Exception attempting to lookup file: {}", (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block12;
                log.warn("Exception attempting to lookup file: {}", name, (Object)e);
            }
        }
        return file;
    }

    public boolean isLiveWaitSupport() {
        return this.liveWaitSupport;
    }

    public void setLiveWaitSupport(boolean liveWaitSupport) {
        this.liveWaitSupport = liveWaitSupport;
    }
}

