/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.api.IConnection;
import org.red5.server.api.IContext;
import org.red5.server.api.IServer;
import org.red5.server.api.Red5;
import org.red5.server.api.scope.IGlobalScope;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.service.IServiceCall;
import org.red5.server.api.service.IServiceInvoker;
import org.red5.server.net.remoting.RemotingConnection;
import org.red5.server.net.remoting.codec.RemotingCodecFactory;
import org.red5.server.net.remoting.message.RemotingCall;
import org.red5.server.net.remoting.message.RemotingPacket;
import org.red5.server.net.servlet.ServletUtils;
import org.slf4j.Logger;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AMFGatewayServlet
extends HttpServlet {
    private static final long serialVersionUID = 7174018823796785619L;
    protected Logger log = Red5LoggerFactory.getLogger(AMFGatewayServlet.class);
    public static final String APPLICATION_AMF = "application/x-amf";
    protected transient WebApplicationContext webAppCtx;
    protected transient IServer server;
    protected transient RemotingCodecFactory codecFactory;
    private static final String CONNECTION = "red5.remotingConnection";

    public void init() throws ServletException {
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.log.debug("Servicing Request");
        if (this.codecFactory == null) {
            ServletContext ctx = this.getServletContext();
            this.log.debug("Context path: {}", (Object)ctx.getContextPath());
            this.webAppCtx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)ctx);
            if (this.webAppCtx == null) {
                this.log.debug("Webapp context was null, trying lookup as attr.");
                this.webAppCtx = (WebApplicationContext)ctx.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
            }
            if (this.webAppCtx != null) {
                this.server = (IServer)this.webAppCtx.getBean("red5.server");
                this.codecFactory = (RemotingCodecFactory)this.webAppCtx.getBean("remotingCodecFactory");
            } else {
                this.log.debug("No web context");
            }
        }
        this.log.debug("Remoting request {} {}", (Object)req.getContextPath(), (Object)req.getServletPath());
        if (APPLICATION_AMF.equals(req.getContentType())) {
            this.serviceAMF(req, resp);
        } else {
            resp.getWriter().write("Red5 : Remoting Gateway");
        }
    }

    protected IGlobalScope getGlobalScope(HttpServletRequest req) {
        Object path = req.getContextPath() + req.getServletPath();
        this.log.debug("getGlobalScope path: {}", path);
        if (((String)path).startsWith("/")) {
            path = ((String)path).substring(1);
        } else {
            this.log.debug("Path length: {} Servlet name length: {}", (Object)((String)path).length(), (Object)this.getServletName().length());
            path = ((String)path).substring(0, ((String)path).length() - this.getServletName().length() - 1);
        }
        IGlobalScope global = this.server.lookupGlobal(req.getServerName(), (String)path);
        if (global == null && (global = this.server.lookupGlobal(req.getLocalName(), (String)path)) == null) {
            global = this.server.lookupGlobal(req.getLocalAddr(), (String)path);
        }
        return global;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceAMF(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block11: {
            block10: {
                this.log.debug("Servicing AMF");
                RemotingConnection conn = null;
                try {
                    RemotingPacket packet = this.decodeRequest(req);
                    if (packet == null) {
                        this.log.error("Packet should not be null");
                        return;
                    }
                    IGlobalScope global = this.getGlobalScope(req);
                    IContext context = global.getContext();
                    IScope scope = context.resolveScope((IScope)global, packet.getScopePath());
                    conn = new RemotingConnection(req, scope, packet);
                    req.setAttribute(CONNECTION, (Object)conn);
                    Red5.setConnectionLocal((IConnection)conn);
                    boolean passed = this.handleRemotingPacket(req, context, scope, packet);
                    if (passed) {
                        resp.setStatus(200);
                    } else {
                        this.log.warn("At least one invocation failed to execute");
                        resp.setStatus(417);
                    }
                    resp.setContentType(APPLICATION_AMF);
                    this.sendResponse(resp, packet);
                    req.removeAttribute(CONNECTION);
                    if (conn == null) break block10;
                    conn.cleanup();
                }
                catch (Exception e) {
                    this.log.error("Error handling remoting call", (Throwable)e);
                    resp.setStatus(500);
                    break block11;
                }
                finally {
                    req.removeAttribute(CONNECTION);
                    if (conn != null) {
                        ((RemotingConnection)conn).cleanup();
                    }
                    Red5.setConnectionLocal(null);
                }
            }
            Red5.setConnectionLocal(null);
        }
    }

    protected RemotingPacket decodeRequest(HttpServletRequest req) throws Exception {
        String headerPath;
        this.log.debug("Decoding request");
        IoBuffer reqBuffer = IoBuffer.allocate((int)req.getContentLength());
        ServletUtils.copy((HttpServletRequest)req, (OutputStream)reqBuffer.asOutputStream());
        reqBuffer.flip();
        RemotingPacket packet = (RemotingPacket)this.codecFactory.getRemotingDecoder().decode(reqBuffer);
        Object path = req.getContextPath();
        if (path == null) {
            path = "";
        }
        if (req.getPathInfo() != null) {
            path = (String)path + req.getPathInfo();
        }
        if ((headerPath = req.getHeader("Tunnel-request")) != null && ((String)path).length() < 1) {
            path = headerPath;
        }
        if (((String)path).length() > 0 && ((String)path).charAt(0) == '/') {
            path = ((String)path).substring(1);
        }
        this.log.debug("Path: {} Scope path: {}", path, (Object)packet.getScopePath());
        packet.setScopePath((String)path);
        reqBuffer.free();
        reqBuffer = null;
        return packet;
    }

    protected boolean handleRemotingPacket(HttpServletRequest req, IContext context, IScope scope, RemotingPacket message) {
        RemotingCall call;
        this.log.debug("Handling remoting packet");
        boolean result = true;
        IServiceInvoker invoker = context.getServiceInvoker();
        Iterator<RemotingCall> iterator = message.getCalls().iterator();
        while (iterator.hasNext() && (result = invoker.invoke((IServiceCall)(call = iterator.next()), scope))) {
        }
        return result;
    }

    protected void sendResponse(HttpServletResponse resp, RemotingPacket packet) throws Exception {
        this.log.debug("Sending response");
        IoBuffer respBuffer = this.codecFactory.getRemotingEncoder().encode(packet);
        if (respBuffer != null) {
            ServletOutputStream out = resp.getOutputStream();
            resp.setContentLength(respBuffer.limit());
            ServletUtils.copy((InputStream)respBuffer.asInputStream(), (OutputStream)out);
            out.flush();
            out.close();
            respBuffer.free();
            respBuffer = null;
        } else {
            this.log.info("Response buffer was null after encoding");
        }
    }
}

