/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.remoting;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.red5.compatibility.flex.data.messages.DataMessage;
import org.red5.compatibility.flex.data.messages.SequencedMessage;
import org.red5.compatibility.flex.messaging.messages.AbstractMessage;
import org.red5.compatibility.flex.messaging.messages.AcknowledgeMessage;
import org.red5.compatibility.flex.messaging.messages.AcknowledgeMessageExt;
import org.red5.compatibility.flex.messaging.messages.AsyncMessage;
import org.red5.compatibility.flex.messaging.messages.AsyncMessageExt;
import org.red5.compatibility.flex.messaging.messages.CommandMessage;
import org.red5.compatibility.flex.messaging.messages.CommandMessageExt;
import org.red5.compatibility.flex.messaging.messages.ErrorMessage;
import org.red5.compatibility.flex.messaging.messages.Message;
import org.red5.compatibility.flex.messaging.messages.RemotingMessage;
import org.red5.io.utils.ConversionUtils;
import org.red5.io.utils.RandomGUID;
import org.red5.server.api.IClient;
import org.red5.server.api.Red5;
import org.red5.server.api.service.IServiceCall;
import org.red5.server.api.service.IServiceInvoker;
import org.red5.server.exception.ClientDetailsException;
import org.red5.server.messaging.ServiceAdapter;
import org.red5.server.service.PendingCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlexMessagingService {
    public static final String SERVICE_NAME = "flexMessaging";
    protected static Logger log = LoggerFactory.getLogger(FlexMessagingService.class);
    protected IServiceInvoker serviceInvoker;
    protected Map<String, Object> endpoints = Collections.EMPTY_MAP;
    protected ConcurrentMap<String, ServiceAdapter> registrations = null;

    public void setEndpoints(Map<String, Object> endpoints) {
        this.endpoints = endpoints;
        log.info("Configured endpoints: {}", endpoints);
    }

    public void setServiceInvoker(IServiceInvoker serviceInvoker) {
        this.serviceInvoker = serviceInvoker;
    }

    public static ErrorMessage returnError(AbstractMessage request, String faultCode, String faultString, String faultDetail) {
        ErrorMessage result = new ErrorMessage();
        result.timestamp = System.currentTimeMillis();
        result.headers = request.headers;
        result.destination = request.destination;
        result.correlationId = request.messageId;
        result.faultCode = faultCode;
        result.faultString = faultString;
        result.faultDetail = faultDetail;
        return result;
    }

    public static ErrorMessage returnError(AbstractMessage request, String faultCode, String faultString, Throwable error) {
        ErrorMessage result = FlexMessagingService.returnError(request, faultCode, faultString, "");
        if (error instanceof ClientDetailsException) {
            result.extendedData = ((ClientDetailsException)error).getParameters();
            if (((ClientDetailsException)error).includeStacktrace()) {
                StringBuilder stack = new StringBuilder();
                for (StackTraceElement element : error.getStackTrace()) {
                    stack.append(element.toString()).append('\n');
                }
                result.faultDetail = stack.toString();
            }
        }
        result.rootCause = error;
        return result;
    }

    public AsyncMessage handleRequest(RemotingMessage msg) {
        log.debug("Handle RemotingMessage request");
        log.trace("{}", (Object)msg);
        this.setClientId((AbstractMessage)msg);
        if (this.serviceInvoker == null) {
            log.error("No service invoker configured: {}", (Object)msg);
            return FlexMessagingService.returnError((AbstractMessage)msg, "Server.Invoke.Error", "No service invoker configured.", "No service invoker configured.");
        }
        Object endpoint = this.endpoints.get(msg.destination);
        log.debug("End point / destination: {}", endpoint);
        if (endpoint == null) {
            String errMsg = String.format("Endpoint %s doesn't exist.", msg.destination);
            log.debug("{} ({})", (Object)errMsg, (Object)msg);
            return FlexMessagingService.returnError((AbstractMessage)msg, "Server.Invoke.Error", errMsg, errMsg);
        }
        AcknowledgeMessage result = new AcknowledgeMessage();
        result.setClientId(msg.getClientId());
        result.setCorrelationId(msg.getMessageId());
        Map headers = msg.getHeaders();
        log.debug("Headers: {}", (Object)headers);
        String operation = msg.operation;
        log.debug("Operation: {}", (Object)operation);
        if (endpoint instanceof ServiceAdapter) {
            log.debug("Endpoint is a ServiceAdapter so message will be invoked");
            ServiceAdapter adapter = (ServiceAdapter)endpoint;
            result.body = adapter.invoke((Message)msg);
        } else {
            Object[] args = null;
            try {
                log.debug("Body: {} type: {}", msg.body, (Object)msg.body.getClass().getName());
                args = (Object[])ConversionUtils.convert((Object)msg.body, Object[].class);
            }
            catch (ConversionException cex) {
                args = new Object[]{msg.body};
            }
            PendingCall call = new PendingCall(operation, args);
            try {
                if (!this.serviceInvoker.invoke((IServiceCall)call, endpoint)) {
                    if (call.getException() != null) {
                        Exception err = call.getException();
                        return FlexMessagingService.returnError((AbstractMessage)msg, "Server.Invoke.Error", err.getMessage(), err);
                    }
                    return FlexMessagingService.returnError((AbstractMessage)msg, "Server.Invoke.Error", "Can't invoke method.", "");
                }
            }
            catch (Throwable err) {
                log.error("Error while invoking method.", err);
                return FlexMessagingService.returnError((AbstractMessage)msg, "Server.Invoke.Error", err.getMessage(), err);
            }
            result.body = call.getResult();
        }
        return result;
    }

    public Message handleRequest(CommandMessageExt msg) {
        log.debug("Handle CommandMessageExt request");
        log.trace("{}", (Object)msg);
        this.setClientId((AbstractMessage)msg);
        String clientId = msg.getClientId();
        switch (msg.operation) {
            case 2: {
                log.debug("Poll: {}", (Object)clientId);
                if (!this.registrations.containsKey(clientId)) break;
                ServiceAdapter adapter = (ServiceAdapter)this.registrations.get(clientId);
                if (adapter != null) {
                    CommandMessage result = new CommandMessage();
                    result.setOperation(4);
                    AsyncMessageExt ext = new AsyncMessageExt();
                    ext.setClientId(clientId);
                    ext.setCorrelationId(msg.getMessageId());
                    ext.setDestination("Red5Chat");
                    ext.setBody(adapter.manage((CommandMessage)msg));
                    result.setBody((Object)new Object[]{ext});
                    return result;
                }
                log.warn("Adapter was not available");
                break;
            }
            default: {
                log.error("Unhandled CommandMessageExt request: {}", (Object)msg);
                String errMsg = String.format("Don't know how to handle %s", msg);
                return FlexMessagingService.returnError((AbstractMessage)msg, "notImplemented", errMsg, errMsg);
            }
        }
        AcknowledgeMessageExt result = new AcknowledgeMessageExt();
        result.setClientId(clientId);
        result.setCorrelationId(msg.getMessageId());
        return result;
    }

    public Message handleRequest(CommandMessage msg) {
        log.debug("Handle CommandMessage request");
        log.trace("{}", (Object)msg);
        this.setClientId((AbstractMessage)msg);
        String clientId = msg.getClientId();
        Map headers = msg.getHeaders();
        log.debug("Headers: {}", (Object)headers);
        if (headers.containsKey("DSId")) {
            headers.put("DSId", msg.getClientId());
        }
        String destination = msg.getDestination();
        log.debug("Destination: {}", (Object)destination);
        switch (msg.operation) {
            case 5: {
                break;
            }
            case 2: {
                log.debug("Poll: {}", (Object)clientId);
                if (!this.registrations.containsKey(clientId)) break;
                ServiceAdapter adapter = (ServiceAdapter)this.registrations.get(clientId);
                if (adapter != null) {
                    CommandMessage result = new CommandMessage();
                    result.setOperation(4);
                    AsyncMessageExt ext = new AsyncMessageExt();
                    ext.setClientId(clientId);
                    ext.setCorrelationId(msg.getMessageId());
                    ext.setDestination("Red5Chat");
                    ext.setBody(adapter.manage(msg));
                    result.setBody((Object)new Object[]{ext});
                    return result;
                }
                log.debug("Adapter was not available");
                break;
            }
            case 0: {
                Object endpoint;
                log.debug("Subscribe: {}", (Object)clientId);
                if (!StringUtils.isNotBlank((CharSequence)destination) || !this.endpoints.containsKey(destination) || !((endpoint = this.endpoints.get(destination)) instanceof ServiceAdapter)) break;
                ServiceAdapter adapter = (ServiceAdapter)endpoint;
                boolean subscribed = (Boolean)adapter.manage(msg);
                if (subscribed) {
                    log.debug("Client was subscribed");
                    this.registerClientToAdapter(clientId, adapter);
                    break;
                }
                log.debug("Client was not subscribed");
                break;
            }
            case 1: {
                ServiceAdapter adapter;
                log.trace("Unsubscribe: {}", (Object)clientId);
                if (this.registrations.containsKey(clientId)) {
                    adapter = (ServiceAdapter)this.registrations.get(clientId);
                    boolean unsubscribed = (Boolean)adapter.manage(msg);
                    if (unsubscribed) {
                        log.debug("Client was unsubscribed");
                        this.unregisterClientFromAdapter(clientId);
                        break;
                    }
                    log.debug("Client was not unsubscribed");
                    break;
                }
                log.debug("Client was not subscribed");
                break;
            }
            default: {
                log.error("Unknown CommandMessage request: {}", (Object)msg);
                String errMsg = String.format("Don't know how to handle %s", msg);
                return FlexMessagingService.returnError((AbstractMessage)msg, "notImplemented", errMsg, errMsg);
            }
        }
        AcknowledgeMessage result = new AcknowledgeMessage();
        result.setBody(msg.getBody());
        result.setClientId(clientId);
        result.setCorrelationId(msg.getMessageId());
        result.setHeaders(headers);
        if (StringUtils.isNotBlank((CharSequence)destination)) {
            result.setDestination(destination);
        }
        return result;
    }

    private void evaluateDataUpdate(DataMessage msg, DataMessage event) {
        switch (event.operation) {
            case 3: {
                List contents = (List)event.body;
                List attributeNames = (List)contents.get(0);
                Map oldValues = (Map)contents.get(1);
                Map newValues = (Map)contents.get(2);
                break;
            }
            default: {
                log.error("Unknown data update request: {}", (Object)event);
            }
        }
    }

    public AsyncMessage handleRequest(DataMessage msg) {
        log.debug("Handle DataMessage request");
        log.trace("{}", (Object)msg);
        this.setClientId((AbstractMessage)msg);
        SequencedMessage result = new SequencedMessage();
        result.clientId = msg.clientId;
        result.destination = msg.destination;
        result.correlationId = msg.messageId;
        switch (msg.operation) {
            case 10: {
                result.body = new Object[]{msg.body};
                result.sequenceId = 0L;
                result.sequenceSize = 1L;
                break;
            }
            case 7: {
                for (DataMessage event : (List)msg.body) {
                    this.evaluateDataUpdate(msg, event);
                }
                AcknowledgeMessage res = new AcknowledgeMessage();
                res.clientId = msg.clientId;
                res.destination = msg.destination;
                res.correlationId = msg.messageId;
                res.body = msg.body;
                return res;
            }
            default: {
                log.error("Unknown DataMessage request: {}", (Object)msg);
                String errMsg = String.format("Don't know how to handle %s", msg);
                return FlexMessagingService.returnError((AbstractMessage)msg, "notImplemented", errMsg, errMsg);
            }
        }
        return result;
    }

    public Message handleRequest(AbstractMessage msg) {
        log.debug("Handle AbstractMessage request");
        log.trace("{}", (Object)msg);
        this.setClientId(msg);
        Object endpoint = this.endpoints.get(msg.getDestination());
        log.debug("End point / destination: {}", endpoint);
        if (endpoint == null) {
            String errMsg = String.format("Endpoint %s doesn't exist.", msg.getDestination());
            log.debug("{} ({})", (Object)errMsg, (Object)msg);
            return FlexMessagingService.returnError(msg, "Server.Invoke.Error", errMsg, errMsg);
        }
        Map headers = msg.getHeaders();
        log.debug("Headers: {}", (Object)headers);
        if (headers.containsKey("DSId")) {
            headers.remove("DSId");
        }
        if (headers.containsKey("DSEndpoint")) {
            headers.remove("DSEndpoint");
        }
        if (endpoint instanceof ServiceAdapter) {
            log.debug("Endpoint is a ServiceAdapter so message will be invoked");
            AcknowledgeMessage result = new AcknowledgeMessage();
            result.setClientId(msg.getClientId());
            result.setCorrelationId(msg.getMessageId());
            result.setDestination(msg.getDestination());
            result.setHeaders(headers);
            ServiceAdapter adapter = (ServiceAdapter)endpoint;
            Object o = adapter.invoke((Message)msg);
            result.setBody((Object)new Object[]{o});
            return result;
        }
        log.error("Unknown Flex compatibility request: {}", (Object)msg);
        String errMsg = String.format("Don't know how to handle %s", msg);
        return FlexMessagingService.returnError(msg, "notImplemented", errMsg, errMsg);
    }

    private void setClientId(AbstractMessage msg) {
        String clientId = msg.getClientId();
        if (clientId == null || "null".equals(clientId)) {
            log.trace("Dump: {}", (Object)msg);
            IClient client = Red5.getConnectionLocal().getClient();
            if (client != null) {
                clientId = client.getId();
                msg.setClientId(RandomGUID.getPrettyFormatted((String)clientId));
            } else {
                msg.setClientId(UUID.randomUUID().toString());
            }
        }
    }

    private final void registerClientToAdapter(String clientId, ServiceAdapter adapter) {
        if (this.registrations == null) {
            this.registrations = new ConcurrentHashMap<String, ServiceAdapter>();
        }
        this.registrations.put(clientId, adapter);
    }

    private final void unregisterClientFromAdapter(String clientId) {
        this.registrations.remove(clientId);
    }
}

