/*
 * Decompiled with CFR 0.152.
 */
package org.red5.logging;

import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class W3CAppender
extends FileAppender<LoggingEvent> {
    private static boolean headerWritten;
    private static String events;
    private static List<String> eventsList;
    private static String fields;
    private static LinkedList<String> fieldList;

    public W3CAppender() {
        this.setPrudent(true);
    }

    public void setEvents(String events) {
        String[] arr;
        W3CAppender.events = events;
        for (String s : arr = events.split(";")) {
            eventsList.add(s);
        }
    }

    public String getEvents() {
        return events;
    }

    public void setFields(String fields) {
        String[] arr;
        W3CAppender.fields = fields;
        for (String s : arr = fields.split(";")) {
            fieldList.add(s);
        }
    }

    public String getFields() {
        return fields;
    }

    public synchronized void doAppend(LoggingEvent event) {
        String message = event.getFormattedMessage();
        if (!message.startsWith("W3C")) {
            return;
        }
        StringBuilder sbuf = new StringBuilder(128);
        if (!headerWritten) {
            StringBuilder sb = new StringBuilder("#Software: ");
            sb.append("Red5 Server 1.2.2");
            sb.append("\n#Version: 1.0");
            sb.append("\n#Date: ");
            sb.append(new Date());
            sb.append("\n#Fields: ");
            for (String field : fields.split(";")) {
                sb.append(field);
                sb.append(' ');
            }
            sb.append('\n');
            sbuf.append(sb.toString());
            headerWritten = true;
            sb = null;
        }
        String[] arr = message.split(" ");
        HashMap<String, String> elements = new HashMap<String, String>(arr.length);
        int i = 0;
        for (String s : arr) {
            i = s.indexOf(58);
            if (i == -1) continue;
            String key = s.substring(0, i);
            String value = s.substring(i + 1);
            elements.put(key, value);
        }
        if (!events.equals("*") && !eventsList.contains(elements.get("x-event"))) {
            elements.clear();
            elements = null;
            sbuf = null;
            return;
        }
        Calendar cal = GregorianCalendar.getInstance();
        cal.clear();
        cal.setTimeInMillis(event.getTimeStamp());
        for (String field : fieldList) {
            String value = (String)elements.get(field);
            if (value == null) {
                if ("date".equals(field)) {
                    sbuf.append(cal.get(2) + 1);
                    sbuf.append('/');
                    sbuf.append(cal.get(5));
                    sbuf.append('/');
                    sbuf.append(cal.get(1));
                } else if ("time".equals(field)) {
                    sbuf.append(cal.get(11));
                    sbuf.append(':');
                    int min = cal.get(12);
                    if (min < 10) {
                        sbuf.append('0');
                        sbuf.append(min);
                    } else {
                        sbuf.append(min);
                    }
                } else if ("s-ip".equals(field)) {
                    sbuf.append("127.0.0.1");
                } else if ("x-pid".equals(field)) {
                    sbuf.append(event.getThreadName());
                } else {
                    sbuf.append('\t');
                }
            } else {
                sbuf.append(value);
            }
            sbuf.append(' ');
        }
        sbuf.append('\n');
        try {
            event.setMessage(sbuf.toString());
            this.writeOut(event);
        }
        catch (IOException ioe) {
            this.addStatus((Status)new ErrorStatus("IO failure in appender", (Object)this, (Throwable)ioe));
        }
    }

    static {
        eventsList = new ArrayList<String>();
        fieldList = new LinkedList();
    }
}

