/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.event;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.codec.VideoCodec;
import org.red5.io.IoConstants;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.stream.IStreamPacket;
import org.red5.server.net.rtmp.event.BaseEvent;
import org.red5.server.stream.IStreamData;

public class VideoData
extends BaseEvent
implements IoConstants,
IStreamData<VideoData>,
IStreamPacket {
    private static final long serialVersionUID = 5538859593815804830L;
    protected IoBuffer data;
    private byte dataType = (byte)9;
    protected FrameType frameType = FrameType.UNKNOWN;
    protected int codecId = -1;
    protected boolean config;
    protected boolean endOfSequence;

    public VideoData() {
        this(IoBuffer.allocate((int)0).flip());
    }

    public VideoData(IoBuffer data) {
        super(IEvent.Type.STREAM_DATA);
        this.setData(data);
    }

    public VideoData(IoBuffer data, boolean copy) {
        super(IEvent.Type.STREAM_DATA);
        if (copy) {
            byte[] array = new byte[data.remaining()];
            data.mark();
            data.get(array);
            data.reset();
            this.setData(array);
        } else {
            this.setData(data);
        }
    }

    @Override
    public byte getDataType() {
        return this.dataType;
    }

    public void setDataType(byte dataType) {
        this.dataType = dataType;
    }

    @Override
    public IoBuffer getData() {
        return this.data;
    }

    public void setData(IoBuffer data) {
        this.data = data;
        if (data != null && data.limit() > 0) {
            data.mark();
            int firstByte = data.get(0) & 0xFF;
            this.codecId = firstByte & 0xF;
            if (this.codecId == VideoCodec.AVC.getId()) {
                int secondByte = data.get(1) & 0xFF;
                this.config = secondByte == 0;
                this.endOfSequence = secondByte == 2;
            }
            data.reset();
            int frameType = (firstByte & 0xF0) >> 4;
            this.frameType = frameType == 1 ? FrameType.KEYFRAME : (frameType == 2 ? FrameType.INTERFRAME : (frameType == 3 ? FrameType.DISPOSABLE_INTERFRAME : FrameType.UNKNOWN));
        }
    }

    public void setData(byte[] data) {
        this.setData(IoBuffer.wrap((byte[])data));
    }

    public FrameType getFrameType() {
        return this.frameType;
    }

    public int getCodecId() {
        return this.codecId;
    }

    public boolean isConfig() {
        return this.config;
    }

    public boolean isEndOfSequence() {
        return this.endOfSequence;
    }

    @Override
    protected void releaseInternal() {
        if (this.data != null) {
            IoBuffer localData = this.data;
            this.data = null;
            localData.clear();
            localData.free();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.frameType = (FrameType)((Object)in.readObject());
        byte[] byteBuf = (byte[])in.readObject();
        if (byteBuf != null) {
            this.setData(byteBuf);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject((Object)this.frameType);
        if (this.data != null) {
            if (this.data.hasArray()) {
                out.writeObject(this.data.array());
            } else {
                byte[] array = new byte[this.data.remaining()];
                this.data.mark();
                this.data.get(array);
                this.data.reset();
                out.writeObject(array);
            }
        } else {
            out.writeObject(null);
        }
    }

    public VideoData duplicate() throws IOException, ClassNotFoundException {
        VideoData result = new VideoData();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        this.writeExternal(oos);
        oos.close();
        byte[] buf = baos.toByteArray();
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        ObjectInputStream ois = new ObjectInputStream(bais);
        result.readExternal(ois);
        ois.close();
        bais.close();
        if (this.header != null) {
            result.setHeader(this.header.clone());
        }
        result.setSourceType(this.sourceType);
        result.setSource(this.source);
        result.setTimestamp(this.timestamp);
        return result;
    }

    public String toString() {
        return String.format("Video - ts: %s length: %s", this.getTimestamp(), this.data != null ? this.data.limit() : 48);
    }

    public static enum FrameType {
        UNKNOWN,
        KEYFRAME,
        INTERFRAME,
        DISPOSABLE_INTERFRAME,
        END_OF_SEQUENCE;

    }
}

