/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import org.apache.mina.core.buffer.IoBuffer;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IClientStream;
import org.red5.server.api.stream.IRtmpSampleAccess;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.Invoke;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.net.rtmp.message.Header;
import org.red5.server.net.rtmp.message.Packet;
import org.red5.server.net.rtmp.status.Status;
import org.red5.server.service.Call;
import org.red5.server.service.PendingCall;
import org.red5.server.stream.IStreamData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Channel {
    protected static Logger log = LoggerFactory.getLogger(Channel.class);
    private static final String CALL_ON_STATUS = "onStatus";
    private final RTMPConnection connection;
    private final int id;

    public Channel(RTMPConnection conn, int channelId) {
        assert (conn != null);
        this.connection = conn;
        this.id = channelId;
    }

    public void close() {
        log.debug("Closing channel: {}", (Object)this.id);
        this.connection.closeChannel(this.id);
    }

    public int getId() {
        return this.id;
    }

    protected RTMPConnection getConnection() {
        return this.connection;
    }

    public void write(IRTMPEvent event) {
        if (!this.connection.isClosed()) {
            IClientStream stream = this.connection.getStreamByChannelId(this.id);
            if (this.id > 3 && stream == null) {
                log.warn("Non-existant stream for channel id: {}, session: {} discarding: {}", new Object[]{this.id, this.connection.getSessionId(), event});
            }
            Number streamId = stream == null ? (Number)0 : (Number)stream.getStreamId();
            this.write(event, streamId);
        } else {
            log.debug("Connection {} is closed, cannot write to channel: {}", (Object)this.connection.getSessionId(), (Object)this.id);
        }
    }

    private void write(IRTMPEvent event, Number streamId) {
        log.trace("write to stream id: {} channel: {}", (Object)streamId, (Object)this.id);
        Header header = new Header();
        Packet packet = new Packet(header, event);
        header.setChannelId(this.id);
        int ts = event.getTimestamp();
        if (ts != 0) {
            header.setTimer(event.getTimestamp());
        }
        header.setStreamId(streamId);
        header.setDataType(event.getDataType());
        this.connection.write(packet);
    }

    private void discard(IRTMPEvent event) {
        if (event instanceof IStreamData) {
            log.debug("Discarding: {}", (Object)((IStreamData)((Object)event)).toString());
            IoBuffer data = ((IStreamData)((Object)event)).getData();
            if (data != null) {
                log.trace("Freeing discarded event data");
                data.free();
                Object var2_2 = null;
            }
        }
        event.setHeader(null);
    }

    public void sendStatus(Status status) {
        if (this.connection != null) {
            boolean andReturn = !status.getCode().equals("NetStream.Data.Start");
            Invoke event = new Invoke();
            if (andReturn) {
                IScope scope;
                PendingCall call = new PendingCall(null, CALL_ON_STATUS, new Object[]{status});
                if (status.getCode().equals("NetStream.Play.Start") && (scope = this.connection.getScope()).getContext().getApplicationContext().containsBean("rtmpSampleAccess")) {
                    IRtmpSampleAccess sampleAccess = (IRtmpSampleAccess)scope.getContext().getApplicationContext().getBean("rtmpSampleAccess");
                    boolean videoAccess = sampleAccess.isVideoAllowed(scope);
                    boolean audioAccess = sampleAccess.isAudioAllowed(scope);
                    if (videoAccess || audioAccess) {
                        Call call2 = new Call(null, "|RtmpSampleAccess", null);
                        Notify notify = new Notify();
                        notify.setCall(call2);
                        notify.setData(IoBuffer.wrap((byte[])new byte[]{1, (byte)(audioAccess ? 1 : 0), 1, (byte)(videoAccess ? 1 : 0)}));
                        this.write(notify, this.connection.getStreamIdForChannelId(this.id));
                    }
                }
                event.setCall(call);
            } else {
                Call call = new Call(null, CALL_ON_STATUS, new Object[]{status});
                event.setCall(call);
            }
            this.write(event, this.connection.getStreamIdForChannelId(this.id));
        }
    }

    public String toString() {
        if (this.connection != null) {
            return "Channel [id=" + this.id + ", stream id=" + this.connection.getStreamIdForChannelId(this.id) + ", session=" + this.connection.getSessionId() + "]";
        }
        return "Channel [id=" + this.id + "]";
    }
}

