/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.javapoet;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import java.util.Collection;
import javax.lang.model.element.Modifier;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractMethodSpecAssert<S extends AbstractMethodSpecAssert<S, A>, A extends MethodSpec>
extends AbstractObjectAssert<S, A> {
    protected AbstractMethodSpecAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S isConstructor() {
        this.isNotNull();
        if (!((MethodSpec)this.actual).isConstructor()) {
            this.failWithMessage("\nExpecting that actual MethodSpec is constructor but is not.", new Object[0]);
        }
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S isNotConstructor() {
        this.isNotNull();
        if (((MethodSpec)this.actual).isConstructor()) {
            this.failWithMessage("\nExpecting that actual MethodSpec is not constructor but is.", new Object[0]);
        }
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasAnnotations(AnnotationSpec ... annotations) {
        this.isNotNull();
        if (annotations == null) {
            this.failWithMessage("Expecting annotations parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).annotations, (Object[])annotations);
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasAnnotations(Collection<? extends AnnotationSpec> annotations) {
        this.isNotNull();
        if (annotations == null) {
            this.failWithMessage("Expecting annotations parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractMethodSpecAssert)this.myself));
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).annotations, annotations.toArray());
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasOnlyAnnotations(AnnotationSpec ... annotations) {
        this.isNotNull();
        if (annotations == null) {
            this.failWithMessage("Expecting annotations parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).annotations, (Object[])annotations);
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasOnlyAnnotations(Collection<? extends AnnotationSpec> annotations) {
        this.isNotNull();
        if (annotations == null) {
            this.failWithMessage("Expecting annotations parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractMethodSpecAssert)this.myself));
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).annotations, annotations.toArray());
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S doesNotHaveAnnotations(AnnotationSpec ... annotations) {
        this.isNotNull();
        if (annotations == null) {
            this.failWithMessage("Expecting annotations parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).annotations, (Object[])annotations);
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S doesNotHaveAnnotations(Collection<? extends AnnotationSpec> annotations) {
        this.isNotNull();
        if (annotations == null) {
            this.failWithMessage("Expecting annotations parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractMethodSpecAssert)this.myself));
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).annotations, annotations.toArray());
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasNoAnnotations() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have annotations but had :\n  <%s>";
        if (((MethodSpec)this.actual).annotations.iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((MethodSpec)this.actual).annotations});
        }
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasCode(CodeBlock code) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting code of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CodeBlock actualCode = ((MethodSpec)this.actual).code;
        if (!Objects.areEqual((Object)actualCode, (Object)code)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, code, actualCode});
        }
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasDefaultValue(CodeBlock defaultValue) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting defaultValue of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CodeBlock actualDefaultValue = ((MethodSpec)this.actual).defaultValue;
        if (!Objects.areEqual((Object)actualDefaultValue, (Object)defaultValue)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, defaultValue, actualDefaultValue});
        }
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasExceptions(TypeName ... exceptions) {
        this.isNotNull();
        if (exceptions == null) {
            this.failWithMessage("Expecting exceptions parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).exceptions, (Object[])exceptions);
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasExceptions(Collection<? extends TypeName> exceptions) {
        this.isNotNull();
        if (exceptions == null) {
            this.failWithMessage("Expecting exceptions parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractMethodSpecAssert)this.myself));
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).exceptions, exceptions.toArray());
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasOnlyExceptions(TypeName ... exceptions) {
        this.isNotNull();
        if (exceptions == null) {
            this.failWithMessage("Expecting exceptions parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).exceptions, (Object[])exceptions);
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasOnlyExceptions(Collection<? extends TypeName> exceptions) {
        this.isNotNull();
        if (exceptions == null) {
            this.failWithMessage("Expecting exceptions parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractMethodSpecAssert)this.myself));
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).exceptions, exceptions.toArray());
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S doesNotHaveExceptions(TypeName ... exceptions) {
        this.isNotNull();
        if (exceptions == null) {
            this.failWithMessage("Expecting exceptions parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).exceptions, (Object[])exceptions);
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S doesNotHaveExceptions(Collection<? extends TypeName> exceptions) {
        this.isNotNull();
        if (exceptions == null) {
            this.failWithMessage("Expecting exceptions parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractMethodSpecAssert)this.myself));
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).exceptions, exceptions.toArray());
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasNoExceptions() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have exceptions but had :\n  <%s>";
        if (((MethodSpec)this.actual).exceptions.iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((MethodSpec)this.actual).exceptions});
        }
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasJavadoc(CodeBlock javadoc) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting javadoc of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CodeBlock actualJavadoc = ((MethodSpec)this.actual).javadoc;
        if (!Objects.areEqual((Object)actualJavadoc, (Object)javadoc)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, javadoc, actualJavadoc});
        }
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasModifiers(Modifier ... modifiers) {
        this.isNotNull();
        if (modifiers == null) {
            this.failWithMessage("Expecting modifiers parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).modifiers, (Object[])modifiers);
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasModifiers(Collection<? extends Modifier> modifiers) {
        this.isNotNull();
        if (modifiers == null) {
            this.failWithMessage("Expecting modifiers parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractMethodSpecAssert)this.myself));
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).modifiers, modifiers.toArray());
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasOnlyModifiers(Modifier ... modifiers) {
        this.isNotNull();
        if (modifiers == null) {
            this.failWithMessage("Expecting modifiers parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).modifiers, (Object[])modifiers);
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasOnlyModifiers(Collection<? extends Modifier> modifiers) {
        this.isNotNull();
        if (modifiers == null) {
            this.failWithMessage("Expecting modifiers parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractMethodSpecAssert)this.myself));
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).modifiers, modifiers.toArray());
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S doesNotHaveModifiers(Modifier ... modifiers) {
        this.isNotNull();
        if (modifiers == null) {
            this.failWithMessage("Expecting modifiers parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).modifiers, (Object[])modifiers);
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S doesNotHaveModifiers(Collection<? extends Modifier> modifiers) {
        this.isNotNull();
        if (modifiers == null) {
            this.failWithMessage("Expecting modifiers parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractMethodSpecAssert)this.myself));
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).modifiers, modifiers.toArray());
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasNoModifiers() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have modifiers but had :\n  <%s>";
        if (((MethodSpec)this.actual).modifiers.iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((MethodSpec)this.actual).modifiers});
        }
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasName(String name) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualName = ((MethodSpec)this.actual).name;
        if (!Objects.areEqual((Object)actualName, (Object)name)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, name, actualName});
        }
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasParameters(ParameterSpec ... parameters) {
        this.isNotNull();
        if (parameters == null) {
            this.failWithMessage("Expecting parameters parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).parameters, (Object[])parameters);
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasParameters(Collection<? extends ParameterSpec> parameters) {
        this.isNotNull();
        if (parameters == null) {
            this.failWithMessage("Expecting parameters parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractMethodSpecAssert)this.myself));
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).parameters, parameters.toArray());
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasOnlyParameters(ParameterSpec ... parameters) {
        this.isNotNull();
        if (parameters == null) {
            this.failWithMessage("Expecting parameters parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).parameters, (Object[])parameters);
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasOnlyParameters(Collection<? extends ParameterSpec> parameters) {
        this.isNotNull();
        if (parameters == null) {
            this.failWithMessage("Expecting parameters parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractMethodSpecAssert)this.myself));
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).parameters, parameters.toArray());
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S doesNotHaveParameters(ParameterSpec ... parameters) {
        this.isNotNull();
        if (parameters == null) {
            this.failWithMessage("Expecting parameters parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).parameters, (Object[])parameters);
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S doesNotHaveParameters(Collection<? extends ParameterSpec> parameters) {
        this.isNotNull();
        if (parameters == null) {
            this.failWithMessage("Expecting parameters parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractMethodSpecAssert)this.myself));
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).parameters, parameters.toArray());
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasNoParameters() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have parameters but had :\n  <%s>";
        if (((MethodSpec)this.actual).parameters.iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((MethodSpec)this.actual).parameters});
        }
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasReturnType(TypeName returnType) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting returnType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        TypeName actualReturnType = ((MethodSpec)this.actual).returnType;
        if (!Objects.areEqual((Object)actualReturnType, (Object)returnType)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, returnType, actualReturnType});
        }
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasTypeVariables(TypeVariableName ... typeVariables) {
        this.isNotNull();
        if (typeVariables == null) {
            this.failWithMessage("Expecting typeVariables parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).typeVariables, (Object[])typeVariables);
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasTypeVariables(Collection<? extends TypeVariableName> typeVariables) {
        this.isNotNull();
        if (typeVariables == null) {
            this.failWithMessage("Expecting typeVariables parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractMethodSpecAssert)this.myself));
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).typeVariables, typeVariables.toArray());
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasOnlyTypeVariables(TypeVariableName ... typeVariables) {
        this.isNotNull();
        if (typeVariables == null) {
            this.failWithMessage("Expecting typeVariables parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).typeVariables, (Object[])typeVariables);
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasOnlyTypeVariables(Collection<? extends TypeVariableName> typeVariables) {
        this.isNotNull();
        if (typeVariables == null) {
            this.failWithMessage("Expecting typeVariables parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractMethodSpecAssert)this.myself));
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).typeVariables, typeVariables.toArray());
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S doesNotHaveTypeVariables(TypeVariableName ... typeVariables) {
        this.isNotNull();
        if (typeVariables == null) {
            this.failWithMessage("Expecting typeVariables parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).typeVariables, (Object[])typeVariables);
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S doesNotHaveTypeVariables(Collection<? extends TypeVariableName> typeVariables) {
        this.isNotNull();
        if (typeVariables == null) {
            this.failWithMessage("Expecting typeVariables parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractMethodSpecAssert)this.myself));
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MethodSpec)this.actual).typeVariables, typeVariables.toArray());
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S hasNoTypeVariables() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have typeVariables but had :\n  <%s>";
        if (((MethodSpec)this.actual).typeVariables.iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((MethodSpec)this.actual).typeVariables});
        }
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S isVarargs() {
        this.isNotNull();
        if (!((MethodSpec)this.actual).varargs) {
            this.failWithMessage("\nExpecting that actual MethodSpec is varargs but is not.", new Object[0]);
        }
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }

    public S isNotVarargs() {
        this.isNotNull();
        if (((MethodSpec)this.actual).varargs) {
            this.failWithMessage("\nExpecting that actual MethodSpec is not varargs but is.", new Object[0]);
        }
        return (S)((Object)((AbstractMethodSpecAssert)this.myself));
    }
}

