package com.squareup.javapoet;

import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ArrayTypeName} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractArrayTypeNameAssert<S extends AbstractArrayTypeNameAssert<S, A>, A extends ArrayTypeName> extends AbstractTypeNameAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractArrayTypeNameAssert}</code> to make assertions on actual ArrayTypeName.
   * @param actual the ArrayTypeName we want to make assertions on.
   */
  protected AbstractArrayTypeNameAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ArrayTypeName's componentType is equal to the given one.
   * @param componentType the given componentType to compare the actual ArrayTypeName's componentType to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ArrayTypeName's componentType is not equal to the given one.
   */
  public S hasComponentType(TypeName componentType) {
    // check that actual ArrayTypeName we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting componentType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    TypeName actualComponentType = actual.componentType;
    if (!Objects.areEqual(actualComponentType, componentType)) {
      failWithMessage(assertjErrorMessage, actual, componentType, actualComponentType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
