/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.tagresolver;

import java.io.File;
import java.util.ArrayDeque;
import java.util.Deque;
import org.raml.parser.visitor.IncludeInfo;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

public class ContextPath {
    private Deque<IncludeInfo> includeStack = new ArrayDeque<IncludeInfo>();

    public ContextPath() {
    }

    public ContextPath(ContextPath contextPath) {
        this.includeStack = new ArrayDeque<IncludeInfo>(contextPath.includeStack);
    }

    public ContextPath(IncludeInfo includeInfo) {
        this.includeStack.add(includeInfo);
    }

    public void pushRoot(String absoluteFile) {
        if (this.includeStack.size() > 0) {
            throw new IllegalStateException("Non empty stack");
        }
        this.includeStack.add(new IncludeInfo(absoluteFile));
    }

    public static String resolveAbsolutePath(String relativeFile, String parentPath) {
        if (relativeFile.startsWith("classpath:")) {
            return relativeFile.substring(relativeFile.indexOf(":") + 1);
        }
        if (relativeFile.startsWith("http:") || relativeFile.startsWith("https:") || relativeFile.startsWith("file:")) {
            return relativeFile;
        }
        return parentPath + relativeFile;
    }

    public String resolveAbsolutePath(String relativeFile) {
        return ContextPath.resolveAbsolutePath(relativeFile, this.getPartentPath());
    }

    private String getPartentPath() {
        int idx = this.includeStack.peek().getIncludeName().lastIndexOf(File.separator) + 1;
        return this.includeStack.peek().getIncludeName().substring(0, idx);
    }

    public IncludeInfo peek() {
        return this.includeStack.peek();
    }

    public IncludeInfo pop() {
        return this.includeStack.pop();
    }

    public void push(IncludeInfo includeInfo) {
        this.includeStack.push(includeInfo);
    }

    public void push(ScalarNode node) {
        this.push(new IncludeInfo(node, this.getPartentPath()));
    }

    public void push(Tag tag) {
        this.push(new IncludeInfo(tag));
    }

    public int size() {
        return this.includeStack.size();
    }
}

