/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.raml.parser.ResolveResourceException;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.rule.LSInputImpl;
import org.raml.parser.tagresolver.ContextPath;
import org.raml.parser.utils.StreamUtils;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class XsdResourceResolver
implements LSResourceResolver {
    private final ContextPath contextPath;
    private final ResourceLoader resourceLoader;

    public XsdResourceResolver(ContextPath contextPath, ResourceLoader resourceLoader) {
        this.contextPath = contextPath;
        this.resourceLoader = resourceLoader;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        byte[] content;
        String path = this.contextPath.resolveAbsolutePath(systemId);
        if (path == null || path.startsWith("http://")) {
            return null;
        }
        InputStream inputStream = this.resourceLoader.fetchResource(path);
        if (inputStream == null) {
            return null;
        }
        try {
            content = IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new ResolveResourceException(e);
        }
        LSInputImpl input = new LSInputImpl(publicId, systemId, baseURI, new ByteArrayInputStream(content), StreamUtils.detectEncoding(content));
        return input;
    }
}

