/*
 * Decompiled with CFR 0.152.
 */
package org.raml.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.SecurityReference;
import org.raml.model.parameter.UriParameter;
import org.raml.parser.annotation.Key;
import org.raml.parser.annotation.Mapping;
import org.raml.parser.annotation.Parent;
import org.raml.parser.annotation.Scalar;
import org.raml.parser.annotation.Sequence;
import org.raml.parser.resolver.ResourceHandler;
import org.raml.parser.rule.SecurityReferenceSequenceRule;
import org.raml.parser.rule.UriParametersRule;

public class Resource
implements Serializable {
    private static final long serialVersionUID = -1039592210175332252L;
    @Parent
    private Resource parentResource;
    @Scalar
    private String displayName;
    @Scalar
    private String description;
    @Parent(property="uri")
    private String parentUri;
    @Key
    private String relativeUri;
    @Mapping
    private Map<String, UriParameter> uriParameters = new LinkedHashMap<String, UriParameter>();
    @Scalar
    private String type;
    @Sequence
    private List<String> is = new ArrayList<String>();
    @Sequence(rule=SecurityReferenceSequenceRule.class)
    private List<SecurityReference> securedBy = new ArrayList<SecurityReference>();
    @Mapping(rule=UriParametersRule.class)
    private Map<String, List<UriParameter>> baseUriParameters = new LinkedHashMap<String, List<UriParameter>>();
    @Mapping(implicit=true)
    private Map<ActionType, Action> actions = new LinkedHashMap<ActionType, Action>();
    @Mapping(handler=ResourceHandler.class, implicit=true)
    private Map<String, Resource> resources = new LinkedHashMap<String, Resource>();

    public void setRelativeUri(String relativeUri) {
        this.relativeUri = relativeUri;
    }

    public String getParentUri() {
        return this.parentUri;
    }

    public void setParentUri(String parentUri) {
        this.parentUri = parentUri;
    }

    public void setUriParameters(Map<String, UriParameter> uriParameters) {
        this.uriParameters = uriParameters;
    }

    public Map<ActionType, Action> getActions() {
        return this.actions;
    }

    public void setActions(Map<ActionType, Action> actions) {
        this.actions = actions;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRelativeUri() {
        return this.relativeUri;
    }

    public String getUri() {
        return this.parentUri + this.relativeUri;
    }

    public Action getAction(ActionType name) {
        return this.actions.get((Object)name);
    }

    public Action getAction(String name) {
        return this.actions.get((Object)ActionType.valueOf(name.toUpperCase()));
    }

    public Map<String, Resource> getResources() {
        return this.resources;
    }

    public void setResources(Map<String, Resource> resources) {
        this.resources = resources;
    }

    public Map<String, UriParameter> getUriParameters() {
        return this.uriParameters;
    }

    public Map<String, UriParameter> getResolvedUriParameters() {
        if (this.parentResource != null) {
            HashMap<String, UriParameter> uriParams = new HashMap<String, UriParameter>(this.parentResource.getUriParameters());
            uriParams.putAll(this.uriParameters);
            return uriParams;
        }
        return this.uriParameters;
    }

    public List<String> getIs() {
        return this.is;
    }

    public void setIs(List<String> is) {
        this.is = is;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<SecurityReference> getSecuredBy() {
        return this.securedBy;
    }

    public void setSecuredBy(List<SecurityReference> securedBy) {
        this.securedBy = securedBy;
    }

    public Map<String, List<UriParameter>> getBaseUriParameters() {
        return this.baseUriParameters;
    }

    public void setBaseUriParameters(Map<String, List<UriParameter>> baseUriParameters) {
        this.baseUriParameters = baseUriParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Resource)) {
            return false;
        }
        Resource resource = (Resource)o;
        return this.parentUri.equals(resource.parentUri) && this.relativeUri.equals(resource.relativeUri);
    }

    public int hashCode() {
        int result = this.parentUri.hashCode();
        result = 31 * result + this.relativeUri.hashCode();
        return result;
    }

    public String toString() {
        return "Resource{displayName='" + this.displayName + '\'' + ", uri='" + (this.parentUri != null ? this.getUri() : "-") + "'}";
    }

    public Resource getResource(String path) {
        for (Resource resource : this.resources.values()) {
            if (!path.startsWith(resource.getRelativeUri())) continue;
            if (path.length() == resource.getRelativeUri().length()) {
                return resource;
            }
            if (path.charAt(resource.getRelativeUri().length()) != '/') continue;
            return resource.getResource(path.substring(resource.getRelativeUri().length()));
        }
        return null;
    }

    public Resource getParentResource() {
        return this.parentResource;
    }

    public void setParentResource(Resource parentResource) {
        this.parentResource = parentResource;
    }
}

