/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.model;

import org.raml.v2.api.model.common.ValidationResult;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.Position;

public class RamlValidationResult
implements ValidationResult {
    private String message;
    private String errorPath;
    private Position start;
    private Position end;

    public RamlValidationResult(String message) {
        this.message = message;
    }

    public RamlValidationResult(ErrorNode errorNode) {
        this.message = errorNode.getErrorMessage();
        this.errorPath = errorNode.getPath();
        this.start = errorNode.getStartPosition();
        this.end = errorNode.getEndPosition();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getPath() {
        return this.errorPath;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.message);
        if (this.start != null && this.start.getLine() != -1) {
            builder.append(" -- ").append(this.start.getPath());
            builder.append(" [line=").append(this.start.getLine() + 1).append(", col=").append(this.start.getColumn() + 1).append("]");
        }
        return builder.toString();
    }
}

