/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.type;

import javax.annotation.Nullable;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.nodes.TypeExpressionNode;
import org.raml.v2.internal.impl.commons.rule.RamlErrorNodeFactory;
import org.raml.v2.internal.impl.commons.type.ResolvedCustomFacets;
import org.raml.v2.internal.impl.v10.grammar.Raml10Grammar;
import org.raml.v2.internal.impl.v10.rules.TypesUtils;
import org.raml.v2.internal.impl.v10.type.NumberResolvedType;
import org.raml.v2.internal.impl.v10.type.TypeId;
import org.raml.v2.internal.impl.v10.type.TypeVisitor;
import org.raml.v2.internal.impl.v10.type.XmlFacets;
import org.raml.yagi.framework.grammar.rule.AnyOfRule;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.ErrorNode;

public class IntegerResolvedType
extends NumberResolvedType {
    public IntegerResolvedType(TypeExpressionNode from) {
        super(from);
    }

    public IntegerResolvedType(TypeExpressionNode declarationNode, XmlFacets xmlFacets, Number minimum, Number maximum, Number multiple, String format, ResolvedCustomFacets copy) {
        super(declarationNode, xmlFacets, minimum, maximum, multiple, format, copy);
    }

    @Override
    public NumberResolvedType copy() {
        return new IntegerResolvedType(this.getTypeDeclarationNode(), this.getXmlFacets().copy(), this.getMinimum(), this.getMaximum(), this.getMultiple(), this.getFormat(), this.customFacets.copy());
    }

    @Override
    public <T> T visit(TypeVisitor<T> visitor) {
        return visitor.visitInteger(this);
    }

    @Override
    public void validateCanOverwriteWith(TypeDeclarationNode from) {
        this.customFacets.validate(from);
        Raml10Grammar raml10Grammar = new Raml10Grammar();
        AnyOfRule facetRule = new AnyOfRule(new Rule[0]).add((Rule)raml10Grammar.minimumField((Rule)raml10Grammar.integerType())).add((Rule)raml10Grammar.maximumField((Rule)raml10Grammar.integerType())).add((Rule)raml10Grammar.numberFormat()).add((Rule)raml10Grammar.enumField()).add((Rule)raml10Grammar.multipleOfField((Rule)raml10Grammar.integerType())).addAll(this.customFacets.getRules());
        TypesUtils.validateAllWith((Rule)facetRule, from.getFacets());
    }

    @Override
    public ErrorNode validateFacets() {
        int mult;
        int min = this.getMinimum() != null ? this.getMinimum().intValue() : Integer.MIN_VALUE;
        int max = this.getMaximum() != null ? this.getMaximum().intValue() : Integer.MAX_VALUE;
        int n = mult = this.getMultiple() != null ? this.getMultiple().intValue() : 1;
        if (max < min) {
            return RamlErrorNodeFactory.createInvalidFacetState(this.getTypeName(), "maximum must be greater than or equal to minimum");
        }
        if (this.getMultiple() != null && !this.hasValidMultiplesInRange(min, max, mult)) {
            return RamlErrorNodeFactory.createInvalidFacetState(this.getTypeName(), "There must be at least one multiple of " + mult + " in the given range");
        }
        for (Number thisEnum : this.getEnums()) {
            int value = (Integer)thisEnum;
            if (value < min || value > max) {
                return RamlErrorNodeFactory.createInvalidFacetState(this.getTypeName(), "enum values must be between " + min + " and " + max);
            }
            if (value % mult == 0) continue;
            return RamlErrorNodeFactory.createInvalidFacetState(this.getTypeName(), "enum values must be multiple of " + mult);
        }
        return null;
    }

    private boolean hasValidMultiplesInRange(double min, double max, double mult) {
        if (mult == 0.0) {
            return true;
        }
        double numberOfMultiplesInRange = Math.max(Math.floor(max / mult) - Math.ceil(min / mult) + 1.0, 0.0);
        return numberOfMultiplesInRange > 0.0;
    }

    @Override
    @Nullable
    public String getBuiltinTypeName() {
        return TypeId.INTEGER.getType();
    }
}

