/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.type;

import java.util.List;
import javax.annotation.Nullable;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.nodes.TypeExpressionNode;
import org.raml.v2.internal.impl.commons.type.ResolvedCustomFacets;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.v10.type.UnionResolvedType;

public abstract class BaseType
implements ResolvedType {
    protected ResolvedCustomFacets customFacets;
    private TypeExpressionNode typeNode;

    public BaseType(TypeExpressionNode typeNode, ResolvedCustomFacets customFacets) {
        this.typeNode = typeNode;
        this.customFacets = customFacets;
    }

    @Override
    public ResolvedType setTypeNode(TypeExpressionNode typeNode) {
        BaseType copy = this.copy();
        copy.typeNode = typeNode;
        return copy;
    }

    protected abstract BaseType copy();

    @Override
    public ResolvedCustomFacets customFacets() {
        return this.customFacets;
    }

    @Override
    public final boolean accepts(ResolvedType valueType) {
        if (valueType instanceof UnionResolvedType) {
            List<ResolvedType> toAcceptOptions = ((UnionResolvedType)valueType).of();
            for (ResolvedType toAcceptOption : toAcceptOptions) {
                if (this.doAccept(toAcceptOption)) continue;
                return false;
            }
            return true;
        }
        return this.doAccept(valueType);
    }

    public boolean doAccept(ResolvedType resolvedType) {
        return this.getClass().equals(resolvedType.getClass());
    }

    @Override
    @Nullable
    public String getTypeName() {
        return this.getTypeDeclarationNode() instanceof TypeDeclarationNode ? ((TypeDeclarationNode)this.getTypeDeclarationNode()).getTypeName() : null;
    }

    @Override
    @Nullable
    public String getBuiltinTypeName() {
        return null;
    }

    @Override
    public TypeExpressionNode getTypeDeclarationNode() {
        return this.typeNode;
    }

    @Override
    public void validateState() {
    }
}

