/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.rule;

import javax.annotation.Nonnull;
import org.raml.v2.internal.impl.commons.nodes.AbstractReferenceNode;
import org.raml.v2.internal.impl.commons.nodes.ContextAwareStringNodeImpl;
import org.raml.v2.internal.impl.commons.rule.RamlErrorNodeFactory;
import org.raml.v2.internal.impl.v10.nodes.LibraryRefNode;
import org.raml.yagi.framework.grammar.rule.ClassNodeFactory;
import org.raml.yagi.framework.grammar.rule.NodeFactory;
import org.raml.yagi.framework.nodes.AbstractRamlNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.Position;

public class NodeReferenceFactory
implements NodeFactory {
    private NodeFactory defaultFactory;

    public NodeReferenceFactory(Class<? extends Node> referenceClassNode) {
        this.defaultFactory = new ClassNodeFactory(referenceClassNode);
    }

    public Node create(@Nonnull Node currentNode, Object ... args) {
        String value = (String)args[0];
        return this.parse(currentNode, value, 0);
    }

    public Node parse(Node currentNode, String value, int startLocation) {
        String[] parts = value.split("\\.");
        if (parts.length > 2) {
            return RamlErrorNodeFactory.createInvalidLibraryChaining(value);
        }
        Node result = null;
        Object parent = null;
        int currentShift = value.length();
        for (int i = parts.length - 1; i >= 0; --i) {
            String part = parts[i];
            Position endPosition = currentNode.getStartPosition().rightShift(startLocation + (currentShift -= part.length()) + value.length());
            Position startPosition = currentNode.getStartPosition().rightShift(startLocation + currentShift);
            if (parent == null) {
                parent = this.defaultFactory.create(currentNode, new Object[]{part});
                if (parent instanceof AbstractRamlNode) {
                    ((AbstractRamlNode)parent).setStartPosition(startPosition);
                    ((AbstractRamlNode)parent).setEndPosition(endPosition);
                }
                result = parent;
            } else {
                LibraryRefNode libraryRefNode = new LibraryRefNode(part);
                libraryRefNode.setStartPosition(startPosition);
                libraryRefNode.setEndPosition(endPosition);
                parent.addChild((Node)libraryRefNode);
                parent = libraryRefNode;
                --currentShift;
            }
            if (i != 0 || !(currentNode instanceof ContextAwareStringNodeImpl) || !(parent instanceof AbstractReferenceNode)) continue;
            ((AbstractReferenceNode)((Object)parent)).setContextNode(((ContextAwareStringNodeImpl)currentNode).getReferenceContext());
        }
        return result;
    }
}

