/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.rule.RamlErrorNodeFactory;
import org.raml.v2.internal.impl.commons.type.BaseType;
import org.raml.v2.internal.impl.commons.type.ResolvedCustomFacets;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.commons.type.SchemaBasedResolvedType;
import org.raml.v2.internal.impl.v10.type.TypeVisitor;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.Node;

public class UnionResolvedType
extends BaseType {
    private List<ResolvedType> of;

    public UnionResolvedType(TypeDeclarationNode typeNode, List<ResolvedType> of, ResolvedCustomFacets customFacets) {
        super(typeNode, customFacets);
        this.of = of;
    }

    public List<ResolvedType> of() {
        return this.of;
    }

    protected UnionResolvedType copy() {
        return new UnionResolvedType(this.getTypeDeclarationNode(), new ArrayList<ResolvedType>(this.of), this.customFacets.copy());
    }

    @Override
    public ResolvedType overwriteFacets(TypeDeclarationNode from) {
        ArrayList<ResolvedType> result = new ArrayList<ResolvedType>();
        List<ResolvedType> of = this.of();
        for (ResolvedType resolvedType : of) {
            result.add(resolvedType.overwriteFacets(from));
        }
        return new UnionResolvedType(from, result, this.customFacets.overwriteFacets(from));
    }

    @Override
    public ResolvedType mergeFacets(ResolvedType with) {
        if (with instanceof UnionResolvedType) {
            List<ResolvedType> of = ((UnionResolvedType)with).of();
            return this.mergeWith(of);
        }
        return this.mergeWith(Collections.singletonList(with));
    }

    @Override
    public boolean doAccept(ResolvedType valueType) {
        for (ResolvedType resolvedType : this.of) {
            if (!resolvedType.accepts(valueType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T visit(TypeVisitor<T> visitor) {
        return visitor.visitUnion(this);
    }

    @Override
    public void validateCanOverwriteWith(TypeDeclarationNode from) {
        Node parent = from.getParent();
        for (ResolvedType resolvedType : this.of) {
            if (!parent.findDescendantsWith(ErrorNode.class).isEmpty()) continue;
            resolvedType.validateCanOverwriteWith(from);
        }
    }

    @Override
    public void validateState() {
        Node parent = this.getTypeDeclarationNode().getParent();
        for (ResolvedType resolvedType : this.of) {
            if (!parent.findDescendantsWith(ErrorNode.class).isEmpty()) continue;
            resolvedType.validateState();
        }
        for (ResolvedType resolvedType : this.of) {
            if (!(resolvedType instanceof SchemaBasedResolvedType)) continue;
            this.getTypeDeclarationNode().replaceWith((Node)RamlErrorNodeFactory.createInvalidFacetState(resolvedType.getTypeName(), "union type cannot be of an external type"));
        }
    }

    protected ResolvedType mergeWith(List<ResolvedType> of) {
        ArrayList<ResolvedType> combination = new ArrayList<ResolvedType>();
        ResolvedCustomFacets customFacets = this.customFacets.copy();
        for (ResolvedType localDefinition : this.of()) {
            for (ResolvedType resolvedType : of) {
                customFacets.mergeWith(resolvedType.customFacets());
                combination.add(localDefinition.mergeFacets(resolvedType));
            }
        }
        return new UnionResolvedType(this.getTypeDeclarationNode(), combination, customFacets);
    }
}

