/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.nodes;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.v2.internal.impl.commons.nodes.CustomFacetDefinitionNode;
import org.raml.v2.internal.impl.commons.nodes.FacetNode;
import org.raml.v2.internal.impl.commons.nodes.OverlayableNode;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationField;
import org.raml.v2.internal.impl.commons.nodes.TypeExpressionNode;
import org.raml.v2.internal.impl.commons.rule.RamlErrorNodeFactory;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.v10.type.UnionResolvedType;
import org.raml.yagi.framework.nodes.AbstractObjectNode;
import org.raml.yagi.framework.nodes.AbstractRamlNode;
import org.raml.yagi.framework.nodes.ArrayNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.util.NodeUtils;

public class TypeDeclarationNode
extends AbstractObjectNode
implements TypeExpressionNode,
OverlayableNode {
    private ResolvedType resolvedType;
    private boolean resolvingType = false;

    public TypeDeclarationNode() {
    }

    protected TypeDeclarationNode(TypeDeclarationNode node) {
        super((AbstractRamlNode)node);
    }

    @Nonnull
    public List<TypeExpressionNode> getBaseTypes() {
        ArrayList<TypeExpressionNode> result = new ArrayList<TypeExpressionNode>();
        Node type = this.getTypeValue();
        if (type instanceof ArrayNode) {
            List children = type.getChildren();
            for (Node child : children) {
                result.add((TypeExpressionNode)child);
            }
        } else if (type != null) {
            result.add((TypeExpressionNode)type);
        }
        return result;
    }

    @Nullable
    public ResolvedType getResolvedType() {
        if (this.resolvedType == null) {
            if (this.resolvingType) {
                this.replaceWith((Node)RamlErrorNodeFactory.createRecurrentTypeDefinition(this.getTypeName()));
                return null;
            }
            this.resolvingType = true;
            this.resolvedType = this.resolveTypeDefinition();
            this.resolvingType = false;
        }
        return this.resolvedType;
    }

    private ResolvedType resolveTypeDefinition() {
        ResolvedType result = this.resolveBaseType();
        if (result != null) {
            result = result.overwriteFacets(this);
        }
        return result;
    }

    private ResolvedType resolveBaseType() {
        List<TypeExpressionNode> baseTypes = this.getBaseTypes();
        ResolvedType result = null;
        for (TypeExpressionNode baseType : baseTypes) {
            ResolvedType baseTypeDef = baseType.generateDefinition(this);
            if (result == null) {
                result = baseTypeDef;
                continue;
            }
            if (baseTypeDef instanceof UnionResolvedType && !(result instanceof UnionResolvedType)) {
                result = baseTypeDef.mergeFacets(result);
                continue;
            }
            result = result.mergeFacets(baseTypeDef);
        }
        return result;
    }

    public void validateCanOverwrite() {
        ResolvedType result = this.resolveBaseType();
        if (result != null) {
            result.validateCanOverwriteWith(this);
        }
    }

    public void validateState() {
        ResolvedType resolvedType = this.getResolvedType();
        if (resolvedType != null) {
            resolvedType.validateState();
        }
    }

    public List<CustomFacetDefinitionNode> getCustomFacets() {
        return this.findDescendantsWith(CustomFacetDefinitionNode.class);
    }

    private Node getTypeValue() {
        return NodeUtils.getType((Node)this);
    }

    @Nullable
    public String getTypeName() {
        if (this.getParent() instanceof TypeDeclarationField) {
            return ((SimpleTypeNode)((TypeDeclarationField)this.getParent()).getKey()).getLiteralValue();
        }
        return null;
    }

    @Nonnull
    public Node copy() {
        return new TypeDeclarationNode(this);
    }

    @Override
    @Nullable
    public ResolvedType generateDefinition(TypeDeclarationNode node) {
        return this.resolveTypeDefinition();
    }

    @Override
    public String getTypeExpressionText() {
        return this.getTypeName() + "_AnonymousType";
    }

    public List<FacetNode> getFacets() {
        ArrayList<FacetNode> result = new ArrayList<FacetNode>();
        List children = this.getChildren();
        for (Node child : children) {
            if (!(child instanceof FacetNode)) continue;
            result.add((FacetNode)child);
        }
        return result;
    }
}

