/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v10;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.raml.jaxrs.generator.GenerationException;

public class ExtensionManager {
    private SetMultimap<String, Class> info;

    ExtensionManager(SetMultimap<String, Class> info) {
        this.info = info;
    }

    public static ExtensionManager createExtensionManager() {
        return ExtensionManager.createExtensionManager("META-INF/ramltojaxrs-plugin.properties");
    }

    static ExtensionManager createExtensionManager(String pluginFileName) {
        try {
            LinkedHashMultimap info = LinkedHashMultimap.create();
            Enumeration<URL> resourcesFiles = ExtensionManager.class.getClassLoader().getResources(pluginFileName);
            while (resourcesFiles.hasMoreElements()) {
                URL url = resourcesFiles.nextElement();
                Properties properties = new Properties();
                ExtensionManager.loadProperties(url, properties);
                ExtensionManager.buildPluginNames((SetMultimap<String, Class>)info, properties);
            }
            return new ExtensionManager((SetMultimap<String, Class>)info);
        }
        catch (IOException e) {
            throw new GenerationException(e);
        }
    }

    public Set<Class> getClassesForName(String name) {
        return this.info.get((Object)name);
    }

    private static void buildPluginNames(SetMultimap<String, Class> info, Properties properties) {
        for (String name : properties.stringPropertyNames()) {
            List<Class> classList = ExtensionManager.classList(name, properties.getProperty(name));
            if (info.containsKey((Object)name)) {
                throw new GenerationException("duplicate name in plugins: " + name);
            }
            info.putAll((Object)name, classList);
        }
    }

    private static List<Class> classList(String name, String property) {
        ArrayList<Class> classes = new ArrayList<Class>();
        for (String s : property.split("\\s*,\\s*")) {
            try {
                Class<?> foundClass = Class.forName(s);
                classes.add(foundClass);
            }
            catch (ClassNotFoundException e) {
                throw new GenerationException("class " + s + " not found for plugin name " + name);
            }
        }
        return classes;
    }

    private static void loadProperties(URL url, Properties p) {
        try {
            p.load(url.openStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

