/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v08;

import com.google.common.collect.ImmutableMap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.io.File;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.GObjectType;
import org.raml.jaxrs.generator.GenerationException;
import org.raml.jaxrs.generator.Names;
import org.raml.jaxrs.generator.ScalarTypes;
import org.raml.jaxrs.generator.SchemaTypeFactory;
import org.raml.jaxrs.generator.ramltypes.GType;
import org.raml.v2.api.model.v08.bodies.BodyLike;
import org.raml.v2.api.model.v08.bodies.Response;
import org.raml.v2.api.model.v08.methods.Method;
import org.raml.v2.api.model.v08.resources.Resource;

public class V08GType
implements GType {
    private static Map<String, Class<?>> stringScalarToType = ImmutableMap.builder().put((Object)"integer", Integer.TYPE).put((Object)"boolean", Boolean.TYPE).put((Object)"date-time", Date.class).put((Object)"date", Date.class).put((Object)"number", BigDecimal.class).put((Object)"string", String.class).put((Object)"file", File.class).build();
    private final String ramlName;
    private final String defaultJavaName;
    private final BodyLike typeDeclaration;
    private TypeName modelSpecifiedJavaType;

    public V08GType(Resource resource, Method method, BodyLike typeDeclaration) {
        this.ramlName = Names.ramlTypeName(resource, method, typeDeclaration);
        this.defaultJavaName = Names.javaTypeName(resource, method, typeDeclaration);
        this.typeDeclaration = typeDeclaration;
    }

    public V08GType(Resource resource, Method method, Response response, BodyLike typeDeclaration) {
        this.ramlName = Names.ramlTypeName(resource, method, response, typeDeclaration);
        this.defaultJavaName = Names.javaTypeName(resource, method, response, typeDeclaration);
        this.typeDeclaration = typeDeclaration;
    }

    public V08GType(String type) {
        this.ramlName = type;
        this.typeDeclaration = null;
        this.defaultJavaName = Names.typeName(type);
    }

    public V08GType(String type, BodyLike typeDeclaration) {
        this.ramlName = type;
        this.typeDeclaration = typeDeclaration;
        this.defaultJavaName = Names.typeName(type);
    }

    public BodyLike implementation() {
        return this.typeDeclaration;
    }

    @Override
    public boolean isScalar() {
        return !this.isJson() && !this.isXml();
    }

    @Override
    public String type() {
        return this.ramlName;
    }

    @Override
    public String name() {
        return this.ramlName;
    }

    @Override
    public boolean isJson() {
        return this.typeDeclaration != null && this.typeDeclaration.name().equals("application/json");
    }

    @Override
    public boolean isXml() {
        return this.typeDeclaration != null && this.typeDeclaration.name().equals("application/xml");
    }

    @Override
    public String schema() {
        return this.typeDeclaration.schemaContent();
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public GType arrayContents() {
        return null;
    }

    @Override
    public TypeName defaultJavaTypeName(String pack) {
        if (this.modelSpecifiedJavaType != null) {
            return this.modelSpecifiedJavaType;
        }
        Class<?> type = V08GType.scalarToJavaType(this.defaultJavaName);
        if (type == null) {
            return ClassName.get((String)pack, (String)this.defaultJavaName, (String[])new String[0]);
        }
        return ScalarTypes.classToTypeName(type);
    }

    public static Class<?> scalarToJavaType(String name) {
        return stringScalarToType.get(name.toLowerCase());
    }

    @Override
    public void setJavaType(TypeName generatedJavaType) {
        if (this.isXml()) {
            this.modelSpecifiedJavaType = generatedJavaType;
        }
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public void construct(final CurrentBuild currentBuild, GObjectType objectType) {
        objectType.dispatch(new GObjectType.GObjectTypeDispatcher(){

            @Override
            public void onPlainObject() {
                throw new GenerationException("no plain objects in v08");
            }

            @Override
            public void onXmlObject() {
                SchemaTypeFactory.createXmlType(currentBuild, V08GType.this);
            }

            @Override
            public void onJsonObject() {
                SchemaTypeFactory.createJsonType(currentBuild, V08GType.this);
            }

            @Override
            public void onEnumeration() {
                throw new GenerationException("no enums objects in v08");
            }

            @Override
            public void onUnion() {
                throw new GenerationException("no union objects in v08");
            }
        });
    }
}

