/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.extension.resources.api;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;

public abstract class AbstractCompositeExtension<T, B> {
    private Collection<T> elements;

    public AbstractCompositeExtension(Collection<T> elements) {
        this.elements = elements;
    }

    @VisibleForTesting
    public Collection<T> getElements() {
        return this.elements;
    }

    public B runList(B input, ElementJob<T, B> job) {
        B current = input;
        for (T element : this.elements) {
            current = job.doElement(element, current);
            if (current != null) continue;
            return null;
        }
        return current;
    }

    protected static interface ElementJob<T, B> {
        public B doElement(T var1, B var2);
    }
}

