/*
 * Decompiled with CFR 0.152.
 */
package org.r10r.sqlify.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.r10r.sqlify.core.Batch;
import org.r10r.sqlify.core.SqlifyCore;
import org.r10r.sqlify.core.SqlifyException;

public final class SqlifyBatched {
    private final String sqlForJdbc;
    private final List<Batch> parameterMapBatches;
    private final List<String> parametersInSqlSorted;

    public SqlifyBatched(String userProvidedSqlWithPlaceholder, List<Batch> parameterMapBatches) {
        if (parameterMapBatches.isEmpty()) {
            throw new IllegalArgumentException("You have to provide at least one batch when using batched sql mode...");
        }
        this.parameterMapBatches = parameterMapBatches;
        this.parametersInSqlSorted = SqlifyCore.extractParameterNames(userProvidedSqlWithPlaceholder);
        this.sqlForJdbc = SqlifyCore.convertNamedParametersIntoJdbcCompliantPreparedStatement(userProvidedSqlWithPlaceholder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeUpdateBatch(Connection connection) {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.sqlForJdbc);){
            int[] numberOfChangedLines;
            for (Batch batch : this.parameterMapBatches) {
                SqlifyCore.applyParameterMapToPreparedStatement(preparedStatement, batch.getParameterMap(), this.parametersInSqlSorted);
                preparedStatement.addBatch();
            }
            int[] nArray = numberOfChangedLines = preparedStatement.executeBatch();
            return nArray;
        }
        catch (SQLException sqlException) {
            throw new SqlifyException("Ops. Something strange happened " + sqlException, sqlException);
        }
    }
}

