/*
 * Decompiled with CFR 0.152.
 */
package quickfix.examples.ordermatch;

import java.util.ArrayList;
import quickfix.DoNotSend;
import quickfix.FieldNotFound;
import quickfix.IncorrectDataFormat;
import quickfix.IncorrectTagValue;
import quickfix.Message;
import quickfix.MessageCracker;
import quickfix.RejectLogon;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.SessionNotFound;
import quickfix.UnsupportedMessageType;
import quickfix.examples.ordermatch.IdGenerator;
import quickfix.examples.ordermatch.Order;
import quickfix.examples.ordermatch.OrderMatcher;
import quickfix.field.AvgPx;
import quickfix.field.ClOrdID;
import quickfix.field.CumQty;
import quickfix.field.CxlRejResponseTo;
import quickfix.field.ExecID;
import quickfix.field.ExecTransType;
import quickfix.field.ExecType;
import quickfix.field.LeavesQty;
import quickfix.field.OrdStatus;
import quickfix.field.OrderID;
import quickfix.field.OrigClOrdID;
import quickfix.field.Side;
import quickfix.field.Symbol;
import quickfix.fix42.ExecutionReport;
import quickfix.fix42.MarketDataRequest;
import quickfix.fix42.MarketDataSnapshotFullRefresh;
import quickfix.fix42.NewOrderSingle;
import quickfix.fix42.OrderCancelReject;
import quickfix.fix42.OrderCancelRequest;

public class Application
extends MessageCracker
implements quickfix.Application {
    private final OrderMatcher orderMatcher = new OrderMatcher();
    private final IdGenerator generator = new IdGenerator();

    @Override
    public void fromAdmin(Message message, SessionID sessionId) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, RejectLogon {
    }

    @Override
    public void fromApp(Message message, SessionID sessionId) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType {
        this.crack(message, sessionId);
    }

    public void onMessage(NewOrderSingle message, SessionID sessionID) throws FieldNotFound, UnsupportedMessageType, IncorrectTagValue {
        String senderCompId = message.getHeader().getString(49);
        String targetCompId = message.getHeader().getString(56);
        String clOrdId = message.getString(11);
        String symbol = message.getString(55);
        char side = message.getChar(54);
        char ordType = message.getChar(40);
        double price = 0.0;
        if (ordType == '2') {
            price = message.getDouble(44);
        }
        double qty = message.getDouble(38);
        int timeInForce = 48;
        if (message.isSetField(59)) {
            timeInForce = message.getChar(59);
        }
        try {
            if (timeInForce != 48) {
                throw new RuntimeException("Unsupported TIF, use Day");
            }
            Order order = new Order(clOrdId, symbol, senderCompId, targetCompId, side, ordType, price, (int)qty);
            this.processOrder(order);
        }
        catch (Exception e) {
            this.rejectOrder(targetCompId, senderCompId, clOrdId, symbol, side, e.getMessage());
        }
    }

    private void rejectOrder(String senderCompId, String targetCompId, String clOrdId, String symbol, char side, String message) {
        ExecutionReport fixOrder = new ExecutionReport(new OrderID(clOrdId), new ExecID(this.generator.genExecutionID()), new ExecTransType('0'), new ExecType('8'), new OrdStatus('8'), new Symbol(symbol), new Side(side), new LeavesQty(0.0), new CumQty(0.0), new AvgPx(0.0));
        fixOrder.setString(11, clOrdId);
        fixOrder.setString(58, message);
        fixOrder.setInt(103, 0);
        try {
            Session.sendToTarget(fixOrder, senderCompId, targetCompId);
        }
        catch (SessionNotFound e) {
            e.printStackTrace();
        }
    }

    private void processOrder(Order order) {
        if (this.orderMatcher.insert(order)) {
            this.acceptOrder(order);
            ArrayList<Order> orders = new ArrayList<Order>();
            this.orderMatcher.match(order.getSymbol(), orders);
            while (orders.size() > 0) {
                this.fillOrder(orders.remove(0));
            }
            this.orderMatcher.display(order.getSymbol());
        } else {
            this.rejectOrder(order);
        }
    }

    private void rejectOrder(Order order) {
        this.updateOrder(order, '8');
    }

    private void acceptOrder(Order order) {
        this.updateOrder(order, '0');
    }

    private void cancelOrder(Order order) {
        this.updateOrder(order, '4');
    }

    private void updateOrder(Order order, char status) {
        String targetCompId = order.getOwner();
        String senderCompId = order.getTarget();
        ExecutionReport fixOrder = new ExecutionReport(new OrderID(order.getClientOrderId()), new ExecID(this.generator.genExecutionID()), new ExecTransType('0'), new ExecType(status), new OrdStatus(status), new Symbol(order.getSymbol()), new Side(order.getSide()), new LeavesQty(order.getOpenQuantity()), new CumQty(order.getExecutedQuantity()), new AvgPx(order.getAvgExecutedPrice()));
        fixOrder.setString(11, order.getClientOrderId());
        fixOrder.setDouble(38, order.getQuantity());
        if (status == '2' || status == '1') {
            fixOrder.setDouble(32, order.getLastExecutedQuantity());
            fixOrder.setDouble(31, order.getPrice());
        }
        try {
            Session.sendToTarget(fixOrder, senderCompId, targetCompId);
        }
        catch (SessionNotFound sessionNotFound) {
            // empty catch block
        }
    }

    private void fillOrder(Order order) {
        this.updateOrder(order, order.isFilled() ? (char)'2' : '1');
    }

    public void onMessage(OrderCancelRequest message, SessionID sessionID) throws FieldNotFound, UnsupportedMessageType, IncorrectTagValue {
        String id;
        char side;
        String symbol = message.getString(55);
        Order order = this.orderMatcher.find(symbol, side = message.getChar(54), id = message.getString(41));
        if (order != null) {
            order.cancel();
            this.cancelOrder(order);
            this.orderMatcher.erase(order);
        } else {
            OrderCancelReject fixOrderReject = new OrderCancelReject(new OrderID("NONE"), new ClOrdID(message.getString(11)), new OrigClOrdID(message.getString(41)), new OrdStatus('8'), new CxlRejResponseTo('1'));
            String senderCompId = message.getHeader().getString(49);
            String targetCompId = message.getHeader().getString(56);
            fixOrderReject.getHeader().setString(49, targetCompId);
            fixOrderReject.getHeader().setString(56, senderCompId);
            try {
                Session.sendToTarget(fixOrderReject, targetCompId, senderCompId);
            }
            catch (SessionNotFound sessionNotFound) {
                // empty catch block
            }
        }
    }

    public void onMessage(MarketDataRequest message, SessionID sessionID) throws FieldNotFound, UnsupportedMessageType, IncorrectTagValue {
        MarketDataRequest.NoRelatedSym noRelatedSyms = new MarketDataRequest.NoRelatedSym();
        char subscriptionRequestType = message.getChar(263);
        if (subscriptionRequestType != '0') {
            throw new IncorrectTagValue(263);
        }
        int relatedSymbolCount = message.getInt(146);
        MarketDataSnapshotFullRefresh fixMD = new MarketDataSnapshotFullRefresh();
        fixMD.setString(262, message.getString(262));
        for (int i = 1; i <= relatedSymbolCount; ++i) {
            message.getGroup(i, noRelatedSyms);
            String symbol = noRelatedSyms.getString(55);
            fixMD.setString(55, symbol);
        }
        MarketDataSnapshotFullRefresh.NoMDEntries noMDEntries = new MarketDataSnapshotFullRefresh.NoMDEntries();
        noMDEntries.setChar(269, '0');
        noMDEntries.setDouble(270, 123.45);
        fixMD.addGroup(noMDEntries);
        String senderCompId = message.getHeader().getString(49);
        String targetCompId = message.getHeader().getString(56);
        fixMD.getHeader().setString(49, targetCompId);
        fixMD.getHeader().setString(56, senderCompId);
        try {
            Session.sendToTarget(fixMD, targetCompId, senderCompId);
        }
        catch (SessionNotFound sessionNotFound) {
            // empty catch block
        }
    }

    @Override
    public void onCreate(SessionID sessionId) {
    }

    @Override
    public void onLogon(SessionID sessionId) {
        System.out.println("Logon - " + sessionId);
    }

    @Override
    public void onLogout(SessionID sessionId) {
        System.out.println("Logout - " + sessionId);
    }

    @Override
    public void toAdmin(Message message, SessionID sessionId) {
    }

    @Override
    public void toApp(Message message, SessionID sessionId) throws DoNotSend {
    }

    public OrderMatcher orderMatcher() {
        return this.orderMatcher;
    }
}

