/*
 * Decompiled with CFR 0.152.
 */
package quickfix.examples.executor;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import javax.management.ObjectName;
import org.quickfixj.jmx.JmxExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.ConfigError;
import quickfix.DefaultMessageFactory;
import quickfix.FieldConvertError;
import quickfix.FileStoreFactory;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.RuntimeError;
import quickfix.ScreenLogFactory;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.SocketAcceptor;
import quickfix.examples.executor.Application;
import quickfix.mina.acceptor.DynamicAcceptorSessionProvider;

public class Executor {
    private static final Logger log = LoggerFactory.getLogger(Executor.class);
    private final SocketAcceptor acceptor;
    private final Map<InetSocketAddress, List<DynamicAcceptorSessionProvider.TemplateMapping>> dynamicSessionMappings = new HashMap<InetSocketAddress, List<DynamicAcceptorSessionProvider.TemplateMapping>>();
    private final JmxExporter jmxExporter;
    private final ObjectName connectorObjectName;

    public Executor(SessionSettings settings) throws ConfigError, FieldConvertError, JMException {
        Application application = new Application(settings);
        FileStoreFactory messageStoreFactory = new FileStoreFactory(settings);
        ScreenLogFactory logFactory = new ScreenLogFactory(true, true, true);
        DefaultMessageFactory messageFactory = new DefaultMessageFactory();
        this.acceptor = new SocketAcceptor((quickfix.Application)application, (MessageStoreFactory)messageStoreFactory, settings, logFactory, messageFactory);
        this.configureDynamicSessions(settings, application, messageStoreFactory, logFactory, messageFactory);
        this.jmxExporter = new JmxExporter();
        this.connectorObjectName = this.jmxExporter.register(this.acceptor);
        log.info("Acceptor registered with JMX, name={}", (Object)this.connectorObjectName);
    }

    private void configureDynamicSessions(SessionSettings settings, Application application, MessageStoreFactory messageStoreFactory, LogFactory logFactory, MessageFactory messageFactory) throws ConfigError, FieldConvertError {
        Iterator<SessionID> sectionIterator = settings.sectionIterator();
        while (sectionIterator.hasNext()) {
            SessionID sessionID = sectionIterator.next();
            if (!this.isSessionTemplate(settings, sessionID)) continue;
            InetSocketAddress address = this.getAcceptorSocketAddress(settings, sessionID);
            this.getMappings(address).add(new DynamicAcceptorSessionProvider.TemplateMapping(sessionID, sessionID));
        }
        for (Map.Entry<InetSocketAddress, List<DynamicAcceptorSessionProvider.TemplateMapping>> entry : this.dynamicSessionMappings.entrySet()) {
            this.acceptor.setSessionProvider(entry.getKey(), new DynamicAcceptorSessionProvider(settings, entry.getValue(), (quickfix.Application)application, messageStoreFactory, logFactory, messageFactory));
        }
    }

    private List<DynamicAcceptorSessionProvider.TemplateMapping> getMappings(InetSocketAddress address) {
        return this.dynamicSessionMappings.computeIfAbsent(address, k -> new ArrayList());
    }

    private InetSocketAddress getAcceptorSocketAddress(SessionSettings settings, SessionID sessionID) throws ConfigError, FieldConvertError {
        String acceptorHost = "0.0.0.0";
        if (settings.isSetting(sessionID, "SocketAcceptAddress")) {
            acceptorHost = settings.getString(sessionID, "SocketAcceptAddress");
        }
        int acceptorPort = (int)settings.getLong(sessionID, "SocketAcceptPort");
        return new InetSocketAddress(acceptorHost, acceptorPort);
    }

    private boolean isSessionTemplate(SessionSettings settings, SessionID sessionID) throws ConfigError, FieldConvertError {
        return settings.isSetting(sessionID, "AcceptorTemplate") && settings.getBool(sessionID, "AcceptorTemplate");
    }

    private void start() throws RuntimeError, ConfigError {
        this.acceptor.start();
    }

    private void stop() {
        try {
            this.jmxExporter.getMBeanServer().unregisterMBean(this.connectorObjectName);
        }
        catch (Exception e) {
            log.error("Failed to unregister acceptor from JMX", e);
        }
        this.acceptor.stop();
    }

    public static void main(String[] args) throws Exception {
        try {
            InputStream inputStream = Executor.getSettingsInputStream(args);
            SessionSettings settings = new SessionSettings(inputStream);
            inputStream.close();
            Executor executor = new Executor(settings);
            executor.start();
            System.out.println("press <enter> to quit");
            System.in.read();
            executor.stop();
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    private static InputStream getSettingsInputStream(String[] args) throws FileNotFoundException {
        InputStream inputStream = null;
        if (args.length == 0) {
            inputStream = Executor.class.getResourceAsStream("executor.cfg");
        } else if (args.length == 1) {
            inputStream = new FileInputStream(args[0]);
        }
        if (inputStream == null) {
            System.out.println("usage: " + Executor.class.getName() + " [configFile].");
            System.exit(1);
        }
        return inputStream;
    }
}

