/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.TreeMap;
import org.quickfixj.CharsetSupport;
import quickfix.FileUtil;
import quickfix.MemoryStore;
import quickfix.MessageStore;
import quickfix.SessionID;
import quickfix.SystemTime;
import quickfix.field.converter.UtcTimestampConverter;

public class FileStore
implements MessageStore,
Closeable {
    private static final String READ_OPTION = "r";
    private static final String WRITE_OPTION = "w";
    private static final String SYNC_OPTION = "d";
    private static final String NOSYNC_OPTION = "";
    private final TreeMap<Long, long[]> messageIndex;
    private final MemoryStore cache = new MemoryStore();
    private final String msgFileName;
    private final String headerFileName;
    private final String senderSeqNumFileName;
    private final String targetSeqNumFileName;
    private final String sessionFileName;
    private final boolean syncWrites;
    private final int maxCachedMsgs;
    private RandomAccessFile messageFileReader;
    private RandomAccessFile messageFileWriter;
    private DataOutputStream headerDataOutputStream;
    private FileOutputStream headerFileOutputStream;
    private RandomAccessFile senderSequenceNumberFile;
    private RandomAccessFile targetSequenceNumberFile;

    FileStore(String path, SessionID sessionID, boolean syncWrites, int maxCachedMsgs) throws IOException {
        this.syncWrites = syncWrites;
        this.maxCachedMsgs = maxCachedMsgs;
        this.messageIndex = maxCachedMsgs > 0 ? new TreeMap() : null;
        String fullPath = new File(path == null ? "." : path).getAbsolutePath();
        String sessionName = FileUtil.sessionIdFileName(sessionID);
        String prefix = FileUtil.fileAppendPath(fullPath, sessionName + ".");
        this.msgFileName = prefix + "body";
        this.headerFileName = prefix + "header";
        this.senderSeqNumFileName = prefix + "senderseqnums";
        this.targetSeqNumFileName = prefix + "targetseqnums";
        this.sessionFileName = prefix + "session";
        File directory = new File(this.msgFileName).getParentFile();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        this.initialize(false);
    }

    void initialize(boolean deleteFiles) throws IOException {
        if (deleteFiles) {
            this.closeAndDeleteFiles();
        } else {
            this.close();
        }
        String mode = "rw" + (this.syncWrites ? SYNC_OPTION : NOSYNC_OPTION);
        this.messageFileWriter = new RandomAccessFile(this.msgFileName, mode);
        this.messageFileReader = new RandomAccessFile(this.msgFileName, READ_OPTION);
        this.senderSequenceNumberFile = new RandomAccessFile(this.senderSeqNumFileName, mode);
        this.targetSequenceNumberFile = new RandomAccessFile(this.targetSeqNumFileName, mode);
        this.initializeCache();
    }

    private void initializeCache() throws IOException {
        this.cache.reset();
        this.initializeMessageIndex();
        this.initializeSequenceNumbers();
        this.initializeSessionCreateTime();
        this.messageFileWriter.seek(this.messageFileWriter.length());
    }

    private void initializeSessionCreateTime() throws IOException {
        block15: {
            File sessionTimeFile = new File(this.sessionFileName);
            if (sessionTimeFile.exists() && sessionTimeFile.length() > 0L) {
                try (DataInputStream sessionTimeInput = new DataInputStream(new BufferedInputStream(new FileInputStream(sessionTimeFile)));){
                    Calendar c = SystemTime.getUtcCalendar(UtcTimestampConverter.convert(sessionTimeInput.readUTF()));
                    this.cache.setCreationTime(c);
                    break block15;
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
            }
            this.storeSessionTimeStamp();
        }
    }

    private void storeSessionTimeStamp() throws IOException {
        try (DataOutputStream sessionTimeOutput = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.sessionFileName, false)));){
            Date date = SystemTime.getDate();
            this.cache.setCreationTime(SystemTime.getUtcCalendar(date));
            sessionTimeOutput.writeUTF(UtcTimestampConverter.convert(date, true));
        }
    }

    @Override
    public Date getCreationTime() throws IOException {
        return this.cache.getCreationTime();
    }

    private void initializeSequenceNumbers() throws IOException {
        String s;
        this.senderSequenceNumberFile.seek(0L);
        if (this.senderSequenceNumberFile.length() > 0L) {
            s = this.senderSequenceNumberFile.readUTF();
            this.cache.setNextSenderMsgSeqNum(Integer.parseInt(s));
        }
        this.targetSequenceNumberFile.seek(0L);
        if (this.targetSequenceNumberFile.length() > 0L) {
            s = this.targetSequenceNumberFile.readUTF();
            this.cache.setNextTargetMsgSeqNum(Integer.parseInt(s));
        }
    }

    private void initializeMessageIndex() throws IOException {
        if (this.messageIndex != null) {
            this.messageIndex.clear();
            File headerFile = new File(this.headerFileName);
            if (headerFile.exists()) {
                try (DataInputStream headerDataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(headerFile)));){
                    while (headerDataInputStream.available() > 0) {
                        int sequenceNumber = headerDataInputStream.readInt();
                        long offset = headerDataInputStream.readLong();
                        int size = headerDataInputStream.readInt();
                        this.updateMessageIndex(sequenceNumber, offset, size);
                    }
                }
            }
        }
        this.headerFileOutputStream = new FileOutputStream(this.headerFileName, true);
        this.headerDataOutputStream = new DataOutputStream(new BufferedOutputStream(this.headerFileOutputStream));
    }

    private void updateMessageIndex(long sequenceNum, long offset, int size) {
        if (this.messageIndex.size() >= this.maxCachedMsgs && this.messageIndex.get(sequenceNum) == null) {
            this.messageIndex.pollFirstEntry();
        }
        this.messageIndex.put(sequenceNum, new long[]{offset, size});
    }

    @Override
    public void close() throws IOException {
        FileStore.close(this.headerDataOutputStream);
        FileStore.close(this.messageFileWriter);
        FileStore.close(this.messageFileReader);
        FileStore.close(this.senderSequenceNumberFile);
        FileStore.close(this.targetSequenceNumberFile);
    }

    private static void close(Closeable closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    public void closeAndDeleteFiles() throws IOException {
        this.close();
        this.deleteFile(this.headerFileName);
        this.deleteFile(this.msgFileName);
        this.deleteFile(this.senderSeqNumFileName);
        this.deleteFile(this.targetSeqNumFileName);
        this.deleteFile(this.sessionFileName);
    }

    private void deleteFile(String fileName) throws IOException {
        File file = new File(fileName);
        if (file.exists() && !file.delete()) {
            System.err.println("File delete failed: " + fileName);
        }
    }

    @Override
    public int getNextSenderMsgSeqNum() throws IOException {
        return this.cache.getNextSenderMsgSeqNum();
    }

    @Override
    public int getNextTargetMsgSeqNum() throws IOException {
        return this.cache.getNextTargetMsgSeqNum();
    }

    @Override
    public void setNextSenderMsgSeqNum(int next) throws IOException {
        this.cache.setNextSenderMsgSeqNum(next);
        this.storeSenderSequenceNumber();
    }

    @Override
    public void setNextTargetMsgSeqNum(int next) throws IOException {
        this.cache.setNextTargetMsgSeqNum(next);
        this.storeTargetSequenceNumber();
    }

    @Override
    public void incrNextSenderMsgSeqNum() throws IOException {
        this.cache.incrNextSenderMsgSeqNum();
        this.storeSenderSequenceNumber();
    }

    @Override
    public void incrNextTargetMsgSeqNum() throws IOException {
        this.cache.incrNextTargetMsgSeqNum();
        this.storeTargetSequenceNumber();
    }

    @Override
    public void get(int startSequence, int endSequence, Collection<String> messages) throws IOException {
        HashSet<Integer> uncachedOffsetMsgIds = new HashSet<Integer>();
        TreeMap<Integer, String> messagesFound = new TreeMap<Integer, String>();
        for (int i = startSequence; i <= endSequence; ++i) {
            String message = this.getMessage(i);
            if (message != null) {
                messagesFound.put(i, message);
                continue;
            }
            uncachedOffsetMsgIds.add(i);
        }
        if (!uncachedOffsetMsgIds.isEmpty()) {
            File headerFile = new File(this.headerFileName);
            try (DataInputStream headerDataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(headerFile)));){
                while (!uncachedOffsetMsgIds.isEmpty() && headerDataInputStream.available() > 0) {
                    int sequenceNumber = headerDataInputStream.readInt();
                    long offset = headerDataInputStream.readLong();
                    int size = headerDataInputStream.readInt();
                    if (!uncachedOffsetMsgIds.remove(sequenceNumber)) continue;
                    String message = this.getMessage(offset, size, sequenceNumber);
                    messagesFound.put(sequenceNumber, message);
                }
            }
        }
        messages.addAll(messagesFound.values());
    }

    public boolean get(int sequence, String message) throws IOException {
        throw new UnsupportedOperationException("not supported");
    }

    private String getMessage(int i) throws IOException {
        long[] offsetAndSize;
        String message = null;
        if (this.messageIndex != null && (offsetAndSize = this.messageIndex.get(i)) != null) {
            message = this.getMessage(offsetAndSize[0], (int)offsetAndSize[1], i);
        }
        return message;
    }

    private String getMessage(long offset, int size, int i) throws IOException {
        try {
            byte[] data = new byte[size];
            this.messageFileReader.seek(offset);
            this.messageFileReader.readFully(data);
            return new String(data, CharsetSupport.getCharset());
        }
        catch (EOFException eofe) {
            throw new IOException("Truncated input while reading message: messageIndex=" + i + ", offset=" + offset + ", expected size=" + size, eofe);
        }
    }

    @Override
    public boolean set(int sequence, String message) throws IOException {
        long offset = this.messageFileWriter.getFilePointer();
        byte[] messageBytes = message.getBytes(CharsetSupport.getCharset());
        int size = messageBytes.length;
        if (this.messageIndex != null) {
            this.updateMessageIndex(sequence, offset, size);
        }
        this.headerDataOutputStream.writeInt(sequence);
        this.headerDataOutputStream.writeLong(offset);
        this.headerDataOutputStream.writeInt(size);
        this.headerDataOutputStream.flush();
        if (this.syncWrites) {
            this.headerFileOutputStream.getFD().sync();
        }
        this.messageFileWriter.write(messageBytes);
        return true;
    }

    private void storeSenderSequenceNumber() throws IOException {
        this.senderSequenceNumberFile.seek(0L);
        this.senderSequenceNumberFile.writeUTF(NOSYNC_OPTION + this.cache.getNextSenderMsgSeqNum());
    }

    private void storeTargetSequenceNumber() throws IOException {
        this.targetSequenceNumberFile.seek(0L);
        this.targetSequenceNumberFile.writeUTF(NOSYNC_OPTION + this.cache.getNextTargetMsgSeqNum());
    }

    @Override
    public void refresh() throws IOException {
        this.initialize(false);
    }

    @Override
    public void reset() throws IOException {
        this.initialize(true);
    }
}

