/*
 * Decompiled with CFR 0.152.
 */
package quickfix.examples.banzai;

import java.util.HashMap;
import java.util.Map;

public class OrderType {
    private static final Map<String, OrderType> known = new HashMap<String, OrderType>();
    public static final OrderType MARKET = new OrderType("Market");
    public static final OrderType LIMIT = new OrderType("Limit");
    public static final OrderType STOP = new OrderType("Stop");
    public static final OrderType STOP_LIMIT = new OrderType("Stop Limit");
    private final String name;
    private static final OrderType[] array = new OrderType[]{MARKET, LIMIT, STOP, STOP_LIMIT};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrderType(String name) {
        this.name = name;
        Class<OrderType> clazz = OrderType.class;
        synchronized (OrderType.class) {
            known.put(name, this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static Object[] toArray() {
        return array;
    }

    public static OrderType parse(String type) throws IllegalArgumentException {
        OrderType result = known.get(type);
        if (result == null) {
            throw new IllegalArgumentException("OrderType: " + type + " is unknown.");
        }
        return result;
    }
}

