/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.ssl;

import java.util.Arrays;
import java.util.Objects;

public class SSLConfig {
    private String keyStoreName;
    private char[] keyStorePassword;
    private String keyManagerFactoryAlgorithm;
    private String keyStoreType;
    private String trustStoreName;
    private char[] trustStorePassword;
    private String trustManagerFactoryAlgorithm;
    private String trustStoreType;
    private String[] enabledProtocols;
    private String[] enabledCipherSuites;
    private boolean needClientAuth;
    private String endpointIdentificationAlgorithm;

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public String getKeyManagerFactoryAlgorithm() {
        return this.keyManagerFactoryAlgorithm;
    }

    public String getKeyStoreName() {
        return this.keyStoreName;
    }

    public char[] getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getTrustManagerFactoryAlgorithm() {
        return this.trustManagerFactoryAlgorithm;
    }

    public String getTrustStoreName() {
        return this.trustStoreName;
    }

    public char[] getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public String getEndpointIdentificationAlgorithm() {
        return this.endpointIdentificationAlgorithm;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public void setKeyManagerFactoryAlgorithm(String keyManagerFactoryAlgorithm) {
        this.keyManagerFactoryAlgorithm = keyManagerFactoryAlgorithm;
    }

    public void setKeyStoreName(String keyStoreName) {
        this.keyStoreName = keyStoreName;
    }

    public void setKeyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public void setEndpointIdentificationAlgorithm(String endpointIdentificationAlgorithm) {
        this.endpointIdentificationAlgorithm = endpointIdentificationAlgorithm;
    }

    public void setTrustManagerFactoryAlgorithm(String trustManagerFactoryAlgorithm) {
        this.trustManagerFactoryAlgorithm = trustManagerFactoryAlgorithm;
    }

    public void setTrustStoreName(String trustStoreName) {
        this.trustStoreName = trustStoreName;
    }

    public void setTrustStorePassword(char[] trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SSLConfig sslConfig = (SSLConfig)o;
        return this.needClientAuth == sslConfig.needClientAuth && Objects.equals(this.keyStoreName, sslConfig.keyStoreName) && Arrays.equals(this.keyStorePassword, sslConfig.keyStorePassword) && Objects.equals(this.keyManagerFactoryAlgorithm, sslConfig.keyManagerFactoryAlgorithm) && Objects.equals(this.keyStoreType, sslConfig.keyStoreType) && Objects.equals(this.trustStoreName, sslConfig.trustStoreName) && Arrays.equals(this.trustStorePassword, sslConfig.trustStorePassword) && Objects.equals(this.trustManagerFactoryAlgorithm, sslConfig.trustManagerFactoryAlgorithm) && Objects.equals(this.trustStoreType, sslConfig.trustStoreType) && Arrays.equals(this.enabledProtocols, sslConfig.enabledProtocols) && Arrays.equals(this.enabledCipherSuites, sslConfig.enabledCipherSuites) && Objects.equals(this.endpointIdentificationAlgorithm, sslConfig.endpointIdentificationAlgorithm);
    }

    public int hashCode() {
        int result = Objects.hash(this.keyStoreName, this.keyManagerFactoryAlgorithm, this.keyStoreType, this.trustStoreName, this.trustManagerFactoryAlgorithm, this.trustStoreType, this.needClientAuth, this.endpointIdentificationAlgorithm);
        result = 31 * result + Arrays.hashCode(this.keyStorePassword);
        result = 31 * result + Arrays.hashCode(this.trustStorePassword);
        result = 31 * result + Arrays.hashCode(this.enabledProtocols);
        result = 31 * result + Arrays.hashCode(this.enabledCipherSuites);
        return result;
    }
}

