/*
 * Decompiled with CFR 0.152.
 */
package org.quickfixj.jmx.openmbean;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.quickfixj.jmx.openmbean.CompositeDataFactory;
import org.quickfixj.jmx.openmbean.CompositeTypeFactory;

public class TabularDataAdapter {
    public TabularData fromArray(String tableTypeName, String rowTypeName, Object[] objects) throws OpenDataException {
        CompositeTypeFactory rowTypeFactory = new CompositeTypeFactory(rowTypeName, rowTypeName);
        rowTypeFactory.defineItem(rowTypeName, SimpleType.STRING);
        CompositeType rowType = rowTypeFactory.createCompositeType();
        TabularType tableType = new TabularType(tableTypeName, tableTypeName, rowType, new String[]{rowTypeName});
        CompositeDataFactory rowDataFactory = new CompositeDataFactory(rowType);
        TabularDataSupport table = new TabularDataSupport(tableType);
        for (Object object : objects) {
            rowDataFactory.clear();
            rowDataFactory.setValue(rowTypeName, object.toString());
            table.put(rowDataFactory.createCompositeData());
        }
        return table;
    }

    public TabularData fromMap(String keyLabel, String valueLabel, Map data) throws OpenDataException {
        CompositeTypeFactory rowTypeFactory = new CompositeTypeFactory("row", "row");
        rowTypeFactory.defineItem(keyLabel, SimpleType.STRING);
        rowTypeFactory.defineItem(valueLabel, SimpleType.STRING);
        CompositeType rowType = rowTypeFactory.createCompositeType();
        TabularType tableType = new TabularType("TabularData", "TabularData", rowType, new String[]{keyLabel, valueLabel});
        CompositeDataFactory rowDataFactory = new CompositeDataFactory(rowType);
        TabularDataSupport table = new TabularDataSupport(tableType);
        Iterator iterator = data.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            rowDataFactory.clear();
            rowDataFactory.setValue(keyLabel, entry.getKey().toString());
            rowDataFactory.setValue(valueLabel, entry.getValue().toString());
            table.put(rowDataFactory.createCompositeData());
        }
        return table;
    }

    public TabularData fromBean(String keyLabel, String valueLabel, Object bean) throws OpenDataException {
        CompositeTypeFactory rowTypeFactory = new CompositeTypeFactory("row", "row");
        rowTypeFactory.defineItem(keyLabel, SimpleType.STRING);
        rowTypeFactory.defineItem(valueLabel, SimpleType.STRING);
        CompositeType rowType = rowTypeFactory.createCompositeType();
        TabularType tableType = new TabularType("TabularData", "TabularData", rowType, new String[]{keyLabel, valueLabel});
        CompositeDataFactory rowDataFactory = new CompositeDataFactory(rowType);
        TabularDataSupport table = new TabularDataSupport(tableType);
        try {
            PropertyDescriptor[] pds;
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            for (PropertyDescriptor descriptor : pds = beanInfo.getPropertyDescriptors()) {
                if (descriptor.getReadMethod() == null || "class".equals(descriptor.getName())) continue;
                rowDataFactory.clear();
                rowDataFactory.setValue(keyLabel, descriptor.getName());
                Object value = descriptor.getReadMethod().invoke(bean, (Object[])null);
                if (value == null) {
                    value = "(null)";
                }
                rowDataFactory.setValue(valueLabel, value);
                table.put(rowDataFactory.createCompositeData());
            }
        }
        catch (OpenDataException e) {
            throw e;
        }
        catch (Exception e) {
            OpenDataException ode = new OpenDataException(e.getMessage());
            ode.setStackTrace(e.getStackTrace());
            throw ode;
        }
        return table;
    }

    public TabularData fromBeanList(String tableTypeName, String rowTypeName, String keyProperty, List<?> beans) throws OpenDataException {
        TabularDataSupport table;
        try {
            CompositeTypeFactory rowTypeFactory = new CompositeTypeFactory(rowTypeName, rowTypeName);
            ArrayList<String> indexNames = new ArrayList<String>();
            indexNames.add(keyProperty);
            rowTypeFactory.defineItem(this.formatHeader(keyProperty), SimpleType.STRING);
            for (Object bean : beans) {
                PropertyDescriptor[] pds;
                BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
                for (PropertyDescriptor descriptor : pds = beanInfo.getPropertyDescriptors()) {
                    String propertyName = descriptor.getName();
                    if (descriptor.getReadMethod() == null || "class".equals(propertyName) || indexNames.contains(propertyName)) continue;
                    indexNames.add(propertyName);
                    rowTypeFactory.defineItem(this.formatHeader(propertyName), SimpleType.STRING);
                }
            }
            CompositeType rowType = rowTypeFactory.createCompositeType();
            TabularType tableType = new TabularType(tableTypeName, tableTypeName, rowType, this.createTableHeaders(indexNames));
            CompositeDataFactory rowDataFactory = new CompositeDataFactory(rowType);
            table = new TabularDataSupport(tableType);
            for (Object bean : beans) {
                PropertyDescriptor[] pds;
                rowDataFactory.clear();
                BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
                for (PropertyDescriptor descriptor : pds = beanInfo.getPropertyDescriptors()) {
                    String propertyName = descriptor.getName();
                    String headerName = this.formatHeader(propertyName);
                    if (descriptor.getReadMethod() == null || "class".equals(propertyName)) continue;
                    Object value = descriptor.getReadMethod().invoke(bean, (Object[])null);
                    if (value == null) {
                        value = "(null)";
                    }
                    rowDataFactory.setValue(headerName, value.toString());
                }
                table.put(rowDataFactory.createCompositeData());
            }
        }
        catch (OpenDataException e) {
            throw e;
        }
        catch (Exception e) {
            OpenDataException ode = new OpenDataException(e.getMessage());
            ode.setStackTrace(e.getStackTrace());
            throw ode;
        }
        return table;
    }

    private String[] createTableHeaders(List<String> indexNames) {
        String[] headers = new String[indexNames.size()];
        for (int i = 0; i < indexNames.size(); ++i) {
            String name = indexNames.get(i);
            headers[i] = this.formatHeader(name);
        }
        return headers;
    }

    private String formatHeader(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }
}

