/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import quickfix.AbstractSessionConnectorBuilder;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.RuntimeError;
import quickfix.ScreenLogFactory;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionSettings;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.ThreadPerSessionEventHandlingStrategy;
import quickfix.mina.initiator.AbstractSocketInitiator;

public class ThreadedSocketInitiator
extends AbstractSocketInitiator {
    private final ThreadPerSessionEventHandlingStrategy eventHandlingStrategy;

    private ThreadedSocketInitiator(Builder builder) throws ConfigError {
        super(builder.application, builder.messageStoreFactory, builder.settings, builder.logFactory, builder.messageFactory, builder.numReconnectThreads);
        this.eventHandlingStrategy = builder.queueCapacity >= 0 ? new ThreadPerSessionEventHandlingStrategy(this, builder.queueCapacity) : new ThreadPerSessionEventHandlingStrategy(this, builder.queueLowerWatermark, builder.queueUpperWatermark);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public ThreadedSocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory, int queueCapacity) throws ConfigError {
        super(application, messageStoreFactory, settings, logFactory, messageFactory);
        this.eventHandlingStrategy = new ThreadPerSessionEventHandlingStrategy(this, queueCapacity);
    }

    public ThreadedSocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory) throws ConfigError {
        super(application, messageStoreFactory, settings, logFactory, messageFactory);
        this.eventHandlingStrategy = new ThreadPerSessionEventHandlingStrategy(this, 10000);
    }

    public ThreadedSocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, MessageFactory messageFactory, int queueCapacity) throws ConfigError {
        super(application, messageStoreFactory, settings, new ScreenLogFactory(settings), messageFactory);
        this.eventHandlingStrategy = new ThreadPerSessionEventHandlingStrategy(this, queueCapacity);
    }

    public ThreadedSocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, MessageFactory messageFactory) throws ConfigError {
        super(application, messageStoreFactory, settings, new ScreenLogFactory(settings), messageFactory);
        this.eventHandlingStrategy = new ThreadPerSessionEventHandlingStrategy(this, 10000);
    }

    public ThreadedSocketInitiator(SessionFactory sessionFactory, SessionSettings settings, int queueCapacity) throws ConfigError {
        super(settings, sessionFactory);
        this.eventHandlingStrategy = new ThreadPerSessionEventHandlingStrategy(this, queueCapacity);
    }

    public ThreadedSocketInitiator(SessionFactory sessionFactory, SessionSettings settings) throws ConfigError {
        super(settings, sessionFactory);
        this.eventHandlingStrategy = new ThreadPerSessionEventHandlingStrategy(this, 10000);
    }

    @Override
    public void start() throws ConfigError, RuntimeError {
        this.eventHandlingStrategy.setExecutor(this.longLivedExecutor);
        this.createSessionInitiators();
        this.startInitiators();
    }

    @Override
    public void stop(boolean forceDisconnect) {
        this.logoutAllSessions(forceDisconnect);
        this.stopInitiators();
        this.eventHandlingStrategy.stopDispatcherThreads();
        Session.unregisterSessions(this.getSessions(), true);
        this.clearConnectorSessions();
    }

    @Override
    protected EventHandlingStrategy getEventHandlingStrategy() {
        return this.eventHandlingStrategy;
    }

    public static final class Builder
    extends AbstractSessionConnectorBuilder<Builder, ThreadedSocketInitiator> {
        int numReconnectThreads = 3;

        private Builder() {
            super(Builder.class);
        }

        public Builder withReconnectThreads(int numReconnectThreads) throws ConfigError {
            this.numReconnectThreads = numReconnectThreads;
            return this;
        }

        @Override
        protected ThreadedSocketInitiator doBuild() throws ConfigError {
            return new ThreadedSocketInitiator(this);
        }
    }
}

