/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import quickfix.Application;
import quickfix.ConfigError;
import quickfix.DefaultMessageFactory;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.ScreenLogFactory;
import quickfix.SessionSettings;

public abstract class AbstractSessionConnectorBuilder<Derived, Product> {
    private final Class<Derived> derived;
    Application application;
    MessageStoreFactory messageStoreFactory;
    SessionSettings settings;
    LogFactory logFactory;
    MessageFactory messageFactory;
    int queueCapacity = -1;
    int queueLowerWatermark = -1;
    int queueUpperWatermark = -1;

    AbstractSessionConnectorBuilder(Class<Derived> derived) {
        this.derived = derived;
    }

    public Derived withApplication(Application val) throws ConfigError {
        this.application = val;
        return this.derived.cast(this);
    }

    public Derived withMessageStoreFactory(MessageStoreFactory val) throws ConfigError {
        this.messageStoreFactory = val;
        return this.derived.cast(this);
    }

    public Derived withSettings(SessionSettings val) {
        this.settings = val;
        return this.derived.cast(this);
    }

    public Derived withLogFactory(LogFactory val) throws ConfigError {
        this.logFactory = val;
        return this.derived.cast(this);
    }

    public Derived withMessageFactory(MessageFactory val) throws ConfigError {
        this.messageFactory = val;
        return this.derived.cast(this);
    }

    public Derived withQueueCapacity(int val) throws ConfigError {
        if (this.queueLowerWatermark >= 0) {
            throw new ConfigError("queue capacity and watermarks may not be configured together");
        }
        if (val < 0) {
            throw new ConfigError("negative queue capacity");
        }
        this.queueCapacity = val;
        return this.derived.cast(this);
    }

    public Derived withQueueWatermarks(int lower, int upper) throws ConfigError {
        if (this.queueCapacity >= 0) {
            throw new ConfigError("queue capacity and watermarks may not be configured together");
        }
        if (lower < 0 || upper <= lower) {
            throw new ConfigError("invalid queue watermarks, required: 0 <= lower watermark < upper watermark");
        }
        this.queueLowerWatermark = lower;
        this.queueUpperWatermark = upper;
        return this.derived.cast(this);
    }

    public final Product build() throws ConfigError {
        if (this.logFactory == null) {
            this.logFactory = new ScreenLogFactory(this.settings);
        }
        if (this.messageFactory == null) {
            this.messageFactory = new DefaultMessageFactory();
        }
        return this.doBuild();
    }

    protected abstract Product doBuild() throws ConfigError;
}

