/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import quickfix.Log;
import quickfix.Message;
import quickfix.MessageStore;
import quickfix.RuntimeError;
import quickfix.SystemTime;

public final class SessionState {
    private final Object lock;
    private final Log log;
    private final MessageStore messageStore;
    private final Lock senderMsgSeqNumLock = new ReentrantLock();
    private final Lock targetMsgSeqNumLock = new ReentrantLock();
    private final boolean initiator;
    private long logonTimeoutMs = 10000L;
    private long logoutTimeoutMs = 2000L;
    private boolean logonSent;
    private boolean logonReceived;
    private boolean logoutSent;
    private boolean logoutReceived = false;
    private int testRequestCounter;
    private long lastSentTime;
    private long lastReceivedTime;
    private final double testRequestDelayMultiplier;
    private final double heartBeatTimeoutMultiplier;
    private long heartBeatMillis = Long.MAX_VALUE;
    private int heartBeatInterval;
    private final ResendRange resendRange = new ResendRange();
    private boolean resetSent;
    private boolean resetReceived;
    private String logoutReason;
    private final AtomicInteger nextExpectedMsgSeqNum = new AtomicInteger(0);
    private final Map<Integer, Message> messageQueue = new LinkedHashMap<Integer, Message>();

    public SessionState(Object lock, Log log, int heartBeatInterval, boolean initiator, MessageStore messageStore, double testRequestDelayMultiplier, double heartBeatTimeoutMultiplier) {
        this.lock = lock;
        this.initiator = initiator;
        this.messageStore = messageStore;
        this.setHeartBeatInterval(heartBeatInterval);
        this.log = log == null ? new NullLog() : log;
        this.testRequestDelayMultiplier = testRequestDelayMultiplier;
        this.heartBeatTimeoutMultiplier = heartBeatTimeoutMultiplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeartBeatInterval() {
        Object object = this.lock;
        synchronized (object) {
            return this.heartBeatInterval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeartBeatInterval(int heartBeatInterval) {
        Object object = this.lock;
        synchronized (object) {
            this.heartBeatInterval = heartBeatInterval;
            this.heartBeatMillis = TimeUnit.SECONDS.toMillis(heartBeatInterval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getHeartBeatMillis() {
        Object object = this.lock;
        synchronized (object) {
            return this.heartBeatMillis;
        }
    }

    public boolean isHeartBeatNeeded() {
        long millisSinceLastSentTime = SystemTime.currentTimeMillis() - this.getLastSentTime();
        return millisSinceLastSentTime + 10L > this.getHeartBeatMillis() && this.getTestRequestCounter() == 0;
    }

    public boolean isInitiator() {
        return this.initiator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastReceivedTime() {
        Object object = this.lock;
        synchronized (object) {
            return this.lastReceivedTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastReceivedTime(long lastReceivedTime) {
        Object object = this.lock;
        synchronized (object) {
            this.lastReceivedTime = lastReceivedTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastSentTime() {
        Object object = this.lock;
        synchronized (object) {
            return this.lastSentTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastSentTime(long lastSentTime) {
        Object object = this.lock;
        synchronized (object) {
            this.lastSentTime = lastSentTime;
        }
    }

    public Log getLog() {
        return this.log;
    }

    public boolean isLogonAlreadySent() {
        return this.isInitiator() && this.isLogonSent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLogonReceived() {
        Object object = this.lock;
        synchronized (object) {
            return this.logonReceived;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogonReceived(boolean logonReceived) {
        Object object = this.lock;
        synchronized (object) {
            this.logonReceived = logonReceived;
        }
    }

    public boolean isLogonSendNeeded() {
        return this.isInitiator() && !this.isLogonSent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLogonSent() {
        Object object = this.lock;
        synchronized (object) {
            return this.logonSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogonSent(boolean logonSent) {
        Object object = this.lock;
        synchronized (object) {
            this.logonSent = logonSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLogonTimedOut() {
        Object object = this.lock;
        synchronized (object) {
            return this.isLogonSent() && SystemTime.currentTimeMillis() - this.getLastReceivedTime() >= this.getLogonTimeoutMs();
        }
    }

    public void setLogonTimeout(int logonTimeout) {
        this.setLogonTimeoutMs((long)logonTimeout * 1000L);
    }

    public int getLogonTimeout() {
        return (int)(this.getLogonTimeoutMs() / 1000L);
    }

    public void setLogoutTimeout(int logoutTimeout) {
        this.setLogoutTimeoutMs((long)logoutTimeout * 1000L);
    }

    public int getLogoutTimeout() {
        return (int)(this.getLogoutTimeoutMs() / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLogoutTimeoutMs(long logoutTimeoutMs) {
        Object object = this.lock;
        synchronized (object) {
            this.logoutTimeoutMs = logoutTimeoutMs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLogoutTimeoutMs() {
        Object object = this.lock;
        synchronized (object) {
            return this.logoutTimeoutMs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLogonTimeoutMs(long logonTimeoutMs) {
        Object object = this.lock;
        synchronized (object) {
            this.logonTimeoutMs = logonTimeoutMs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLogonTimeoutMs() {
        Object object = this.lock;
        synchronized (object) {
            return this.logonTimeoutMs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLogoutSent() {
        Object object = this.lock;
        synchronized (object) {
            return this.logoutSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogoutSent(boolean logoutSent) {
        Object object = this.lock;
        synchronized (object) {
            this.logoutSent = logoutSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLogoutReceived() {
        Object object = this.lock;
        synchronized (object) {
            return this.logoutReceived;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogoutReceived(boolean logoutReceived) {
        Object object = this.lock;
        synchronized (object) {
            this.logoutReceived = logoutReceived;
        }
    }

    public boolean isLogoutTimedOut() {
        return this.isLogoutSent() && SystemTime.currentTimeMillis() - this.getLastSentTime() >= this.getLogoutTimeoutMs();
    }

    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTestRequestCounter() {
        Object object = this.lock;
        synchronized (object) {
            return this.testRequestCounter;
        }
    }

    public double getTestRequestDelayMultiplier() {
        return this.testRequestDelayMultiplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTestRequestCounter() {
        Object object = this.lock;
        synchronized (object) {
            this.testRequestCounter = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementTestRequestCounter() {
        Object object = this.lock;
        synchronized (object) {
            ++this.testRequestCounter;
        }
    }

    public boolean isTestRequestNeeded() {
        long millisSinceLastReceivedTime = this.timeSinceLastReceivedMessage();
        return (double)millisSinceLastReceivedTime >= (1.0 + this.testRequestDelayMultiplier) * (double)(this.getTestRequestCounter() + 1) * (double)this.getHeartBeatMillis();
    }

    private long timeSinceLastReceivedMessage() {
        return SystemTime.currentTimeMillis() - this.getLastReceivedTime();
    }

    public boolean isTimedOut() {
        long millisSinceLastReceivedTime = this.timeSinceLastReceivedMessage();
        return (double)millisSinceLastReceivedTime >= (1.0 + this.heartBeatTimeoutMultiplier) * (double)this.getHeartBeatMillis();
    }

    public boolean set(int sequence, String message) throws IOException {
        return this.messageStore.set(sequence, message);
    }

    public void get(int first, int last, Collection<String> messages) throws IOException {
        this.messageStore.get(first, last, messages);
    }

    public void enqueue(int sequence, Message message) {
        this.messageQueue.put(sequence, message);
    }

    public Message dequeue(int sequence) {
        return this.messageQueue.remove(sequence);
    }

    public void dequeueMessagesUpTo(int seqnum) {
        for (int i = 1; i < seqnum; ++i) {
            this.dequeue(i);
        }
    }

    public Message getNextQueuedMessage() {
        return !this.messageQueue.isEmpty() ? this.messageQueue.values().iterator().next() : null;
    }

    public Collection<Integer> getQueuedSeqNums() {
        return this.messageQueue.keySet();
    }

    public void clearQueue() {
        this.messageQueue.clear();
    }

    public void lockSenderMsgSeqNum() {
        this.senderMsgSeqNumLock.lock();
    }

    public void unlockSenderMsgSeqNum() {
        this.senderMsgSeqNumLock.unlock();
    }

    public void lockTargetMsgSeqNum() {
        this.targetMsgSeqNumLock.lock();
    }

    public void unlockTargetMsgSeqNum() {
        this.targetMsgSeqNumLock.unlock();
    }

    public int getNextSenderMsgSeqNum() throws IOException {
        return this.messageStore.getNextSenderMsgSeqNum();
    }

    public int getNextTargetMsgSeqNum() throws IOException {
        return this.messageStore.getNextTargetMsgSeqNum();
    }

    public void setNextTargetMsgSeqNum(int sequence) throws IOException {
        this.messageStore.setNextTargetMsgSeqNum(sequence);
    }

    public void incrNextSenderMsgSeqNum() throws IOException {
        this.messageStore.incrNextSenderMsgSeqNum();
    }

    public void incrNextTargetMsgSeqNum() throws IOException {
        this.messageStore.incrNextTargetMsgSeqNum();
    }

    public Date getCreationTime() throws IOException {
        return this.messageStore.getCreationTime();
    }

    public boolean isResetNeeded() throws IOException {
        return this.getNextSenderMsgSeqNum() != 1 || this.getNextTargetMsgSeqNum() != 1;
    }

    public void reset() {
        try {
            this.messageStore.reset();
        }
        catch (IOException e) {
            throw new RuntimeError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResendRange(int low, int high) {
        Object object = this.lock;
        synchronized (object) {
            this.resendRange.setBeginSeqNo(low);
            this.resendRange.setEndSeqNo(high);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResendRange(int low, int high, int currentResend) {
        Object object = this.lock;
        synchronized (object) {
            this.resendRange.setBeginSeqNo(low);
            this.resendRange.setEndSeqNo(high);
            this.resendRange.setCurrentEndSeqNo(currentResend);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResendRequested() {
        Object object = this.lock;
        synchronized (object) {
            return this.resendRange.getBeginSeqNo() != 0 || this.resendRange.getEndSeqNo() != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResendRange getResendRange() {
        Object object = this.lock;
        synchronized (object) {
            return this.resendRange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResetReceived() {
        Object object = this.lock;
        synchronized (object) {
            return this.resetReceived;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResetReceived(boolean resetReceived) {
        Object object = this.lock;
        synchronized (object) {
            this.resetReceived = resetReceived;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResetSent() {
        Object object = this.lock;
        synchronized (object) {
            return this.resetSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResetSent(boolean resetSent) {
        Object object = this.lock;
        synchronized (object) {
            this.resetSent = resetSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResetRangeFromLastExpectedLogonNextSeqNumLogon() {
        Object object = this.lock;
        synchronized (object) {
            this.setResendRange(this.getLastExpectedLogonNextSeqNum(), 0);
            this.setLastExpectedLogonNextSeqNum(0);
        }
    }

    public void setLastExpectedLogonNextSeqNum(int lastExpectedLogonNextSeqNum) {
        this.nextExpectedMsgSeqNum.set(lastExpectedLogonNextSeqNum);
    }

    public int getLastExpectedLogonNextSeqNum() {
        return this.nextExpectedMsgSeqNum.get();
    }

    public boolean isExpectedLogonNextSeqNumSent() {
        return this.nextExpectedMsgSeqNum.get() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogoutReason(String reason) {
        Object object = this.lock;
        synchronized (object) {
            this.logoutReason = reason;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogoutReason() {
        Object object = this.lock;
        synchronized (object) {
            return this.logoutReason;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLogoutReason() {
        Object object = this.lock;
        synchronized (object) {
            this.logoutReason = "";
        }
    }

    public Object getLock() {
        return this.lock;
    }

    public static class ResendRange {
        int beginSeqNo = 0;
        int endSeqNo = 0;
        int currentEndSeqNo = 0;

        public int getBeginSeqNo() {
            return this.beginSeqNo;
        }

        public void setBeginSeqNo(int beginSeqNo) {
            this.beginSeqNo = beginSeqNo;
        }

        public int getEndSeqNo() {
            return this.endSeqNo;
        }

        public void setEndSeqNo(int endSeqNo) {
            this.endSeqNo = endSeqNo;
        }

        public int getCurrentEndSeqNo() {
            return this.currentEndSeqNo;
        }

        public void setCurrentEndSeqNo(int currentEndSeqNo) {
            this.currentEndSeqNo = currentEndSeqNo;
        }

        public boolean isChunkedResendRequest() {
            return this.getCurrentEndSeqNo() > 0;
        }
    }

    private static final class NullLog
    implements Log {
        private NullLog() {
        }

        @Override
        public void onOutgoing(String message) {
        }

        @Override
        public void onIncoming(String message) {
        }

        @Override
        public void onEvent(String text) {
        }

        @Override
        public void onErrorEvent(String text) {
        }

        @Override
        public void clear() {
        }
    }
}

