/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.message;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.filter.codec.demux.MessageEncoder;
import org.quickfixj.CharsetSupport;
import quickfix.Message;

public class FIXMessageEncoder
implements MessageEncoder<Object> {
    private static final Set<Class<?>> TYPES = new HashSet<Class>(Arrays.asList(Message.class, String.class));
    private final String charsetEncoding = CharsetSupport.getCharset();

    public static Set<Class<?>> getMessageTypes() {
        return TYPES;
    }

    private byte[] toBytes(String str) throws ProtocolCodecException {
        try {
            return str.getBytes(this.charsetEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new ProtocolCodecException((Throwable)e);
        }
    }

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws ProtocolCodecException {
        byte[] bytes;
        if (message instanceof String) {
            bytes = this.toBytes((String)message);
        } else if (message instanceof Message) {
            bytes = this.toBytes(message.toString());
        } else {
            throw new ProtocolCodecException("Invalid FIX message object type: " + message.getClass());
        }
        IoBuffer buffer = IoBuffer.allocate((int)bytes.length);
        buffer.put(bytes);
        buffer.flip();
        out.write((Object)buffer);
    }
}

