/*
 * Decompiled with CFR 0.152.
 */
package quickfix.field.converter;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.concurrent.ConcurrentHashMap;
import quickfix.FieldConvertError;
import quickfix.SystemTime;
import quickfix.field.converter.AbstractDateTimeConverter;

public class UtcTimestampConverter
extends AbstractDateTimeConverter {
    static final int LENGTH_INCL_SECONDS = 17;
    static final int LENGTH_INCL_MILLIS = 21;
    static final int LENGTH_INCL_MICROS = 24;
    static final int LENGTH_INCL_NANOS = 27;
    static final int LENGTH_INCL_PICOS = 30;
    private static final ThreadLocal<UtcTimestampConverter> UTC_TIMESTAMP_CONVERTER = new ThreadLocal();
    private final DateFormat utcTimestampFormat = this.createDateFormat("yyyyMMdd-HH:mm:ss");
    private final DateFormat utcTimestampFormatMillis = this.createDateFormat("yyyyMMdd-HH:mm:ss.SSS");
    private static final ConcurrentHashMap<String, Long> DATE_CACHE = new ConcurrentHashMap();

    public static String convert(Date d, boolean includeMilliseconds) {
        return UtcTimestampConverter.getFormatter(includeMilliseconds).format(d);
    }

    private static DateFormat getFormatter(boolean includeMillis) {
        UtcTimestampConverter converter = UTC_TIMESTAMP_CONVERTER.get();
        if (converter == null) {
            converter = new UtcTimestampConverter();
            UTC_TIMESTAMP_CONVERTER.set(converter);
        }
        return includeMillis ? converter.utcTimestampFormatMillis : converter.utcTimestampFormat;
    }

    public static Date convert(String value) throws FieldConvertError {
        UtcTimestampConverter.verifyFormat(value);
        long timeOffset = UtcTimestampConverter.parseLong(value.substring(9, 11)) * 3600000L + UtcTimestampConverter.parseLong(value.substring(12, 14)) * 60000L + UtcTimestampConverter.parseLong(value.substring(15, 17)) * 1000L;
        if (value.length() == 21 || value.length() == 24 || value.length() == 27 || value.length() == 30) {
            timeOffset += UtcTimestampConverter.parseLong(value.substring(18, 21));
        }
        return new Date(UtcTimestampConverter.getMillisForDay(value) + timeOffset);
    }

    private static Long getMillisForDay(String value) {
        String dateString = value.substring(0, 8);
        Long millis = DATE_CACHE.get(dateString);
        if (millis == null) {
            GregorianCalendar c = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
            ((Calendar)c).setTimeZone(SystemTime.UTC_TIMEZONE);
            int year = Integer.parseInt(value.substring(0, 4));
            int month = Integer.parseInt(value.substring(4, 6));
            int day = Integer.parseInt(value.substring(6, 8));
            c.set(year, month - 1, day);
            millis = c.getTimeInMillis();
            DATE_CACHE.put(dateString, c.getTimeInMillis());
        }
        return millis;
    }

    private static void verifyFormat(String value) throws FieldConvertError {
        String type = "timestamp";
        if (value.length() != 17 && value.length() != 21 && value.length() != 24 && value.length() != 27 && value.length() != 30) {
            UtcTimestampConverter.throwFieldConvertError(value, type);
        }
        UtcTimestampConverter.assertDigitSequence(value, 0, 8, type);
        UtcTimestampConverter.assertSeparator(value, 8, '-', type);
        UtcTimestampConverter.assertDigitSequence(value, 9, 11, type);
        UtcTimestampConverter.assertSeparator(value, 11, ':', type);
        UtcTimestampConverter.assertDigitSequence(value, 12, 14, type);
        UtcTimestampConverter.assertSeparator(value, 14, ':', type);
        UtcTimestampConverter.assertDigitSequence(value, 15, 17, type);
        if (value.length() == 21) {
            UtcTimestampConverter.assertSeparator(value, 17, '.', type);
            UtcTimestampConverter.assertDigitSequence(value, 18, 21, type);
        } else if (value.length() == 24) {
            UtcTimestampConverter.assertSeparator(value, 17, '.', type);
            UtcTimestampConverter.assertDigitSequence(value, 18, 24, type);
        } else if (value.length() == 27) {
            UtcTimestampConverter.assertSeparator(value, 17, '.', type);
            UtcTimestampConverter.assertDigitSequence(value, 18, 27, type);
        } else if (value.length() == 30) {
            UtcTimestampConverter.assertSeparator(value, 17, '.', type);
            UtcTimestampConverter.assertDigitSequence(value, 18, 30, type);
        } else if (value.length() != 17) {
            UtcTimestampConverter.throwFieldConvertError(value, type);
        }
    }
}

