/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import quickfix.Application;
import quickfix.ConfigError;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.RuntimeError;
import quickfix.ScreenLogFactory;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionSettings;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.SingleThreadedEventHandlingStrategy;
import quickfix.mina.initiator.AbstractSocketInitiator;

public class SocketInitiator
extends AbstractSocketInitiator {
    private volatile Boolean isStarted = Boolean.FALSE;
    private final SingleThreadedEventHandlingStrategy eventHandlingStrategy;

    public SocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, MessageFactory messageFactory, int queueCapacity) throws ConfigError {
        super(application, messageStoreFactory, settings, new ScreenLogFactory(settings), messageFactory);
        if (settings == null) {
            throw new ConfigError("no settings");
        }
        this.eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this, queueCapacity);
    }

    public SocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, MessageFactory messageFactory) throws ConfigError {
        super(application, messageStoreFactory, settings, new ScreenLogFactory(settings), messageFactory);
        if (settings == null) {
            throw new ConfigError("no settings");
        }
        this.eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this, 10000);
    }

    public SocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory) throws ConfigError {
        super(application, messageStoreFactory, settings, logFactory, messageFactory);
        if (settings == null) {
            throw new ConfigError("no settings");
        }
        this.eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this, 10000);
    }

    public SocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory, int queueCapacity) throws ConfigError {
        super(application, messageStoreFactory, settings, logFactory, messageFactory);
        if (settings == null) {
            throw new ConfigError("no settings");
        }
        this.eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this, queueCapacity);
    }

    public SocketInitiator(SessionFactory sessionFactory, SessionSettings settings, int queueCapacity) throws ConfigError {
        super(settings, sessionFactory);
        this.eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this, queueCapacity);
    }

    @Override
    @Deprecated
    public void block() throws ConfigError, RuntimeError {
        this.initialize(false);
    }

    @Override
    public void start() throws ConfigError, RuntimeError {
        this.initialize(true);
    }

    @Override
    public void stop() {
        this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean forceDisconnect) {
        if (this.isStarted.equals(Boolean.TRUE)) {
            try {
                this.logoutAllSessions(forceDisconnect);
                this.stopInitiators();
            }
            finally {
                Session.unregisterSessions(this.getSessions());
                this.eventHandlingStrategy.stopHandlingMessages();
                this.isStarted = Boolean.FALSE;
            }
        }
    }

    private void initialize(boolean blockInThread) throws ConfigError {
        if (this.isStarted.equals(Boolean.FALSE)) {
            this.eventHandlingStrategy.setExecutor(this.longLivedExecutor);
            this.createSessionInitiators();
            for (Session session : this.getSessionMap().values()) {
                Session.registerSession(session);
            }
            this.startInitiators();
            this.isStarted = Boolean.TRUE;
            if (blockInThread) {
                this.eventHandlingStrategy.blockInThread();
            } else {
                this.eventHandlingStrategy.block();
            }
        } else {
            this.log.warn("Ignored attempt to start already running SocketInitiator.");
        }
    }

    @Override
    protected EventHandlingStrategy getEventHandlingStrategy() {
        return this.eventHandlingStrategy;
    }
}

