/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import quickfix.AbstractLog;
import quickfix.ConfigError;
import quickfix.FieldConvertError;
import quickfix.JdbcUtil;
import quickfix.LogUtil;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.SystemTime;

class JdbcLog
extends AbstractLog {
    private static final String DEFAULT_MESSAGES_LOG_TABLE = "messages_log";
    private static final String DEFAULT_EVENT_LOG_TABLE = "event_log";
    private final String outgoingMessagesTableName;
    private final String incomingMessagesTableName;
    private final String eventTableName;
    private final SessionID sessionID;
    private final DataSource dataSource;
    private final boolean logHeartbeats;
    private final boolean extendedSessionIdSupported;
    private final String defaultSessionIdPropertyValue;
    private Throwable recursiveException = null;
    private final Map<String, String> insertItemSqlCache = new HashMap<String, String>();
    private final Map<String, String> deleteItemsSqlCache = new HashMap<String, String>();

    public JdbcLog(SessionSettings settings, SessionID sessionID, DataSource ds) throws SQLException, ClassNotFoundException, ConfigError, FieldConvertError {
        this.sessionID = sessionID;
        this.dataSource = ds == null ? JdbcUtil.getDataSource(settings, sessionID) : ds;
        this.logHeartbeats = !settings.isSetting("JdbcLogHeartBeats") || settings.getBool("JdbcLogHeartBeats");
        this.setLogHeartbeats(this.logHeartbeats);
        this.outgoingMessagesTableName = settings.isSetting("JdbcLogOutgoingTable") ? settings.getString(sessionID, "JdbcLogOutgoingTable") : DEFAULT_MESSAGES_LOG_TABLE;
        this.incomingMessagesTableName = settings.isSetting("JdbcLogIncomingTable") ? settings.getString(sessionID, "JdbcLogIncomingTable") : DEFAULT_MESSAGES_LOG_TABLE;
        this.eventTableName = settings.isSetting("JdbcLogEventTable") ? settings.getString(sessionID, "JdbcLogEventTable") : DEFAULT_EVENT_LOG_TABLE;
        this.defaultSessionIdPropertyValue = settings.isSetting(sessionID, "JdbcSessionIdDefaultPropertyValue") ? settings.getString(sessionID, "JdbcSessionIdDefaultPropertyValue") : "";
        this.extendedSessionIdSupported = JdbcUtil.determineSessionIdSupport(this.dataSource, this.outgoingMessagesTableName);
        this.createCachedSql();
    }

    private void createCachedSql() {
        this.createInsertItemSql(this.outgoingMessagesTableName);
        this.createInsertItemSql(this.incomingMessagesTableName);
        this.createInsertItemSql(this.eventTableName);
        this.createDeleteItemsSql(this.outgoingMessagesTableName);
        this.createDeleteItemsSql(this.incomingMessagesTableName);
        this.createDeleteItemsSql(this.eventTableName);
    }

    private void createInsertItemSql(String tableName) {
        this.insertItemSqlCache.put(tableName, "INSERT INTO " + tableName + " (time, " + JdbcUtil.getIDColumns(this.extendedSessionIdSupported) + ", text) " + "VALUES (?," + JdbcUtil.getIDPlaceholders(this.extendedSessionIdSupported) + ",?)");
    }

    private String getInsertItemSql(String tableName) {
        return this.insertItemSqlCache.get(tableName);
    }

    private void createDeleteItemsSql(String tableName) {
        this.deleteItemsSqlCache.put(tableName, "DELETE FROM " + tableName + " WHERE " + JdbcUtil.getIDWhereClause(this.extendedSessionIdSupported));
    }

    private String getDeleteItemsSql(String tableName) {
        return this.deleteItemsSqlCache.get(tableName);
    }

    @Override
    public void onEvent(String value) {
        this.insert(this.eventTableName, value);
    }

    @Override
    protected void logIncoming(String message) {
        this.insert(this.incomingMessagesTableName, message);
    }

    @Override
    protected void logOutgoing(String message) {
        this.insert(this.outgoingMessagesTableName, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(String tableName, String value) {
        Connection connection = null;
        PreparedStatement insert = null;
        if (this.recursiveException != null) {
            System.err.println("JdbcLog cannot log SQLException due to recursive log errors!");
            this.recursiveException.printStackTrace();
            this.recursiveException = null;
            return;
        }
        this.recursiveException = null;
        try {
            connection = this.dataSource.getConnection();
            insert = connection.prepareStatement(this.getInsertItemSql(tableName));
            insert.setTimestamp(1, new Timestamp(SystemTime.getUtcCalendar().getTimeInMillis()));
            int offset = this.setSessionIdParameters(insert, 2);
            insert.setString(offset, value);
            insert.execute();
        }
        catch (SQLException e) {
            try {
                this.recursiveException = e;
                LogUtil.logThrowable(this.sessionID, e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtil.close(this.sessionID, insert);
                JdbcUtil.close(this.sessionID, connection);
                throw throwable;
            }
            JdbcUtil.close(this.sessionID, insert);
            JdbcUtil.close(this.sessionID, connection);
        }
        JdbcUtil.close(this.sessionID, insert);
        JdbcUtil.close(this.sessionID, connection);
    }

    @Override
    public void clear() {
        this.clearTable(this.eventTableName);
        this.clearTable(this.incomingMessagesTableName);
        if (!this.incomingMessagesTableName.equals(this.outgoingMessagesTableName)) {
            this.clearTable(this.outgoingMessagesTableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTable(String tableName) {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.prepareStatement(this.getDeleteItemsSql(tableName));
            this.setSessionIdParameters(statement, 1);
            statement.execute();
        }
        catch (SQLException e) {
            try {
                LogUtil.logThrowable(this.sessionID, e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtil.close(this.sessionID, statement);
                JdbcUtil.close(this.sessionID, connection);
                throw throwable;
            }
            JdbcUtil.close(this.sessionID, statement);
            JdbcUtil.close(this.sessionID, connection);
        }
        JdbcUtil.close(this.sessionID, statement);
        JdbcUtil.close(this.sessionID, connection);
    }

    public String getIncomingMessagesTableName() {
        return this.incomingMessagesTableName;
    }

    public String getOutgoingMessagesTableName() {
        return this.outgoingMessagesTableName;
    }

    public String getEventTableName() {
        return this.eventTableName;
    }

    private int setSessionIdParameters(PreparedStatement query, int offset) throws SQLException {
        return JdbcUtil.setSessionIdParameters(this.sessionID, query, offset, this.extendedSessionIdSupported, this.defaultSessionIdPropertyValue);
    }

    @Override
    public void onErrorEvent(String text) {
        this.onEvent(text);
    }
}

