/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.python.core.ArgParser;
import org.python.core.BufferProtocol;
import org.python.core.Py;
import org.python.core.PyBaseString;
import org.python.core.PyBuffer;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode$PyExposer;
import org.python.core.PyUnicodeDerived;
import org.python.core.StringFormatter;
import org.python.core.Untraversable;
import org.python.core.codecs;
import org.python.core.stringlib.FieldNameIterator;
import org.python.core.stringlib.MarkupIterator;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.google.common.base.CharMatcher;
import org.python.modules._codecs;
import org.python.util.Generic;

@Untraversable
@ExposedType(name="unicode", base=PyBaseString.class, doc="unicode(object='') -> unicode object\nunicode(string[, encoding[, errors]]) -> unicode object\n\nCreate a new Unicode object from the given encoded string.\nencoding defaults to the current default string encoding.\nerrors can be 'strict', 'replace' or 'ignore' and defaults to 'strict'.")
public class PyUnicode
extends PyString
implements Iterable {
    private static final boolean DEBUG_NON_BMP_METHODS = false;
    public static final PyType TYPE;
    private final IndexTranslator translator;
    static final IndexTranslator BASIC;

    public PyUnicode() {
        this(TYPE, "", true);
    }

    public PyUnicode(String string) {
        this(TYPE, string, false);
    }

    public PyUnicode(String string, boolean isBasic) {
        this(TYPE, string, isBasic);
    }

    public PyUnicode(PyType subtype, String string) {
        this(subtype, string, false);
    }

    public PyUnicode(PyString pystring) {
        this(TYPE, pystring);
    }

    public PyUnicode(PyType subtype, PyString pystring) {
        this(subtype, pystring instanceof PyUnicode ? pystring.string : pystring.decode().toString(), pystring.isBasicPlane());
    }

    public PyUnicode(char c) {
        this(TYPE, String.valueOf(c), true);
    }

    public PyUnicode(int codepoint) {
        this(TYPE, new String(new int[]{codepoint}, 0, 1));
    }

    public PyUnicode(int[] codepoints) {
        this(new String(codepoints, 0, codepoints.length));
    }

    PyUnicode(StringBuilder buffer) {
        this(TYPE, new String(buffer));
    }

    private static StringBuilder fromCodePoints(Iterator<Integer> iter) {
        StringBuilder buffer = new StringBuilder();
        while (iter.hasNext()) {
            buffer.appendCodePoint(iter.next());
        }
        return buffer;
    }

    public PyUnicode(Iterator<Integer> iter) {
        this(PyUnicode.fromCodePoints(iter));
    }

    public PyUnicode(Collection<Integer> ucs4) {
        this(ucs4.iterator());
    }

    private PyUnicode(PyType subtype, String string, boolean isBasic) {
        super(subtype, "");
        this.string = string;
        this.translator = isBasic ? BASIC : this.chooseIndexTranslator();
    }

    @Override
    public int[] toCodePoints() {
        int n = this.getCodePointCount();
        int[] codePoints = new int[n];
        int i = 0;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            codePoints[i] = iter.next();
            ++i;
        }
        return codePoints;
    }

    private static int[] getSupplementaryCounts(String string) {
        int p;
        int n = string.length();
        for (p = 0; p < n && !Character.isSurrogate(string.charAt(p)); ++p) {
        }
        if (p == n) {
            return null;
        }
        int q = p;
        int k = q >> 4;
        int[] count2 = new int[1 + (n >> 4)];
        while (p < n - 1) {
            p += PyUnicode.calcAdvance(string, p);
            if ((++q & 0xF) != 0) continue;
            count2[k++] = p - q;
            break;
        }
        while (p + 32 < n) {
            for (int i = 0; i < 16; ++i) {
                p += PyUnicode.calcAdvance(string, p);
            }
            count2[k++] = p - (q += 16);
        }
        while (p < n - 1) {
            p += PyUnicode.calcAdvance(string, p);
            if ((++q & 0xF) != 0) continue;
            count2[k++] = p - q;
        }
        if (p < n) {
            char c;
            if (Character.isSurrogate(c = string.charAt(p++))) {
                throw PyUnicode.unpairedSurrogate(p - 1, c);
            }
            ++q;
        }
        int total = p - q;
        while (k < count2.length) {
            count2[k++] = total;
        }
        return count2;
    }

    private static int calcAdvance(String string, int p) throws PyException {
        char c = string.charAt(p);
        if (c >= '\ud800') {
            if (c < '\udc00') {
                if (Character.isLowSurrogate(string.charAt(p + 1))) {
                    return 2;
                }
                throw PyUnicode.unpairedSurrogate(p, c);
            }
            if (c <= '\udfff') {
                throw PyUnicode.unpairedSurrogate(p, c);
            }
        }
        return 1;
    }

    private static PyException unpairedSurrogate(int p, int c) {
        String fmt = "unpaired surrogate %#4x at code unit %d";
        String msg = String.format(fmt, c, p);
        return Py.ValueError(msg);
    }

    private IndexTranslator chooseIndexTranslator() {
        int[] count2 = PyUnicode.getSupplementaryCounts(this.string);
        return count2 == null ? BASIC : new Supplementary(count2);
    }

    @Override
    protected int[] translateIndices(PyObject start, PyObject end) {
        int[] indices = super.translateIndices(start, end);
        indices[0] = this.translator.utf16Index(indices[0]);
        indices[1] = this.translator.utf16Index(indices[1]);
        return indices;
    }

    @Override
    public String substring(int start, int end) {
        return super.substring(this.translator.utf16Index(start), this.translator.utf16Index(end));
    }

    public static PyUnicode fromInterned(String interned) {
        PyUnicode uni = new PyUnicode(TYPE, interned);
        uni.interned = true;
        return uni;
    }

    @Override
    public boolean isBasicPlane() {
        return this.translator == BASIC;
    }

    public int getCodePointCount() {
        return this.string.length() - this.translator.suppCount();
    }

    private static String checkEncoding(String s) {
        if (s == null || CharMatcher.ASCII.matchesAllOf(s)) {
            return s;
        }
        return codecs.PyUnicode_EncodeASCII(s, s.length(), null);
    }

    @ExposedNew
    static final PyObject unicode_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("unicode", args, keywords, new String[]{"string", "encoding", "errors"}, 0);
        PyObject S = ap.getPyObject(0, null);
        String encoding = PyUnicode.checkEncoding(ap.getString(1, null));
        String errors = PyUnicode.checkEncoding(ap.getString(2, null));
        if (new_.for_type == subtype) {
            if (S == null) {
                return new PyUnicode("");
            }
            if (S instanceof PyUnicode) {
                return new PyUnicode(((PyUnicode)S).getString());
            }
            if (S instanceof PyString) {
                if (S.getType() != PyString.TYPE && encoding == null && errors == null) {
                    return S.__unicode__();
                }
                PyObject decoded = codecs.decode((PyString)S, encoding, errors);
                if (decoded instanceof PyUnicode) {
                    return new PyUnicode((PyUnicode)decoded);
                }
                throw Py.TypeError("decoder did not return an unicode object (type=" + decoded.getType().fastGetName() + ")");
            }
            return S.__unicode__();
        }
        if (S == null) {
            return new PyUnicodeDerived(subtype, Py.EmptyString);
        }
        if (S instanceof PyUnicode) {
            return new PyUnicodeDerived(subtype, (PyUnicode)S);
        }
        return new PyUnicodeDerived(subtype, S.__str__());
    }

    @Override
    public PyString createInstance(String str) {
        return new PyUnicode(str);
    }

    @Override
    protected PyString createInstance(String string, boolean isBasic) {
        return new PyUnicode(string, isBasic);
    }

    @Override
    public PyObject __mod__(PyObject other) {
        return this.unicode___mod__(other);
    }

    final PyObject unicode___mod__(PyObject other) {
        StringFormatter fmt = new StringFormatter(this.getString(), true);
        return fmt.format(other);
    }

    @Override
    public PyUnicode __unicode__() {
        return this;
    }

    @Override
    public PyString __str__() {
        return this.unicode___str__();
    }

    final PyString unicode___str__() {
        return new PyString(this.encode());
    }

    @Override
    public int __len__() {
        return this.unicode___len__();
    }

    final int unicode___len__() {
        return this.getCodePointCount();
    }

    @Override
    public PyString __repr__() {
        return this.unicode___repr__();
    }

    final PyString unicode___repr__() {
        return new PyString("u" + PyUnicode.encode_UnicodeEscape(this.getString(), true));
    }

    final PyObject unicode___getitem__(PyObject index) {
        return this.str___getitem__(index);
    }

    final PyObject unicode___getslice__(PyObject start, PyObject stop, PyObject step) {
        return this.seq___getslice__(start, stop, step);
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        if (this.isBasicPlane()) {
            return super.getslice(start, stop, step);
        }
        if (step > 0 && stop < start) {
            stop = start;
        }
        StringBuilder buffer = new StringBuilder(PyUnicode.sliceLength(start, stop, step));
        Iterator<Integer> iter = this.newSubsequenceIterator(start, stop, step);
        while (iter.hasNext()) {
            buffer.appendCodePoint(iter.next());
        }
        return this.createInstance(new String(buffer));
    }

    final int unicode___cmp__(PyObject other) {
        return this.str___cmp__(other);
    }

    final PyObject unicode___eq__(PyObject other) {
        return this.str___eq__(other);
    }

    final PyObject unicode___ne__(PyObject other) {
        return this.str___ne__(other);
    }

    final int unicode___hash__() {
        return this.str___hash__();
    }

    @Override
    protected PyObject pyget(int i) {
        int codepoint = this.getString().codePointAt(this.translator.utf16Index(i));
        return Py.makeCharacter(codepoint, true);
    }

    @Override
    public int getInt(int i) {
        return this.getString().codePointAt(this.translator.utf16Index(i));
    }

    public Iterator<Integer> newSubsequenceIterator() {
        return new SubsequenceIteratorImpl();
    }

    public Iterator<Integer> newSubsequenceIterator(int start, int stop, int step) {
        if (step < 0) {
            return new SteppedIterator(step * -1, new ReversedIterator(new SubsequenceIteratorImpl(stop + 1, start + 1, 1)));
        }
        return new SubsequenceIteratorImpl(start, stop, step);
    }

    private PyUnicode coerceToUnicode(PyObject o) {
        if (o instanceof PyUnicode) {
            return (PyUnicode)o;
        }
        if (o instanceof PyString) {
            return new PyUnicode(((PyString)o).getString(), true);
        }
        if (o instanceof BufferProtocol) {
            try (PyBuffer buf = ((BufferProtocol)((Object)o)).getBuffer(284);){
                PyUnicode pyUnicode = new PyUnicode(buf.toString(), true);
                return pyUnicode;
            }
        }
        if (o == null) {
            o = Py.None;
        }
        throw Py.TypeError("coercing to Unicode: need string or buffer, " + o.getType().fastGetName() + " found");
    }

    private PyUnicode coerceToUnicodeOrNull(PyObject o) {
        if (o == null || o == Py.None) {
            return null;
        }
        return this.coerceToUnicode(o);
    }

    final boolean unicode___contains__(PyObject o) {
        return this.str___contains__(o);
    }

    final PyObject unicode___mul__(PyObject o) {
        return this.str___mul__(o);
    }

    final PyObject unicode___rmul__(PyObject o) {
        return this.str___rmul__(o);
    }

    @Override
    public PyObject __add__(PyObject other) {
        return this.unicode___add__(other);
    }

    final PyObject unicode___add__(PyObject other) {
        PyUnicode otherUnicode;
        if (other instanceof PyUnicode) {
            otherUnicode = (PyUnicode)other;
        } else if (other instanceof PyString) {
            otherUnicode = (PyUnicode)((PyString)other).decode();
        } else {
            return null;
        }
        return new PyUnicode(this.getString().concat(otherUnicode.getString()));
    }

    final PyObject unicode_lower() {
        return new PyUnicode(this.getString().toLowerCase());
    }

    final PyObject unicode_upper() {
        return new PyUnicode(this.getString().toUpperCase());
    }

    final PyObject unicode_title() {
        if (this.isBasicPlane()) {
            return new PyUnicode(this.str_title());
        }
        StringBuilder buffer = new StringBuilder(this.getString().length());
        boolean previous_is_cased = false;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (previous_is_cased) {
                buffer.appendCodePoint(Character.toLowerCase(codePoint));
            } else {
                buffer.appendCodePoint(Character.toTitleCase(codePoint));
            }
            if (Character.isLowerCase(codePoint) || Character.isUpperCase(codePoint) || Character.isTitleCase(codePoint)) {
                previous_is_cased = true;
                continue;
            }
            previous_is_cased = false;
        }
        return new PyUnicode(buffer);
    }

    final PyObject unicode_swapcase() {
        if (this.isBasicPlane()) {
            return new PyUnicode(this.str_swapcase());
        }
        StringBuilder buffer = new StringBuilder(this.getString().length());
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (Character.isUpperCase(codePoint)) {
                buffer.appendCodePoint(Character.toLowerCase(codePoint));
                continue;
            }
            if (Character.isLowerCase(codePoint)) {
                buffer.appendCodePoint(Character.toUpperCase(codePoint));
                continue;
            }
            buffer.appendCodePoint(codePoint);
        }
        return new PyUnicode(buffer);
    }

    private PyUnicode coerceStripSepToUnicode(PyObject o) {
        if (o == null) {
            return null;
        }
        if (o instanceof PyUnicode) {
            return (PyUnicode)o;
        }
        if (o instanceof PyString) {
            return new PyUnicode(((PyString)o).decode().toString());
        }
        if (o == Py.None) {
            return null;
        }
        throw Py.TypeError("strip arg must be None, unicode or str");
    }

    final PyObject unicode_strip(PyObject sepObj) {
        PyUnicode sep = this.coerceStripSepToUnicode(sepObj);
        if (this.isBasicPlane()) {
            if (sep == null) {
                return new PyUnicode(this._strip());
            }
            if (sep.isBasicPlane()) {
                return new PyUnicode(this._strip(sep.getString()));
            }
        }
        return new PyUnicode(new ReversedIterator(new StripIterator(sep, new ReversedIterator(new StripIterator(sep, this.newSubsequenceIterator())))));
    }

    final PyObject unicode_lstrip(PyObject sepObj) {
        PyUnicode sep = this.coerceStripSepToUnicode(sepObj);
        if (this.isBasicPlane()) {
            if (sep == null) {
                return new PyUnicode(this._lstrip());
            }
            if (sep.isBasicPlane()) {
                return new PyUnicode(this._lstrip(sep.getString()));
            }
        }
        return new PyUnicode(new StripIterator(sep, this.newSubsequenceIterator()));
    }

    final PyObject unicode_rstrip(PyObject sepObj) {
        PyUnicode sep = this.coerceStripSepToUnicode(sepObj);
        if (this.isBasicPlane()) {
            if (sep == null) {
                return new PyUnicode(this._rstrip());
            }
            if (sep.isBasicPlane()) {
                return new PyUnicode(this._rstrip(sep.getString()));
            }
        }
        return new PyUnicode(new ReversedIterator(new StripIterator(sep, new ReversedIterator<Integer>(this.newSubsequenceIterator()))));
    }

    @Override
    public PyTuple partition(PyObject sep) {
        return this.unicode_partition(sep);
    }

    final PyTuple unicode_partition(PyObject sep) {
        return this.unicodePartition(this.coerceToUnicode(sep));
    }

    private SplitIterator newSplitIterator(PyUnicode sep, int maxsplit) {
        if (sep == null) {
            return new WhitespaceSplitIterator(maxsplit);
        }
        if (sep.getCodePointCount() == 0) {
            throw Py.ValueError("empty separator");
        }
        return new SepSplitIterator(sep, maxsplit);
    }

    @Override
    public PyTuple rpartition(PyObject sep) {
        return this.unicode_rpartition(sep);
    }

    final PyTuple unicode_rpartition(PyObject sep) {
        return this.unicodeRpartition(this.coerceToUnicode(sep));
    }

    final PyList unicode_split(PyObject sepObj, int maxsplit) {
        PyUnicode sep = this.coerceToUnicodeOrNull(sepObj);
        if (sep != null) {
            return this._split(sep.getString(), maxsplit);
        }
        return this._split(null, maxsplit);
    }

    final PyList unicode_rsplit(PyObject sepObj, int maxsplit) {
        PyUnicode sep = this.coerceToUnicodeOrNull(sepObj);
        if (sep != null) {
            return this._rsplit(sep.getString(), maxsplit);
        }
        return this._rsplit(null, maxsplit);
    }

    final PyList unicode_splitlines(boolean keepends) {
        if (this.isBasicPlane()) {
            return this.str_splitlines(keepends);
        }
        return new PyList(new LineSplitIterator(keepends));
    }

    @Override
    protected PyString fromSubstring(int begin, int end) {
        assert (this.isBasicPlane());
        return new PyUnicode(this.getString().substring(begin, end), true);
    }

    final int unicode_index(PyObject subObj, PyObject start, PyObject end) {
        PyUnicode sub = this.coerceToUnicode(subObj);
        return this.checkIndex(this._find(sub.getString(), start, end));
    }

    final int unicode_rindex(PyObject subObj, PyObject start, PyObject end) {
        PyUnicode sub = this.coerceToUnicode(subObj);
        return this.checkIndex(this._rfind(sub.getString(), start, end));
    }

    final int unicode_count(PyObject subObj, PyObject start, PyObject end) {
        PyUnicode sub = this.coerceToUnicode(subObj);
        if (this.isBasicPlane()) {
            return this._count(sub.getString(), start, end);
        }
        int[] indices = super.translateIndices(start, end);
        int count2 = 0;
        Iterator<Integer> mainIter = this.newSubsequenceIterator(indices[0], indices[1], 1);
        while (mainIter.hasNext()) {
            int matched = sub.getCodePointCount();
            Iterator<Integer> subIter = sub.newSubsequenceIterator();
            while (mainIter.hasNext() && subIter.hasNext() && mainIter.next() == subIter.next()) {
                --matched;
            }
            if (matched != 0) continue;
            ++count2;
        }
        return count2;
    }

    final int unicode_find(PyObject subObj, PyObject start, PyObject end) {
        int found = this._find(this.coerceToUnicode(subObj).getString(), start, end);
        return found < 0 ? -1 : this.translator.codePointIndex(found);
    }

    final int unicode_rfind(PyObject subObj, PyObject start, PyObject end) {
        int found = this._rfind(this.coerceToUnicode(subObj).getString(), start, end);
        return found < 0 ? -1 : this.translator.codePointIndex(found);
    }

    private static String padding(int n, int pad) {
        StringBuilder buffer = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            buffer.appendCodePoint(pad);
        }
        return buffer.toString();
    }

    private static int parse_fillchar(String function, String fillchar) {
        if (fillchar == null) {
            return 32;
        }
        if (fillchar.codePointCount(0, fillchar.length()) != 1) {
            throw Py.TypeError(function + "() argument 2 must be char, not str");
        }
        return fillchar.codePointAt(0);
    }

    final PyObject unicode_ljust(int width, String padding) {
        int n = width - this.getCodePointCount();
        if (n <= 0) {
            return new PyUnicode(this.getString());
        }
        return new PyUnicode(this.getString() + PyUnicode.padding(n, PyUnicode.parse_fillchar("ljust", padding)));
    }

    final PyObject unicode_rjust(int width, String padding) {
        int n = width - this.getCodePointCount();
        if (n <= 0) {
            return new PyUnicode(this.getString());
        }
        return new PyUnicode(PyUnicode.padding(n, PyUnicode.parse_fillchar("ljust", padding)) + this.getString());
    }

    final PyObject unicode_center(int width, String padding) {
        int n = width - this.getCodePointCount();
        if (n <= 0) {
            return new PyUnicode(this.getString());
        }
        int half = n / 2;
        if (n % 2 > 0 && width % 2 > 0) {
            ++half;
        }
        int pad = PyUnicode.parse_fillchar("center", padding);
        return new PyUnicode(PyUnicode.padding(half, pad) + this.getString() + PyUnicode.padding(n - half, pad));
    }

    final PyObject unicode_zfill(int width) {
        int n = this.getCodePointCount();
        if (n >= width) {
            return new PyUnicode(this.getString());
        }
        if (this.isBasicPlane()) {
            return new PyUnicode(this.str_zfill(width));
        }
        StringBuilder buffer = new StringBuilder(width);
        int nzeros = width - n;
        boolean first = true;
        boolean leadingSign = false;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (first) {
                first = false;
                if (codePoint == 43 || codePoint == 45) {
                    buffer.appendCodePoint(codePoint);
                    leadingSign = true;
                }
                for (int i = 0; i < nzeros; ++i) {
                    buffer.appendCodePoint(48);
                }
                if (leadingSign) continue;
                buffer.appendCodePoint(codePoint);
                continue;
            }
            buffer.appendCodePoint(codePoint);
        }
        if (first) {
            for (int i = 0; i < nzeros; ++i) {
                buffer.appendCodePoint(48);
            }
        }
        return new PyUnicode(buffer);
    }

    final PyObject unicode_expandtabs(int tabsize) {
        return new PyUnicode(this.str_expandtabs(tabsize));
    }

    final PyObject unicode_capitalize() {
        if (this.getString().length() == 0) {
            return this;
        }
        if (this.isBasicPlane()) {
            return new PyUnicode(this.str_capitalize());
        }
        StringBuilder buffer = new StringBuilder(this.getString().length());
        boolean first = true;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (first) {
                buffer.appendCodePoint(Character.toUpperCase(iter.next()));
                first = false;
                continue;
            }
            buffer.appendCodePoint(Character.toLowerCase(iter.next()));
        }
        return new PyUnicode(buffer);
    }

    final PyString unicode_replace(PyObject oldPieceObj, PyObject newPieceObj, int count2) {
        PyUnicode newPiece = this.coerceToUnicode(newPieceObj);
        PyUnicode oldPiece = this.coerceToUnicode(oldPieceObj);
        if (this.isBasicPlane() && newPiece.isBasicPlane() && oldPiece.isBasicPlane()) {
            return this._replace(oldPiece.getString(), newPiece.getString(), count2);
        }
        StringBuilder buffer = new StringBuilder();
        if (oldPiece.getCodePointCount() == 0) {
            Iterator<Integer> iter = this.newSubsequenceIterator();
            for (int i = 1; (count2 == -1 || i < count2) && iter.hasNext(); ++i) {
                if (i == 1) {
                    buffer.append(newPiece.getString());
                }
                buffer.appendCodePoint(iter.next());
                buffer.append(newPiece.getString());
            }
            while (iter.hasNext()) {
                buffer.appendCodePoint(iter.next());
            }
            return new PyUnicode(buffer);
        }
        SplitIterator iter = this.newSplitIterator(oldPiece, count2);
        int numSplits = 0;
        while (iter.hasNext()) {
            buffer.append(((PyUnicode)iter.next()).getString());
            if (iter.hasNext()) {
                buffer.append(newPiece.getString());
            }
            ++numSplits;
        }
        if (iter.getEndsWithSeparator() && (count2 == -1 || numSplits <= count2)) {
            buffer.append(newPiece.getString());
        }
        return new PyUnicode(buffer);
    }

    @Override
    public PyString join(PyObject seq) {
        return this.unicode_join(seq);
    }

    final PyUnicode unicode_join(PyObject seq) {
        return this.unicodeJoin(seq);
    }

    final boolean unicode_startswith(PyObject prefix, PyObject start, PyObject end) {
        return this.str_startswith(prefix, start, end);
    }

    final boolean unicode_endswith(PyObject suffix, PyObject start, PyObject end) {
        return this.str_endswith(suffix, start, end);
    }

    final PyObject unicode_translate(PyObject table) {
        return _codecs.translateCharmap(this, "ignore", table);
    }

    final boolean unicode_islower() {
        if (this.isBasicPlane()) {
            return this.str_islower();
        }
        boolean cased = false;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codepoint = iter.next();
            if (Character.isUpperCase(codepoint) || Character.isTitleCase(codepoint)) {
                return false;
            }
            if (cased || !Character.isLowerCase(codepoint)) continue;
            cased = true;
        }
        return cased;
    }

    final boolean unicode_isupper() {
        if (this.isBasicPlane()) {
            return this.str_isupper();
        }
        boolean cased = false;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codepoint = iter.next();
            if (Character.isLowerCase(codepoint) || Character.isTitleCase(codepoint)) {
                return false;
            }
            if (cased || !Character.isUpperCase(codepoint)) continue;
            cased = true;
        }
        return cased;
    }

    final boolean unicode_isalpha() {
        if (this.isBasicPlane()) {
            return this.str_isalpha();
        }
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (Character.isLetter(iter.next())) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isalnum() {
        if (this.isBasicPlane()) {
            return this.str_isalnum();
        }
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (Character.isLetterOrDigit(codePoint) || Character.getType(codePoint) == 10) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isdecimal() {
        if (this.isBasicPlane()) {
            return this.str_isdecimal();
        }
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (Character.getType(iter.next()) == 9) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isdigit() {
        if (this.isBasicPlane()) {
            return this.str_isdigit();
        }
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (Character.isDigit(iter.next())) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isnumeric() {
        if (this.isBasicPlane()) {
            return this.str_isnumeric();
        }
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int type = Character.getType(iter.next());
            if (type == 9 || type == 10 || type == 11) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_istitle() {
        if (this.isBasicPlane()) {
            return this.str_istitle();
        }
        if (this.getCodePointCount() == 0) {
            return false;
        }
        boolean cased = false;
        boolean previous_is_cased = false;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (Character.isUpperCase(codePoint) || Character.isTitleCase(codePoint)) {
                if (previous_is_cased) {
                    return false;
                }
                previous_is_cased = true;
                cased = true;
                continue;
            }
            if (Character.isLowerCase(codePoint)) {
                if (!previous_is_cased) {
                    return false;
                }
                previous_is_cased = true;
                cased = true;
                continue;
            }
            previous_is_cased = false;
        }
        return cased;
    }

    final boolean unicode_isspace() {
        if (this.isBasicPlane()) {
            return this.str_isspace();
        }
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (Character.isWhitespace(iter.next())) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isunicode() {
        Py.warning(Py.DeprecationWarning, "isunicode is deprecated.");
        return true;
    }

    final String unicode_encode(PyObject[] args, String[] keywords) {
        return this.str_encode(args, keywords);
    }

    final PyObject unicode_decode(PyObject[] args, String[] keywords) {
        return this.str_decode(args, keywords);
    }

    final PyTuple unicode___getnewargs__() {
        return new PyTuple(new PyUnicode(this.getString()));
    }

    @Override
    public PyObject __format__(PyObject formatSpec) {
        return this.unicode___format__(formatSpec);
    }

    final PyObject unicode___format__(PyObject formatSpec) {
        return this.str___format__(formatSpec);
    }

    final PyObject unicode__formatter_parser() {
        return new MarkupIterator(this);
    }

    final PyObject unicode__formatter_field_name_split() {
        FieldNameIterator iterator = new FieldNameIterator(this);
        return new PyTuple(iterator.pyHead(), iterator);
    }

    final PyObject unicode_format(PyObject[] args, String[] keywords) {
        try {
            return new PyUnicode(this.buildFormattedString(args, keywords, null, null));
        }
        catch (IllegalArgumentException e) {
            throw Py.ValueError(e.getMessage());
        }
    }

    public Iterator<Integer> iterator() {
        return this.newSubsequenceIterator();
    }

    @Override
    public PyComplex __complex__() {
        return new PyString(this.encodeDecimal()).__complex__();
    }

    @Override
    public int atoi(int base) {
        return new PyString(this.encodeDecimal()).atoi(base);
    }

    @Override
    public PyLong atol(int base) {
        return new PyString(this.encodeDecimal()).atol(base);
    }

    @Override
    public double atof() {
        return new PyString(this.encodeDecimal()).atof();
    }

    private String encodeDecimal() {
        if (this.isBasicPlane()) {
            return this.encodeDecimalBasic();
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (Character.isWhitespace(codePoint)) {
                sb.append(' ');
            } else {
                int digit = Character.digit(codePoint, 10);
                if (digit >= 0) {
                    sb.append(digit);
                } else if (0 < codePoint && codePoint < 256) {
                    sb.appendCodePoint(codePoint);
                } else {
                    codecs.encoding_error("strict", "decimal", this.getString(), i, i + 1, "invalid decimal Unicode string");
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private String encodeDecimalBasic() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.getString().length(); ++i) {
            char ch = this.getString().charAt(i);
            if (Character.isWhitespace(ch)) {
                sb.append(' ');
                continue;
            }
            int digit = Character.digit(ch, 10);
            if (digit >= 0) {
                sb.append(digit);
                continue;
            }
            if ('\u0000' < ch && ch < '\u0100') {
                sb.append(ch);
                continue;
            }
            codecs.encoding_error("strict", "decimal", this.getString(), i, i + 1, "invalid decimal Unicode string");
        }
        return sb.toString();
    }

    static {
        PyType.addBuilder(PyUnicode.class, new PyUnicode$PyExposer());
        TYPE = PyType.fromClass(PyUnicode.class);
        BASIC = new IndexTranslator(){

            @Override
            public int suppCount() {
                return 0;
            }

            @Override
            public int codePointIndex(int u) {
                return u;
            }

            @Override
            public int utf16Index(int i) {
                return i;
            }
        };
    }

    private class SepSplitIterator
    extends SplitIterator {
        private final PyUnicode sep;

        SepSplitIterator(PyUnicode sep, int maxsplit) {
            super(maxsplit);
            this.sep = sep;
        }

        public PyUnicode next() {
            StringBuilder buffer = new StringBuilder();
            this.addLookahead(buffer);
            if (this.numSplits == this.maxsplit) {
                while (this.iter.hasNext()) {
                    buffer.appendCodePoint((Integer)this.iter.next());
                }
                return new PyUnicode(buffer);
            }
            boolean inSeparator = true;
            while (this.iter.hasNext()) {
                inSeparator = true;
                Iterator<Integer> sepIter = this.sep.newSubsequenceIterator();
                while (sepIter.hasNext()) {
                    int codepoint = (Integer)this.iter.next();
                    if (codepoint != sepIter.next()) {
                        this.addLookahead(buffer);
                        buffer.appendCodePoint(codepoint);
                        inSeparator = false;
                        break;
                    }
                    this.lookahead.add(codepoint);
                }
                if (!inSeparator) continue;
                this.lookahead.clear();
                break;
            }
            ++this.numSplits;
            this.completeSeparator = inSeparator;
            return new PyUnicode(buffer);
        }
    }

    private class LineSplitIterator
    implements Iterator {
        private final PeekIterator<Integer> iter;
        private final boolean keepends;

        LineSplitIterator(boolean keepends) {
            this.iter = new PeekIterator<Integer>(PyUnicode.this.newSubsequenceIterator());
            this.keepends = keepends;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            StringBuilder buffer = new StringBuilder();
            while (this.iter.hasNext()) {
                int codepoint = this.iter.next();
                if (codepoint == 13 && this.iter.peek() != null && this.iter.peek() == 10) {
                    if (this.keepends) {
                        buffer.appendCodePoint(codepoint);
                        buffer.appendCodePoint(this.iter.next());
                        break;
                    }
                    this.iter.next();
                    break;
                }
                if (codepoint == 10 || codepoint == 13 || Character.getType(codepoint) == 13) {
                    if (!this.keepends) break;
                    buffer.appendCodePoint(codepoint);
                    break;
                }
                buffer.appendCodePoint(codepoint);
            }
            return new PyUnicode(buffer);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ReversedIterator<T>
    implements Iterator {
        private final List<T> reversed = Generic.list();
        private final Iterator<T> iter;

        ReversedIterator(Iterator<T> iter) {
            while (iter.hasNext()) {
                this.reversed.add(iter.next());
            }
            Collections.reverse(this.reversed);
            this.iter = this.reversed.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public T next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class PeekIterator<T>
    implements Iterator {
        private T lookahead = null;
        private final Iterator<T> iter;

        public PeekIterator(Iterator<T> iter) {
            this.iter = iter;
            this.next();
        }

        public T peek() {
            return this.lookahead;
        }

        @Override
        public boolean hasNext() {
            return this.lookahead != null;
        }

        public T next() {
            T peeked = this.lookahead;
            this.lookahead = this.iter.hasNext() ? this.iter.next() : null;
            return peeked;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class WhitespaceSplitIterator
    extends SplitIterator {
        WhitespaceSplitIterator(int maxsplit) {
            super(maxsplit);
        }

        public PyUnicode next() {
            boolean atBeginning;
            StringBuilder buffer = new StringBuilder();
            this.addLookahead(buffer);
            if (this.numSplits == this.maxsplit) {
                while (this.iter.hasNext()) {
                    buffer.appendCodePoint((Integer)this.iter.next());
                }
                return new PyUnicode(buffer);
            }
            boolean inSeparator = false;
            boolean bl = atBeginning = this.numSplits == 0;
            while (this.iter.hasNext()) {
                int codepoint = (Integer)this.iter.next();
                if (Character.isWhitespace(codepoint)) {
                    this.completeSeparator = true;
                    if (!atBeginning) {
                        inSeparator = true;
                    }
                } else if (!inSeparator) {
                    this.completeSeparator = false;
                    buffer.appendCodePoint(codepoint);
                } else {
                    this.completeSeparator = false;
                    this.lookahead.add(codepoint);
                    break;
                }
                atBeginning = false;
            }
            ++this.numSplits;
            return new PyUnicode(buffer);
        }
    }

    private abstract class SplitIterator
    implements Iterator {
        protected final int maxsplit;
        protected final Iterator<Integer> iter;
        protected final LinkedList<Integer> lookahead;
        protected int numSplits;
        protected boolean completeSeparator;

        SplitIterator(int maxsplit) {
            this.iter = PyUnicode.this.newSubsequenceIterator();
            this.lookahead = new LinkedList();
            this.numSplits = 0;
            this.completeSeparator = false;
            this.maxsplit = maxsplit;
        }

        @Override
        public boolean hasNext() {
            return this.lookahead.peek() != null || this.iter.hasNext() && (this.maxsplit == -1 || this.numSplits <= this.maxsplit);
        }

        protected void addLookahead(StringBuilder buffer) {
            Iterator i$ = this.lookahead.iterator();
            while (i$.hasNext()) {
                int codepoint = (Integer)i$.next();
                buffer.appendCodePoint(codepoint);
            }
            this.lookahead.clear();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean getEndsWithSeparator() {
            return this.completeSeparator && !this.hasNext();
        }
    }

    private static class StripIterator
    implements Iterator {
        private final Iterator<Integer> iter;
        private int lookahead = -1;

        public StripIterator(PyUnicode sep, Iterator<Integer> iter) {
            this.iter = iter;
            if (sep != null) {
                Set<Integer> sepSet = Generic.set();
                Iterator<Integer> sepIter = sep.newSubsequenceIterator();
                while (sepIter.hasNext()) {
                    sepSet.add(sepIter.next());
                }
                while (iter.hasNext()) {
                    int codePoint = iter.next();
                    if (sepSet.contains(codePoint)) continue;
                    this.lookahead = codePoint;
                    return;
                }
            } else {
                while (iter.hasNext()) {
                    int codePoint = iter.next();
                    if (Character.isWhitespace(codePoint)) continue;
                    this.lookahead = codePoint;
                    return;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.lookahead != -1;
        }

        public Object next() {
            int old = this.lookahead;
            this.lookahead = this.iter.hasNext() ? this.iter.next() : -1;
            return old;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SteppedIterator<T>
    implements Iterator {
        private final Iterator<T> iter;
        private final int step;
        private T lookahead = null;

        public SteppedIterator(int step, Iterator<T> iter) {
            this.iter = iter;
            this.step = step;
            this.lookahead = this.advance();
        }

        private T advance() {
            if (this.iter.hasNext()) {
                T elem = this.iter.next();
                for (int i = 1; i < this.step && this.iter.hasNext(); ++i) {
                    this.iter.next();
                }
                return elem;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.lookahead != null;
        }

        public T next() {
            T old = this.lookahead;
            if (this.iter.hasNext()) {
                this.lookahead = this.iter.next();
                for (int i = 1; i < this.step && this.iter.hasNext(); ++i) {
                    this.iter.next();
                }
            } else {
                this.lookahead = null;
            }
            return old;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class SubsequenceIteratorImpl
    implements Iterator {
        private int current;
        private int k;
        private int stop;
        private int step;

        SubsequenceIteratorImpl(int start, int stop, int step) {
            this.current = start;
            this.k = PyUnicode.this.translator.utf16Index(this.current);
            this.stop = stop;
            this.step = step;
        }

        SubsequenceIteratorImpl() {
            this(0, pyUnicode.getCodePointCount(), 1);
        }

        @Override
        public boolean hasNext() {
            return this.current < this.stop;
        }

        public Object next() {
            int codePoint = this.nextCodePoint();
            ++this.current;
            for (int j = 1; j < this.step && this.hasNext(); ++j) {
                this.nextCodePoint();
                ++this.current;
            }
            return codePoint;
        }

        private int nextCodePoint() {
            int U;
            int W1 = PyUnicode.this.getString().charAt(this.k);
            if (W1 >= 55296 && W1 < 56320) {
                char W2 = PyUnicode.this.getString().charAt(this.k + 1);
                U = ((W1 & 0x3FF) << 10 | W2 & 0x3FF) + 65536;
                this.k += 2;
            } else {
                U = W1;
                ++this.k;
            }
            return U;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported on PyUnicode objects (immutable)");
        }
    }

    private final class Supplementary
    implements IndexTranslator {
        final int[] count;
        static final int LOG2M = 4;
        static final int M = 16;
        static final int MASK = 15;

        Supplementary(int[] count2) {
            this.count = count2;
        }

        @Override
        public int codePointIndex(int u) {
            int c1;
            int k2 = (u >> 4) + 1;
            int c2 = this.count[k2 - 1];
            int k1 = Math.max(0, u - c2) >> 4;
            int n = c1 = k1 == 0 ? 0 : this.count[k1 - 1];
            while (true) {
                if (c2 == c1) {
                    return u - c1;
                }
                int k = (k1 + k2) / 2;
                if (k == k1) break;
                int c = this.count[k - 1];
                if ((k << 4) + c > u) {
                    k2 = k;
                    c2 = c;
                    continue;
                }
                k1 = k;
                c1 = c;
            }
            int p = (k1 << 4) + c1;
            while (p < u) {
                if (!Character.isHighSurrogate(PyUnicode.this.string.charAt(p++))) continue;
                if (++c1 == c2) break;
                ++p;
            }
            return u - c1;
        }

        @Override
        public int utf16Index(int i) {
            int e;
            int k = i >> 4;
            int d = k == 0 ? 0 : this.count[k - 1];
            if (d == (e = this.count[k])) {
                return i + d;
            }
            for (int q = i & 0xFFFFFFF0; !(q >= i || Character.isHighSurrogate(PyUnicode.this.string.charAt(q + d)) && ++d == e); ++q) {
            }
            return i + d;
        }

        @Override
        public int suppCount() {
            return this.count[this.count.length - 1];
        }
    }

    private static interface IndexTranslator {
        public int suppCount();

        public int codePointIndex(int var1);

        public int utf16Index(int var1);
    }
}

