/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.util.CacheEntry;
import org.python.util.PythonInterpreter;

public class PyServlet
extends HttpServlet {
    private PythonInterpreter interp;
    private Hashtable cache = new Hashtable();
    private String rootPath;

    public void init() {
        Object object;
        this.rootPath = this.getServletContext().getRealPath("/");
        if (!this.rootPath.endsWith(File.separator)) {
            this.rootPath = this.rootPath + File.separator;
        }
        Properties properties = new Properties();
        Properties properties2 = PySystemState.getBaseProperties();
        ServletContext servletContext = this.getServletContext();
        Enumeration enumeration = servletContext.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            properties.put(object, servletContext.getInitParameter((String)object));
        }
        enumeration = this.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            properties.put(object, this.getInitParameter((String)object));
        }
        if (properties.getProperty("python.home") == null && properties2.getProperty("python.home") == null) {
            properties.put("python.home", this.rootPath + "WEB-INF" + File.separator + "lib");
        }
        PythonInterpreter.initialize(properties2, properties, new String[0]);
        this.reset();
        object = Py.getSystemState();
        PySystemState.add_package("javax.servlet");
        PySystemState.add_package("javax.servlet.http");
        PySystemState.add_package("javax.servlet.jsp");
        PySystemState.add_package("javax.servlet.jsp.tagext");
        PySystemState.add_classdir(this.rootPath + "WEB-INF" + File.separator + "classes");
        PySystemState.add_extdir(this.rootPath + "WEB-INF" + File.separator + "lib", true);
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        servletRequest.setAttribute("pyservlet", (Object)this);
        String string = (String)servletRequest.getAttribute("javax.servlet.include.servlet_path");
        if (string == null && ((string = ((HttpServletRequest)servletRequest).getServletPath()) == null || string.length() == 0)) {
            string = ((HttpServletRequest)servletRequest).getPathInfo();
        }
        String string2 = this.getServletContext().getRealPath(string);
        this.interp.set("__file__", string2);
        HttpServlet httpServlet = this.getServlet(string2);
        if (httpServlet == null) {
            throw new ServletException("No python servlet found at:" + string);
        }
        httpServlet.service(servletRequest, servletResponse);
    }

    public void reset() {
        this.destroyCache();
        this.interp = new PythonInterpreter(null, new PySystemState());
        this.cache.clear();
        PySystemState pySystemState = Py.getSystemState();
        pySystemState.path.append(new PyString(this.rootPath));
        String string = this.rootPath + "WEB-INF" + File.separator + "jython";
        pySystemState.path.append(new PyString(string));
    }

    private synchronized HttpServlet getServlet(String string) throws ServletException, IOException {
        CacheEntry cacheEntry = (CacheEntry)this.cache.get(string);
        if (cacheEntry == null) {
            return this.loadServlet(string);
        }
        File file = new File(string);
        if (file.lastModified() > cacheEntry.date) {
            return this.loadServlet(string);
        }
        return cacheEntry.servlet;
    }

    private HttpServlet loadServlet(String string) throws ServletException, IOException {
        Object object;
        HttpServlet httpServlet = null;
        File file = new File(string);
        int n = string.lastIndexOf(File.separator);
        n = n < 0 ? 0 : ++n;
        int n2 = string.lastIndexOf(46);
        if (n2 < 0 || n2 <= n) {
            n2 = string.length();
        }
        String string2 = string.substring(n, n2);
        try {
            this.interp.execfile(string);
            object = this.interp.get(string2);
            if (object == null) {
                throw new ServletException("No callable (class or function) named " + string2 + " in " + string);
            }
            PyObject pyObject = ((PyObject)object).__call__();
            Object object2 = pyObject.__tojava__(HttpServlet.class);
            if (object2 == Py.NoConversion) {
                throw new ServletException("The value from " + string2 + "must extend HttpServlet");
            }
            httpServlet = (HttpServlet)object2;
            httpServlet.init(this.getServletConfig());
        }
        catch (PyException pyException) {
            throw new ServletException("Could not create Jython servlet" + pyException.toString());
        }
        object = new CacheEntry(httpServlet, file.lastModified());
        this.cache.put(string, object);
        return httpServlet;
    }

    public void destroy() {
        this.destroyCache();
    }

    private void destroyCache() {
        Enumeration enumeration = this.cache.elements();
        while (enumeration.hasMoreElements()) {
            CacheEntry cacheEntry = (CacheEntry)enumeration.nextElement();
            cacheEntry.servlet.destroy();
        }
    }
}

