/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import com.google.common.base.CharMatcher;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.python.core.ArgParser;
import org.python.core.BufferProtocol;
import org.python.core.Py;
import org.python.core.Py2kBuffer;
import org.python.core.PyBaseString;
import org.python.core.PyBuffer;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode$PyExposer;
import org.python.core.PyUnicodeDerived;
import org.python.core.StringFormatter;
import org.python.core.Untraversable;
import org.python.core.codecs;
import org.python.core.stringlib.FieldNameIterator;
import org.python.core.stringlib.MarkupIterator;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules._codecs;
import org.python.util.Generic;

@Untraversable
@ExposedType(name="unicode", base=PyBaseString.class, doc="unicode(object='') -> unicode object\nunicode(string[, encoding[, errors]]) -> unicode object\n\nCreate a new Unicode object from the given encoded string.\nencoding defaults to the current default string encoding.\nerrors can be 'strict', 'replace' or 'ignore' and defaults to 'strict'.")
public class PyUnicode
extends PyString
implements Iterable<Integer> {
    private static final boolean DEBUG_NON_BMP_METHODS = false;
    public static final PyType TYPE;
    private final IndexTranslator translator;
    static final IndexTranslator BASIC;
    private static final PyUnicode[] unichars;

    public PyUnicode() {
        this(TYPE, "", true);
    }

    public PyUnicode(String string2) {
        this(TYPE, string2, false);
    }

    public PyUnicode(String string2, boolean isBasic) {
        this(TYPE, string2, isBasic);
    }

    public PyUnicode(PyType subtype, String string2) {
        this(subtype, string2, false);
    }

    public PyUnicode(PyString pystring) {
        this(TYPE, pystring);
    }

    public PyUnicode(PyType subtype, PyString pystring) {
        this(subtype, pystring instanceof PyUnicode ? pystring.string : pystring.decode().toString(), pystring.isBasicPlane());
    }

    public PyUnicode(char c) {
        this(TYPE, String.valueOf(c), true);
    }

    public PyUnicode(int codepoint) {
        this(TYPE, PyUnicode.checkedCPString(codepoint));
    }

    public PyUnicode(int[] codepoints) {
        this(TYPE, PyUnicode.checkedCPString(codepoints));
    }

    PyUnicode(StringBuilder buffer) {
        this(TYPE, buffer.toString());
    }

    private static String checkedCPString(int codePoint) throws PyException {
        if (Character.isValidCodePoint(codePoint)) {
            return new String(Character.toChars(codePoint));
        }
        throw Py.ValueError(String.format("character U+%08x is not in Unicode range", codePoint));
    }

    private static String checkedCPString(int[] codePoints) throws PyException {
        try {
            return new String(codePoints, 0, codePoints.length);
        }
        catch (IllegalArgumentException e) {
            for (int c : codePoints) {
                PyUnicode.checkedCPString(c);
            }
            return "";
        }
    }

    private static StringBuilder fromCodePoints(Iterator<Integer> iter) {
        StringBuilder buffer = new StringBuilder();
        while (iter.hasNext()) {
            buffer.append(PyUnicode.checkedCPString(iter.next()));
        }
        return buffer;
    }

    public PyUnicode(Iterator<Integer> iter) {
        this(PyUnicode.fromCodePoints(iter));
    }

    public PyUnicode(Collection<Integer> ucs4) {
        this(ucs4.iterator());
    }

    private PyUnicode(PyType subtype, String string2, boolean isBasic) {
        super(subtype, "", true);
        this.string = string2;
        this.translator = isBasic ? BASIC : this.chooseIndexTranslator();
    }

    @Override
    public int[] toCodePoints() {
        int n = this.getCodePointCount();
        int[] codePoints = new int[n];
        int i = 0;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            codePoints[i] = iter.next();
            ++i;
        }
        return codePoints;
    }

    @Override
    public synchronized PyBuffer getBuffer(int flags) throws ClassCastException {
        throw new ClassCastException("'unicode' does not support the buffer protocol");
    }

    private static int[] getSupplementaryCounts(String string2) {
        int p;
        int n = string2.length();
        for (p = 0; p < n && !Character.isSurrogate(string2.charAt(p)); ++p) {
        }
        if (p == n) {
            return null;
        }
        int q = p;
        int k = q >> 4;
        int[] count2 = new int[1 + (n >> 4)];
        while (p < n - 1) {
            p += PyUnicode.calcAdvance(string2, p);
            if ((++q & 0xF) != 0) continue;
            count2[k++] = p - q;
            break;
        }
        while (p + 32 < n) {
            for (int i = 0; i < 16; ++i) {
                p += PyUnicode.calcAdvance(string2, p);
            }
            count2[k++] = p - (q += 16);
        }
        while (p < n - 1) {
            p += PyUnicode.calcAdvance(string2, p);
            if ((++q & 0xF) != 0) continue;
            count2[k++] = p - q;
        }
        if (p < n) {
            char c;
            if (Character.isSurrogate(c = string2.charAt(p++))) {
                throw PyUnicode.unpairedSurrogate(p - 1, c);
            }
            ++q;
        }
        int total = p - q;
        while (k < count2.length) {
            count2[k++] = total;
        }
        return count2;
    }

    private static int calcAdvance(String string2, int p) throws PyException {
        char c = string2.charAt(p);
        if (c >= '\ud800') {
            if (c < '\udc00') {
                if (Character.isLowSurrogate(string2.charAt(p + 1))) {
                    return 2;
                }
                throw PyUnicode.unpairedSurrogate(p, c);
            }
            if (c <= '\udfff') {
                throw PyUnicode.unpairedSurrogate(p, c);
            }
        }
        return 1;
    }

    private static PyException unpairedSurrogate(int p, int c) {
        String fmt = "unpaired surrogate %#4x at code unit %d";
        String msg = String.format(fmt, c, p);
        return Py.ValueError(msg);
    }

    private IndexTranslator chooseIndexTranslator() {
        int[] count2 = PyUnicode.getSupplementaryCounts(this.string);
        return count2 == null ? BASIC : new Supplementary(count2);
    }

    @Override
    protected int[] translateIndices(PyObject start, PyObject end) {
        int[] indices = super.translateIndices(start, end);
        indices[0] = this.translator.utf16Index(indices[0]);
        indices[1] = this.translator.utf16Index(indices[1]);
        return indices;
    }

    @Override
    public String substring(int start, int end) {
        return super.substring(this.translator.utf16Index(start), this.translator.utf16Index(end));
    }

    public static PyUnicode fromInterned(String s) {
        int n = s.length();
        if (n > 1) {
            PyUnicode uni = new PyUnicode(TYPE, s, false);
            uni.interned = true;
            return uni;
        }
        if (n == 1) {
            return PyUnicode.from(s.charAt(0));
        }
        return Py.EmptyUnicode;
    }

    public static PyUnicode fromString(String s, boolean isBasic) {
        int n = s.length();
        if (n > 1) {
            PyUnicode uni = new PyUnicode(TYPE, s, isBasic);
            return uni;
        }
        if (n == 1) {
            return PyUnicode.from(s.charAt(0));
        }
        return Py.EmptyUnicode;
    }

    public static PyUnicode from(char c) {
        if (c >= '\u0000' && c < unichars.length) {
            return unichars[c];
        }
        return new PyUnicode(c);
    }

    public static PyUnicode fromCodepoint(int codepoint) {
        if (codepoint >= 0 && codepoint < unichars.length) {
            return unichars[codepoint];
        }
        return new PyUnicode(codepoint);
    }

    @Override
    public boolean isBasicPlane() {
        return this.translator == BASIC;
    }

    public int getCodePointCount() {
        return this.string.length() - this.translator.suppCount();
    }

    public static String checkEncoding(String s) {
        if (s == null || CharMatcher.ascii().matchesAllOf((CharSequence)s)) {
            return s;
        }
        return codecs.PyUnicode_EncodeASCII(s, s.length(), null);
    }

    @ExposedNew
    static final PyObject unicode_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("unicode", args, keywords, new String[]{"string", "encoding", "errors"}, 0);
        PyObject S = ap.getPyObject(0, null);
        String encoding = PyUnicode.checkEncoding(ap.getString(1, null));
        String errors2 = PyUnicode.checkEncoding(ap.getString(2, null));
        if (new_.for_type == subtype) {
            if (S == null) {
                return new PyUnicode("");
            }
            if (S instanceof PyUnicode) {
                return new PyUnicode(((PyUnicode)S).getString());
            }
            if (S instanceof PyString) {
                if (S.getType() != PyString.TYPE && encoding == null && errors2 == null) {
                    return S.__unicode__();
                }
                PyObject decoded = codecs.decode((PyString)S, encoding, errors2);
                if (decoded instanceof PyUnicode) {
                    return new PyUnicode(((PyUnicode)decoded).getString());
                }
                throw Py.TypeError("decoder did not return a unicode object (type=" + decoded.getType().fastGetName() + ")");
            }
            return S.__unicode__();
        }
        if (S == null) {
            return new PyUnicodeDerived(subtype, Py.EmptyString);
        }
        if (S instanceof PyUnicode) {
            return new PyUnicodeDerived(subtype, (PyUnicode)S);
        }
        return new PyUnicodeDerived(subtype, S.__str__());
    }

    @Override
    public PyString createInstance(String string2) {
        return new PyUnicode(string2);
    }

    @Override
    protected PyString createInstance(String string2, boolean isBasic) {
        return PyUnicode.fromString(string2, false);
    }

    @Override
    public PyObject __mod__(PyObject other) {
        return this.unicode___mod__(other);
    }

    final PyObject unicode___mod__(PyObject other) {
        StringFormatter fmt = new StringFormatter(this.getString(), true);
        return fmt.format(other);
    }

    @Override
    public PyUnicode __unicode__() {
        return this;
    }

    @Override
    public PyString __str__() {
        return this.unicode___str__();
    }

    final PyString unicode___str__() {
        return new PyString(this.encode());
    }

    @Override
    public int __len__() {
        return this.unicode___len__();
    }

    final int unicode___len__() {
        return this.getCodePointCount();
    }

    @Override
    public PyString __repr__() {
        return this.unicode___repr__();
    }

    final PyString unicode___repr__() {
        return new PyString("u" + PyUnicode.encode_UnicodeEscape(this.getString(), true));
    }

    final PyObject unicode___getitem__(PyObject index) {
        return this.str___getitem__(index);
    }

    final PyObject unicode___getslice__(PyObject start, PyObject stop, PyObject step) {
        return this.seq___getslice__(start, stop, step);
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        if (this.isBasicPlane()) {
            return super.getslice(start, stop, step);
        }
        if (step > 0 && stop < start) {
            stop = start;
        }
        StringBuilder buffer = new StringBuilder(PyUnicode.sliceLength(start, stop, step));
        Iterator<Integer> iter = this.newSubsequenceIterator(start, stop, step);
        while (iter.hasNext()) {
            buffer.appendCodePoint(iter.next());
        }
        return this.createInstance(buffer.toString());
    }

    final int unicode___cmp__(PyObject other) {
        return this.str___cmp__(other);
    }

    @Override
    public PyObject __eq__(PyObject other) {
        return this.unicode___eq__(other);
    }

    final PyObject unicode___eq__(PyObject other) {
        try {
            String s = PyUnicode.coerceForComparison(other);
            if (s == null) {
                return null;
            }
            return this.getString().equals(s) ? Py.True : Py.False;
        }
        catch (PyException e) {
            return Py.False;
        }
    }

    @Override
    public PyObject __ne__(PyObject other) {
        return this.unicode___ne__(other);
    }

    final PyObject unicode___ne__(PyObject other) {
        try {
            String s = PyUnicode.coerceForComparison(other);
            if (s == null) {
                return null;
            }
            return this.getString().equals(s) ? Py.False : Py.True;
        }
        catch (PyException e) {
            return Py.True;
        }
    }

    @Override
    public PyObject __lt__(PyObject other) {
        return this.unicode___lt__(other);
    }

    final PyObject unicode___lt__(PyObject other) {
        String s = PyUnicode.coerceForComparison(other);
        if (s == null) {
            return null;
        }
        return this.getString().compareTo(s) < 0 ? Py.True : Py.False;
    }

    @Override
    public PyObject __le__(PyObject other) {
        return this.unicode___le__(other);
    }

    final PyObject unicode___le__(PyObject other) {
        String s = PyUnicode.coerceForComparison(other);
        if (s == null) {
            return null;
        }
        return this.getString().compareTo(s) <= 0 ? Py.True : Py.False;
    }

    @Override
    public PyObject __gt__(PyObject other) {
        return this.unicode___gt__(other);
    }

    final PyObject unicode___gt__(PyObject other) {
        String s = PyUnicode.coerceForComparison(other);
        if (s == null) {
            return null;
        }
        return this.getString().compareTo(s) > 0 ? Py.True : Py.False;
    }

    @Override
    public PyObject __ge__(PyObject other) {
        return this.unicode___ge__(other);
    }

    final PyObject unicode___ge__(PyObject other) {
        String s = PyUnicode.coerceForComparison(other);
        if (s == null) {
            return null;
        }
        return this.getString().compareTo(s) >= 0 ? Py.True : Py.False;
    }

    final int unicode___hash__() {
        return this.str___hash__();
    }

    @Override
    protected PyObject pyget(int i) {
        int codepoint = this.getString().codePointAt(this.translator.utf16Index(i));
        return PyUnicode.fromCodepoint(codepoint);
    }

    @Override
    public int getInt(int i) {
        return this.getString().codePointAt(this.translator.utf16Index(i));
    }

    public Iterator<Integer> newSubsequenceIterator() {
        if (this.isBasicPlane()) {
            return new SubsequenceIteratorBasic();
        }
        return new SubsequenceIteratorImpl();
    }

    public Iterator<Integer> newSubsequenceIterator(int start, int stop, int step) {
        if (this.isBasicPlane()) {
            if (step < 0) {
                return new SteppedIterator<Integer>(step * -1, new ReversedIterator<Integer>(new SubsequenceIteratorBasic(stop + 1, start + 1, 1)));
            }
            return new SubsequenceIteratorBasic(start, stop, step);
        }
        if (step < 0) {
            return new SteppedIterator<Integer>(step * -1, new ReversedIterator<Integer>(new SubsequenceIteratorImpl(stop + 1, start + 1, 1)));
        }
        return new SubsequenceIteratorImpl(start, stop, step);
    }

    private static String coerceToStringOrNull(PyObject o) {
        if (o instanceof PyUnicode) {
            return ((PyUnicode)o).getString();
        }
        if (o instanceof PyString) {
            return ((PyString)o).decode().toString();
        }
        if (o instanceof BufferProtocol) {
            try (PyBuffer buf = ((BufferProtocol)((Object)o)).getBuffer(284);){
                PyString s = new PyString(buf);
                String string2 = s.decode().toString();
                return string2;
            }
        }
        return null;
    }

    private static String coerceForComparison(PyObject o) {
        if (o instanceof PyUnicode) {
            return ((PyUnicode)o).getString();
        }
        if (o instanceof PyString) {
            return ((PyString)o).decode().toString();
        }
        if (o instanceof Py2kBuffer) {
            try (PyBuffer buf = ((BufferProtocol)((Object)o)).getBuffer(284);){
                PyString s = new PyString(buf);
                String string2 = s.decode().toString();
                return string2;
            }
        }
        return null;
    }

    private static String coerceToString(PyObject o) {
        String s = PyUnicode.coerceToStringOrNull(o);
        if (s == null) {
            throw PyUnicode.errorCoercingToUnicode(o);
        }
        return s;
    }

    private static String coerceToString(PyObject o, boolean allowNullArgument) {
        if (allowNullArgument && (o == null || o == Py.None)) {
            return null;
        }
        return PyUnicode.coerceToString(o);
    }

    private static PyException errorCoercingToUnicode(PyObject o) {
        return Py.TypeError("coercing to Unicode: need string or buffer, " + (o == null ? Py.None : o).getType().fastGetName() + " found");
    }

    private static PyUnicode coerceToUnicodeOrNull(PyObject o) {
        if (o instanceof PyUnicode) {
            return (PyUnicode)o;
        }
        if (o instanceof PyString) {
            PyObject u = ((PyString)o).decode();
            return u instanceof PyUnicode ? (PyUnicode)u : new PyUnicode(o.toString());
        }
        if (o instanceof BufferProtocol) {
            try (PyBuffer buf = ((BufferProtocol)((Object)o)).getBuffer(284);){
                PyString s = new PyString(buf);
                PyObject u = s.decode();
                PyUnicode pyUnicode = u instanceof PyUnicode ? (PyUnicode)u : new PyUnicode(o.toString());
                return pyUnicode;
            }
        }
        return null;
    }

    private static PyUnicode coerceToUnicode(PyObject o) {
        PyUnicode u = PyUnicode.coerceToUnicodeOrNull(o);
        if (u == null) {
            throw PyUnicode.errorCoercingToUnicode(o);
        }
        return u;
    }

    @Override
    public boolean __contains__(PyObject o) {
        return this.unicode___contains__(o);
    }

    final boolean unicode___contains__(PyObject o) {
        String other = PyUnicode.coerceToString(o);
        return this.getString().indexOf(other) >= 0;
    }

    final PyObject unicode___mul__(PyObject o) {
        return this.str___mul__(o);
    }

    final PyObject unicode___rmul__(PyObject o) {
        return this.str___rmul__(o);
    }

    @Override
    public PyObject __add__(PyObject other) {
        return this.unicode___add__(other);
    }

    final PyObject unicode___add__(PyObject other) {
        String s = PyUnicode.coerceToStringOrNull(other);
        return s == null ? null : new PyUnicode(this.getString().concat(s));
    }

    final PyObject unicode_lower() {
        return new PyUnicode(this.getString().toLowerCase());
    }

    final PyObject unicode_upper() {
        return new PyUnicode(this.getString().toUpperCase());
    }

    final PyObject unicode_title() {
        StringBuilder buffer = new StringBuilder(this.getString().length());
        boolean previous_is_cased = false;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (previous_is_cased) {
                buffer.appendCodePoint(Character.toLowerCase(codePoint));
            } else {
                buffer.appendCodePoint(Character.toTitleCase(codePoint));
            }
            if (Character.isLowerCase(codePoint) || Character.isUpperCase(codePoint) || Character.isTitleCase(codePoint)) {
                previous_is_cased = true;
                continue;
            }
            previous_is_cased = false;
        }
        return new PyUnicode(buffer);
    }

    final PyObject unicode_swapcase() {
        StringBuilder buffer = new StringBuilder(this.getString().length());
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (Character.isUpperCase(codePoint)) {
                buffer.appendCodePoint(Character.toLowerCase(codePoint));
                continue;
            }
            if (Character.isLowerCase(codePoint)) {
                buffer.appendCodePoint(Character.toUpperCase(codePoint));
                continue;
            }
            buffer.appendCodePoint(codePoint);
        }
        return new PyUnicode(buffer);
    }

    private static boolean isPythonSpace(int ch) {
        return Character.isWhitespace(ch) || Character.isSpaceChar(ch) || ch == 133 || ch == 6158;
    }

    private static PyUnicode coerceStripSepToUnicode(PyObject o, String name) {
        if (o == null) {
            return null;
        }
        if (o instanceof PyUnicode) {
            return (PyUnicode)o;
        }
        if (o instanceof PyString) {
            PyObject u = ((PyString)o).decode();
            return u instanceof PyUnicode ? (PyUnicode)u : new PyUnicode(u.toString());
        }
        if (o == Py.None) {
            return null;
        }
        throw Py.TypeError(name + " arg must be None, unicode or str");
    }

    final PyObject unicode_strip(PyObject sepObj) {
        PyUnicode sep = PyUnicode.coerceStripSepToUnicode(sepObj, "strip");
        if (this.isBasicPlane()) {
            if (sep == null) {
                return new PyUnicode(this._strip());
            }
            if (sep.isBasicPlane()) {
                return new PyUnicode(this._strip(sep.getString()));
            }
        }
        return new PyUnicode(new ReversedIterator<Integer>(new StripIterator(sep, new ReversedIterator<Integer>(new StripIterator(sep, this.newSubsequenceIterator())))));
    }

    final PyObject unicode_lstrip(PyObject sepObj) {
        PyUnicode sep = PyUnicode.coerceStripSepToUnicode(sepObj, "lstrip");
        if (this.isBasicPlane()) {
            if (sep == null) {
                return new PyUnicode(this._lstrip());
            }
            if (sep.isBasicPlane()) {
                return new PyUnicode(this._lstrip(sep.getString()));
            }
        }
        return new PyUnicode(new StripIterator(sep, this.newSubsequenceIterator()));
    }

    final PyObject unicode_rstrip(PyObject sepObj) {
        PyUnicode sep = PyUnicode.coerceStripSepToUnicode(sepObj, "rstrip");
        if (this.isBasicPlane()) {
            if (sep == null) {
                return new PyUnicode(this._rstrip());
            }
            if (sep.isBasicPlane()) {
                return new PyUnicode(this._rstrip(sep.getString()));
            }
        }
        return new PyUnicode(new ReversedIterator<Integer>(new StripIterator(sep, new ReversedIterator<Integer>(this.newSubsequenceIterator()))));
    }

    @Override
    protected int _findLeft(int right) {
        String s = this.getString();
        for (int left = 0; left < right; ++left) {
            if (PyUnicode.isPythonSpace(s.charAt(left))) continue;
            return left;
        }
        return right;
    }

    @Override
    protected int _findRight() {
        String s = this.getString();
        int right = s.length();
        while (--right >= 0) {
            if (PyUnicode.isPythonSpace(s.charAt(right))) continue;
            return right;
        }
        return -1;
    }

    @Override
    public PyTuple partition(PyObject sep) {
        return this.unicode_partition(sep);
    }

    final PyTuple unicode_partition(PyObject sep) {
        return this.unicodePartition(PyUnicode.coerceToUnicode(sep));
    }

    private SplitIterator newSplitIterator(PyUnicode sep, int maxsplit) {
        if (sep == null) {
            return new WhitespaceSplitIterator(maxsplit);
        }
        if (sep.getCodePointCount() == 0) {
            throw Py.ValueError("empty separator");
        }
        return new SepSplitIterator(sep, maxsplit);
    }

    @Override
    public PyTuple rpartition(PyObject sep) {
        return this.unicode_rpartition(sep);
    }

    final PyTuple unicode_rpartition(PyObject sep) {
        return this.unicodeRpartition(PyUnicode.coerceToUnicode(sep));
    }

    final PyList unicode_split(PyObject sepObj, int maxsplit) {
        String sep = PyUnicode.coerceToString(sepObj, true);
        if (sep != null) {
            return this._split(sep, maxsplit);
        }
        return this._split(null, maxsplit);
    }

    @Override
    protected PyList splitfields(int maxsplit) {
        PyList list = new PyList();
        String s = this.getString();
        int length = s.length();
        int start = 0;
        int splits = 0;
        if (maxsplit < 0) {
            maxsplit = length;
        }
        while (start < length) {
            int index;
            while (start < length && PyUnicode.isPythonSpace(s.charAt(start))) {
                ++start;
            }
            if (start >= length) break;
            if (splits >= maxsplit) {
                index = length;
            } else {
                for (index = start; index < length && !PyUnicode.isPythonSpace(s.charAt(index)); ++index) {
                }
            }
            list.append(this.fromSubstring(start, index));
            ++splits;
            start = index;
        }
        return list;
    }

    final PyList unicode_rsplit(PyObject sepObj, int maxsplit) {
        String sep = PyUnicode.coerceToString(sepObj, true);
        if (sep != null) {
            return this._rsplit(sep, maxsplit);
        }
        return this._rsplit(null, maxsplit);
    }

    @Override
    protected PyList rsplitfields(int maxsplit) {
        PyList list = new PyList();
        String s = this.getString();
        int length = s.length();
        int end = length - 1;
        int splits = 0;
        if (maxsplit < 0) {
            maxsplit = length;
        }
        while (end >= 0) {
            int index;
            while (end >= 0 && PyUnicode.isPythonSpace(s.charAt(end))) {
                --end;
            }
            if (end < 0) break;
            if (splits >= maxsplit) {
                index = -1;
            } else {
                for (index = end; index >= 0 && !PyUnicode.isPythonSpace(s.charAt(index)); --index) {
                }
            }
            list.append(this.fromSubstring(index + 1, end + 1));
            ++splits;
            end = index;
        }
        list.reverse();
        return list;
    }

    final PyList unicode_splitlines(boolean keepends) {
        return new PyList(new LineSplitIterator(keepends));
    }

    @Override
    protected PyString fromSubstring(int begin, int end) {
        assert (this.isBasicPlane());
        return PyUnicode.fromString(this.getString().substring(begin, end), true);
    }

    final int unicode_index(PyObject subObj, PyObject start, PyObject end) {
        String sub = PyUnicode.coerceToString(subObj);
        return this.checkIndex(this._find(sub, start, end));
    }

    final int unicode_rindex(PyObject subObj, PyObject start, PyObject end) {
        String sub = PyUnicode.coerceToString(subObj);
        return this.checkIndex(this._rfind(sub, start, end));
    }

    final int unicode_count(PyObject subObj, PyObject start, PyObject end) {
        PyUnicode sub = PyUnicode.coerceToUnicode(subObj);
        if (this.isBasicPlane()) {
            return this._count(sub.getString(), start, end);
        }
        int[] indices = super.translateIndices(start, end);
        int count2 = 0;
        Iterator<Integer> mainIter = this.newSubsequenceIterator(indices[0], indices[1], 1);
        while (mainIter.hasNext()) {
            int matched = sub.getCodePointCount();
            Iterator<Integer> subIter = sub.newSubsequenceIterator();
            while (mainIter.hasNext() && subIter.hasNext() && mainIter.next() == subIter.next()) {
                --matched;
            }
            if (matched != 0) continue;
            ++count2;
        }
        return count2;
    }

    final int unicode_find(PyObject subObj, PyObject start, PyObject end) {
        int found = this._find(PyUnicode.coerceToString(subObj), start, end);
        return found < 0 ? -1 : this.translator.codePointIndex(found);
    }

    final int unicode_rfind(PyObject subObj, PyObject start, PyObject end) {
        int found = this._rfind(PyUnicode.coerceToString(subObj), start, end);
        return found < 0 ? -1 : this.translator.codePointIndex(found);
    }

    private static String padding(int n, int pad) {
        StringBuilder buffer = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            buffer.appendCodePoint(pad);
        }
        return buffer.toString();
    }

    private static int parse_fillchar(String function, String fillchar) {
        if (fillchar == null) {
            return 32;
        }
        if (fillchar.codePointCount(0, fillchar.length()) != 1) {
            throw Py.TypeError(function + "() argument 2 must be char, not str");
        }
        return fillchar.codePointAt(0);
    }

    final PyObject unicode_ljust(int width, String padding) {
        int n = width - this.getCodePointCount();
        if (n <= 0) {
            return new PyUnicode(this.getString());
        }
        return new PyUnicode(this.getString() + PyUnicode.padding(n, PyUnicode.parse_fillchar("ljust", padding)));
    }

    final PyObject unicode_rjust(int width, String padding) {
        int n = width - this.getCodePointCount();
        if (n <= 0) {
            return new PyUnicode(this.getString());
        }
        return new PyUnicode(PyUnicode.padding(n, PyUnicode.parse_fillchar("ljust", padding)) + this.getString());
    }

    final PyObject unicode_center(int width, String padding) {
        int n = width - this.getCodePointCount();
        if (n <= 0) {
            return new PyUnicode(this.getString());
        }
        int half = n / 2;
        if (n % 2 > 0 && width % 2 > 0) {
            ++half;
        }
        int pad = PyUnicode.parse_fillchar("center", padding);
        return new PyUnicode(PyUnicode.padding(half, pad) + this.getString() + PyUnicode.padding(n - half, pad));
    }

    final PyObject unicode_zfill(int width) {
        int n = this.getCodePointCount();
        if (n >= width) {
            return new PyUnicode(this.getString());
        }
        if (this.isBasicPlane()) {
            return new PyUnicode(this.str_zfill(width));
        }
        StringBuilder buffer = new StringBuilder(width);
        int nzeros = width - n;
        boolean first = true;
        boolean leadingSign = false;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (first) {
                first = false;
                if (codePoint == 43 || codePoint == 45) {
                    buffer.appendCodePoint(codePoint);
                    leadingSign = true;
                }
                for (int i = 0; i < nzeros; ++i) {
                    buffer.appendCodePoint(48);
                }
                if (leadingSign) continue;
                buffer.appendCodePoint(codePoint);
                continue;
            }
            buffer.appendCodePoint(codePoint);
        }
        if (first) {
            for (int i = 0; i < nzeros; ++i) {
                buffer.appendCodePoint(48);
            }
        }
        return new PyUnicode(buffer);
    }

    final PyObject unicode_expandtabs(int tabsize) {
        return new PyUnicode(this.str_expandtabs(tabsize));
    }

    final PyObject unicode_capitalize() {
        if (this.getString().length() == 0) {
            return this;
        }
        StringBuilder buffer = new StringBuilder(this.getString().length());
        boolean first = true;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (first) {
                buffer.appendCodePoint(Character.toUpperCase(iter.next()));
                first = false;
                continue;
            }
            buffer.appendCodePoint(Character.toLowerCase(iter.next()));
        }
        return new PyUnicode(buffer);
    }

    final PyString unicode_replace(PyObject oldPieceObj, PyObject newPieceObj, int count2) {
        PyUnicode newPiece = PyUnicode.coerceToUnicode(newPieceObj);
        PyUnicode oldPiece = PyUnicode.coerceToUnicode(oldPieceObj);
        if (this.isBasicPlane() && newPiece.isBasicPlane() && oldPiece.isBasicPlane()) {
            return this._replace(oldPiece.getString(), newPiece.getString(), count2);
        }
        StringBuilder buffer = new StringBuilder();
        if (oldPiece.getCodePointCount() == 0) {
            Iterator<Integer> iter = this.newSubsequenceIterator();
            for (int i = 1; (count2 == -1 || i < count2) && iter.hasNext(); ++i) {
                if (i == 1) {
                    buffer.append(newPiece.getString());
                }
                buffer.appendCodePoint(iter.next());
                buffer.append(newPiece.getString());
            }
            while (iter.hasNext()) {
                buffer.appendCodePoint(iter.next());
            }
        } else {
            SplitIterator iter = this.newSplitIterator(oldPiece, count2);
            int numSplits = 0;
            while (iter.hasNext()) {
                buffer.append(((PyUnicode)iter.next()).getString());
                if (iter.hasNext()) {
                    buffer.append(newPiece.getString());
                }
                ++numSplits;
            }
            if (iter.getEndsWithSeparator() && (count2 == -1 || numSplits <= count2)) {
                buffer.append(newPiece.getString());
            }
        }
        return new PyUnicode(buffer);
    }

    @Override
    public PyString join(PyObject seq) {
        return this.unicode_join(seq);
    }

    final PyUnicode unicode_join(PyObject seq) {
        return this.unicodeJoin(seq);
    }

    @Override
    public boolean startswith(PyObject prefix, PyObject start, PyObject end) {
        return this.unicode_startswith(prefix, start, end);
    }

    final boolean unicode_startswith(PyObject prefix, PyObject startObj, PyObject endObj) {
        int[] indices = this.translateIndices(startObj, endObj);
        int start = indices[0];
        int sliceLen = indices[1] - start;
        if (!(prefix instanceof PyTuple)) {
            String s = PyUnicode.coerceToString(prefix);
            return sliceLen >= s.length() && this.getString().startsWith(s, start);
        }
        for (PyObject prefixObj : ((PyTuple)prefix).getArray()) {
            String s = PyUnicode.coerceToString(prefixObj);
            if (sliceLen < s.length() || !this.getString().startsWith(s, start)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean endswith(PyObject suffix, PyObject start, PyObject end) {
        return this.unicode_endswith(suffix, start, end);
    }

    final boolean unicode_endswith(PyObject suffix, PyObject startObj, PyObject endObj) {
        int[] indices = this.translateIndices(startObj, endObj);
        String substr = this.getString().substring(indices[0], indices[1]);
        if (!(suffix instanceof PyTuple)) {
            String s = PyUnicode.coerceToString(suffix);
            return substr.endsWith(s);
        }
        for (PyObject suffixObj : ((PyTuple)suffix).getArray()) {
            String s = PyUnicode.coerceToString(suffixObj);
            if (!substr.endsWith(s)) continue;
            return true;
        }
        return false;
    }

    final PyObject unicode_translate(PyObject table) {
        return _codecs.translateCharmap(this, "ignore", table);
    }

    final boolean unicode_islower() {
        boolean cased = false;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codepoint = iter.next();
            if (Character.isUpperCase(codepoint) || Character.isTitleCase(codepoint)) {
                return false;
            }
            if (cased || !Character.isLowerCase(codepoint)) continue;
            cased = true;
        }
        return cased;
    }

    final boolean unicode_isupper() {
        boolean cased = false;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codepoint = iter.next();
            if (Character.isLowerCase(codepoint) || Character.isTitleCase(codepoint)) {
                return false;
            }
            if (cased || !Character.isUpperCase(codepoint)) continue;
            cased = true;
        }
        return cased;
    }

    final boolean unicode_isalpha() {
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (Character.isLetter(iter.next())) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isalnum() {
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (Character.isLetterOrDigit(codePoint) || Character.getType(codePoint) == 10) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isdecimal() {
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (Character.getType(iter.next()) == 9) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isdigit() {
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (Character.isDigit(iter.next())) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isnumeric() {
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int type = Character.getType(iter.next());
            if (type == 9 || type == 10 || type == 11) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_istitle() {
        if (this.getCodePointCount() == 0) {
            return false;
        }
        boolean cased = false;
        boolean previous_is_cased = false;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (Character.isUpperCase(codePoint) || Character.isTitleCase(codePoint)) {
                if (previous_is_cased) {
                    return false;
                }
                previous_is_cased = true;
                cased = true;
                continue;
            }
            if (Character.isLowerCase(codePoint)) {
                if (!previous_is_cased) {
                    return false;
                }
                previous_is_cased = true;
                cased = true;
                continue;
            }
            previous_is_cased = false;
        }
        return cased;
    }

    final boolean unicode_isspace() {
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (PyUnicode.isPythonSpace(iter.next())) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isunicode() {
        Py.warning(Py.DeprecationWarning, "isunicode is deprecated.");
        return true;
    }

    final String unicode_encode(PyObject[] args, String[] keywords) {
        return this.str_encode(args, keywords);
    }

    final PyObject unicode_decode(PyObject[] args, String[] keywords) {
        return this.str_decode(args, keywords);
    }

    final PyTuple unicode___getnewargs__() {
        return new PyTuple(new PyUnicode(this.getString()));
    }

    @Override
    public PyObject __format__(PyObject formatSpec) {
        return this.unicode___format__(formatSpec);
    }

    final PyObject unicode___format__(PyObject formatSpec) {
        return this.str___format__(formatSpec);
    }

    final PyObject unicode__formatter_parser() {
        return new MarkupIterator(this);
    }

    final PyObject unicode__formatter_field_name_split() {
        FieldNameIterator iterator = new FieldNameIterator(this);
        return new PyTuple(iterator.pyHead(), iterator);
    }

    final PyObject unicode_format(PyObject[] args, String[] keywords) {
        try {
            return new PyUnicode(this.buildFormattedString(args, keywords, null, null));
        }
        catch (IllegalArgumentException e) {
            throw Py.ValueError(e.getMessage());
        }
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.newSubsequenceIterator();
    }

    @Override
    public PyComplex __complex__() {
        return new PyString(this.encodeDecimal()).__complex__();
    }

    @Override
    public int atoi(int base2) {
        return new PyString(this.encodeDecimal()).atoi(base2);
    }

    @Override
    public PyLong atol(int base2) {
        return new PyString(this.encodeDecimal()).atol(base2);
    }

    @Override
    public double atof() {
        return new PyString(this.encodeDecimal()).atof();
    }

    private String encodeDecimal() {
        if (this.isBasicPlane()) {
            return this.encodeDecimalBasic();
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (PyUnicode.isPythonSpace(codePoint)) {
                sb.append(' ');
            } else {
                int digit = Character.digit(codePoint, 10);
                if (digit >= 0) {
                    sb.append(digit);
                } else if (0 < codePoint && codePoint < 256) {
                    sb.appendCodePoint(codePoint);
                } else {
                    codecs.encoding_error("strict", "decimal", this.getString(), i, i + 1, "invalid decimal Unicode string");
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private String encodeDecimalBasic() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.getString().length(); ++i) {
            char ch = this.getString().charAt(i);
            if (PyUnicode.isPythonSpace(ch)) {
                sb.append(' ');
                continue;
            }
            int digit = Character.digit(ch, 10);
            if (digit >= 0) {
                sb.append(digit);
                continue;
            }
            if ('\u0000' < ch && ch < '\u0100') {
                sb.append(ch);
                continue;
            }
            codecs.encoding_error("strict", "decimal", this.getString(), i, i + 1, "invalid decimal Unicode string");
        }
        return sb.toString();
    }

    static {
        PyType.addBuilder(PyUnicode.class, new PyUnicode$PyExposer());
        TYPE = PyType.fromClass(PyUnicode.class);
        BASIC = new IndexTranslator(){

            @Override
            public int suppCount() {
                return 0;
            }

            @Override
            public int codePointIndex(int u) {
                return u;
            }

            @Override
            public int utf16Index(int i) {
                return i;
            }
        };
        unichars = new PyUnicode[128];
        for (char j = '\u0000'; j < '\u0080'; j = (char)(j + '\u0001')) {
            PyUnicode uni = new PyUnicode(TYPE, String.valueOf(j).intern(), true);
            uni.interned = true;
            PyUnicode.unichars[j] = uni;
        }
    }

    private class SepSplitIterator
    extends SplitIterator {
        private final PyUnicode sep;

        SepSplitIterator(PyUnicode sep, int maxsplit) {
            super(maxsplit);
            this.sep = sep;
        }

        @Override
        public PyUnicode next() {
            StringBuilder buffer = new StringBuilder();
            this.addLookahead(buffer);
            if (this.numSplits == this.maxsplit) {
                while (this.iter.hasNext()) {
                    buffer.appendCodePoint((Integer)this.iter.next());
                }
                return new PyUnicode(buffer);
            }
            boolean inSeparator = true;
            while (this.iter.hasNext()) {
                inSeparator = true;
                Iterator<Integer> sepIter = this.sep.newSubsequenceIterator();
                while (sepIter.hasNext()) {
                    int codepoint = (Integer)this.iter.next();
                    if (codepoint != sepIter.next()) {
                        this.addLookahead(buffer);
                        buffer.appendCodePoint(codepoint);
                        inSeparator = false;
                        break;
                    }
                    this.lookahead.add(codepoint);
                }
                if (!inSeparator) continue;
                this.lookahead.clear();
                break;
            }
            ++this.numSplits;
            this.completeSeparator = inSeparator;
            return new PyUnicode(buffer);
        }
    }

    private class LineSplitIterator
    implements Iterator<PyObject> {
        private final PeekIterator<Integer> iter;
        private final boolean keepends;

        LineSplitIterator(boolean keepends) {
            this.iter = new PeekIterator<Integer>(PyUnicode.this.newSubsequenceIterator());
            this.keepends = keepends;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public PyObject next() {
            StringBuilder buffer = new StringBuilder();
            while (this.iter.hasNext()) {
                int codepoint = this.iter.next();
                if (codepoint == 13 && this.iter.peek() != null && this.iter.peek() == 10) {
                    if (this.keepends) {
                        buffer.appendCodePoint(codepoint);
                        buffer.appendCodePoint(this.iter.next());
                        break;
                    }
                    this.iter.next();
                    break;
                }
                if (codepoint == 10 || codepoint == 13 || Character.getType(codepoint) == 13) {
                    if (!this.keepends) break;
                    buffer.appendCodePoint(codepoint);
                    break;
                }
                buffer.appendCodePoint(codepoint);
            }
            return new PyUnicode(buffer);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ReversedIterator<T>
    implements Iterator<T> {
        private final List<T> reversed = Generic.list();
        private final Iterator<T> iter;

        ReversedIterator(Iterator<T> iter) {
            while (iter.hasNext()) {
                this.reversed.add(iter.next());
            }
            Collections.reverse(this.reversed);
            this.iter = this.reversed.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public T next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class PeekIterator<T>
    implements Iterator<T> {
        private T lookahead = null;
        private final Iterator<T> iter;

        public PeekIterator(Iterator<T> iter) {
            this.iter = iter;
            this.next();
        }

        public T peek() {
            return this.lookahead;
        }

        @Override
        public boolean hasNext() {
            return this.lookahead != null;
        }

        @Override
        public T next() {
            T peeked = this.lookahead;
            this.lookahead = this.iter.hasNext() ? this.iter.next() : null;
            return peeked;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class WhitespaceSplitIterator
    extends SplitIterator {
        WhitespaceSplitIterator(int maxsplit) {
            super(maxsplit);
        }

        @Override
        public PyUnicode next() {
            boolean atBeginning;
            StringBuilder buffer = new StringBuilder();
            this.addLookahead(buffer);
            if (this.numSplits == this.maxsplit) {
                while (this.iter.hasNext()) {
                    buffer.appendCodePoint((Integer)this.iter.next());
                }
                return new PyUnicode(buffer);
            }
            boolean inSeparator = false;
            boolean bl = atBeginning = this.numSplits == 0;
            while (this.iter.hasNext()) {
                int codepoint = (Integer)this.iter.next();
                if (PyUnicode.isPythonSpace(codepoint)) {
                    this.completeSeparator = true;
                    if (!atBeginning) {
                        inSeparator = true;
                    }
                } else if (!inSeparator) {
                    this.completeSeparator = false;
                    buffer.appendCodePoint(codepoint);
                } else {
                    this.completeSeparator = false;
                    this.lookahead.add(codepoint);
                    break;
                }
                atBeginning = false;
            }
            ++this.numSplits;
            return new PyUnicode(buffer);
        }
    }

    private abstract class SplitIterator
    implements Iterator<PyUnicode> {
        protected final int maxsplit;
        protected final Iterator<Integer> iter;
        protected final LinkedList<Integer> lookahead;
        protected int numSplits;
        protected boolean completeSeparator;

        SplitIterator(int maxsplit) {
            this.iter = PyUnicode.this.newSubsequenceIterator();
            this.lookahead = new LinkedList();
            this.numSplits = 0;
            this.completeSeparator = false;
            this.maxsplit = maxsplit;
        }

        @Override
        public boolean hasNext() {
            return this.lookahead.peek() != null || this.iter.hasNext() && (this.maxsplit == -1 || this.numSplits <= this.maxsplit);
        }

        protected void addLookahead(StringBuilder buffer) {
            Iterator iterator = this.lookahead.iterator();
            while (iterator.hasNext()) {
                int codepoint = (Integer)iterator.next();
                buffer.appendCodePoint(codepoint);
            }
            this.lookahead.clear();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean getEndsWithSeparator() {
            return this.completeSeparator && !this.hasNext();
        }
    }

    private static class StripIterator
    implements Iterator<Integer> {
        private final Iterator<Integer> iter;
        private int lookahead = -1;

        public StripIterator(PyUnicode sep, Iterator<Integer> iter) {
            this.iter = iter;
            if (sep != null) {
                Set<Integer> sepSet = Generic.set();
                Iterator<Integer> sepIter = sep.newSubsequenceIterator();
                while (sepIter.hasNext()) {
                    sepSet.add(sepIter.next());
                }
                while (iter.hasNext()) {
                    int codePoint = iter.next();
                    if (sepSet.contains(codePoint)) continue;
                    this.lookahead = codePoint;
                    return;
                }
            } else {
                while (iter.hasNext()) {
                    int codePoint = iter.next();
                    if (PyUnicode.isPythonSpace(codePoint)) continue;
                    this.lookahead = codePoint;
                    return;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.lookahead != -1;
        }

        @Override
        public Integer next() {
            int old = this.lookahead;
            this.lookahead = this.iter.hasNext() ? this.iter.next() : -1;
            return old;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SteppedIterator<T>
    implements Iterator<T> {
        private final Iterator<T> iter;
        private final int step;
        private T lookahead = null;

        public SteppedIterator(int step, Iterator<T> iter) {
            this.iter = iter;
            this.step = step;
            this.lookahead = this.advance();
        }

        private T advance() {
            if (this.iter.hasNext()) {
                T elem = this.iter.next();
                for (int i = 1; i < this.step && this.iter.hasNext(); ++i) {
                    this.iter.next();
                }
                return elem;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.lookahead != null;
        }

        @Override
        public T next() {
            T old = this.lookahead;
            if (this.iter.hasNext()) {
                this.lookahead = this.iter.next();
                for (int i = 1; i < this.step && this.iter.hasNext(); ++i) {
                    this.iter.next();
                }
            } else {
                this.lookahead = null;
            }
            return old;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class SubsequenceIteratorBasic
    implements Iterator<Integer> {
        protected int current;
        protected int stop;
        protected int step;

        SubsequenceIteratorBasic(int start, int stop, int step) {
            this.current = start;
            this.stop = stop;
            this.step = step;
        }

        SubsequenceIteratorBasic() {
            this(0, pyUnicode.getCodePointCount(), 1);
        }

        @Override
        public boolean hasNext() {
            return this.current < this.stop;
        }

        @Override
        public Integer next() {
            int codePoint = this.nextCodePoint();
            for (int j = 1; j < this.step && this.hasNext(); ++j) {
                this.nextCodePoint();
            }
            return codePoint;
        }

        protected int nextCodePoint() {
            return PyUnicode.this.getString().charAt(this.current++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported on PyUnicode objects (immutable)");
        }
    }

    private class SubsequenceIteratorImpl
    extends SubsequenceIteratorBasic {
        private int k;

        SubsequenceIteratorImpl(int start, int stop, int step) {
            super(start, stop, step);
            this.k = PyUnicode.this.translator.utf16Index(this.current);
        }

        SubsequenceIteratorImpl() {
            this(0, pyUnicode.getCodePointCount(), 1);
        }

        @Override
        protected int nextCodePoint() {
            int U;
            int W1 = PyUnicode.this.getString().charAt(this.k);
            if (W1 >= 55296 && W1 < 56320) {
                char W2 = PyUnicode.this.getString().charAt(this.k + 1);
                U = ((W1 & 0x3FF) << 10 | W2 & 0x3FF) + 65536;
                this.k += 2;
            } else {
                U = W1;
                ++this.k;
            }
            ++this.current;
            return U;
        }
    }

    private final class Supplementary
    implements IndexTranslator {
        final int[] count;
        static final int LOG2M = 4;
        static final int M = 16;
        static final int MASK = 15;

        Supplementary(int[] count2) {
            this.count = count2;
        }

        @Override
        public int codePointIndex(int u) {
            int c1;
            int k2 = (u >> 4) + 1;
            int c2 = this.count[k2 - 1];
            int k1 = Math.max(0, u - c2) >> 4;
            int n = c1 = k1 == 0 ? 0 : this.count[k1 - 1];
            while (true) {
                if (c2 == c1) {
                    return u - c1;
                }
                int k = (k1 + k2) / 2;
                if (k == k1) break;
                int c = this.count[k - 1];
                if ((k << 4) + c > u) {
                    k2 = k;
                    c2 = c;
                    continue;
                }
                k1 = k;
                c1 = c;
            }
            int p = (k1 << 4) + c1;
            while (p < u) {
                if (!Character.isHighSurrogate(PyUnicode.this.string.charAt(p++))) continue;
                if (++c1 == c2) break;
                ++p;
            }
            return u - c1;
        }

        @Override
        public int utf16Index(int i) {
            int e;
            int k = i >> 4;
            int d = k == 0 ? 0 : this.count[k - 1];
            if (d == (e = this.count[k])) {
                return i + d;
            }
            for (int q = i & 0xFFFFFFF0; !(q >= i || Character.isHighSurrogate(PyUnicode.this.string.charAt(q + d)) && ++d == e); ++q) {
            }
            return i + d;
        }

        @Override
        public int suppCount() {
            return this.count[this.count.length - 1];
        }
    }

    private static interface IndexTranslator
    extends Serializable {
        public int suppCount();

        public int codePointIndex(int var1);

        public int utf16Index(int var1);
    }
}

