/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractInputComponent;

public abstract class Menubar
extends AbstractInputComponent {
    public WebElement findMenuitemByValue(String value) {
        return this.findMenuitemByValue((WebElement)this, value);
    }

    public WebElement findMenuitemByValue(WebElement parentElt, String value) {
        List subElements = parentElt.findElements(By.cssSelector((String)"ul > li.ui-menuitem"));
        return subElements.stream().filter(e -> e.getText().equals(value)).findFirst().orElseThrow(() -> new NoSuchElementException("no menuitem with value '" + value + "'"));
    }

    public WebElement selectMenuitemByValue(String value) {
        Actions actions = new Actions(this.getWebDriver());
        actions.moveToElement(this.getWrappedElement()).build().perform();
        return this.selectMenuitemByValue((WebElement)this, value);
    }

    public WebElement selectMenuitemByValue(WebElement parentElt, String value) {
        WebElement elt = this.findMenuitemByValue(parentElt, value);
        if (PrimeSelenium.hasCssClass((WebElement)elt, (String[])new String[]{"ui-menu-parent"}) && this.isToggleEventHover()) {
            Actions actions = new Actions(this.getWebDriver());
            actions.moveToElement(elt).build().perform();
        } else {
            WebElement eltA = elt.findElement(By.xpath((String)"./a"));
            if (this.isAjaxified(eltA, "onclick")) {
                ((WebElement)PrimeSelenium.guardAjax((Object)elt)).click();
            } else {
                elt.click();
            }
        }
        return elt;
    }

    public boolean isToggleEventHover() {
        return "hover".equals(this.getWidgetConfiguration().getString("toggleEvent"));
    }

    public boolean isToggleEventClick() {
        return "click".equals(this.getWidgetConfiguration().getString("toggleEvent"));
    }
}

