/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component.base;

import java.util.List;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractComponent;
import org.primefaces.selenium.component.model.data.Page;
import org.primefaces.selenium.component.model.data.Paginator;

public abstract class AbstractPageableData
extends AbstractComponent {
    @FindBy(className="ui-paginator")
    private WebElement paginator;

    public abstract List<WebElement> getRowsWebElement();

    public WebElement getPaginatorWebElement() {
        return this.paginator;
    }

    public Paginator getPaginator() {
        return new Paginator(this.getPaginatorWebElement());
    }

    public void selectPage(Page page) {
        Page activePage = this.getPaginator().getActivePage();
        if (activePage == null || activePage.getNumber() != page.getNumber()) {
            ((WebElement)PrimeSelenium.guardAjax((Object)page.getWebElement())).click();
        }
    }

    public void selectPage(int number) {
        for (Page page : this.getPaginator().getPages()) {
            if (page.getNumber() != number) continue;
            this.selectPage(page);
            break;
        }
    }
}

