/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.optimizerplugin.replacer;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import org.apache.maven.plugin.logging.Log;
import org.primefaces.extensions.optimizerplugin.replacer.AbstractTokenReplacingReader;
import org.primefaces.extensions.optimizerplugin.replacer.TokenResolver;

public class FixedMarkerTokenReplacingReader
extends AbstractTokenReplacingReader {
    private final String tokenStartMarker;
    private final String tokenEndMarker;
    private final char[] tokenStartMarkerChars;
    private final char[] tokenEndMarkerChars;
    private final char[] tmpTokenStartMarkerChars;
    private final char[] tmpTokenEndMarkerChars;

    public FixedMarkerTokenReplacingReader(Log log, TokenResolver resolver, Reader source, String tokenStartMarker, String tokenEndMarker) {
        super(log, resolver, source, Math.max(tokenStartMarker.length(), tokenEndMarker.length()));
        this.tokenStartMarker = tokenStartMarker;
        this.tokenEndMarker = tokenEndMarker;
        this.tokenStartMarkerChars = tokenStartMarker.toCharArray();
        this.tokenEndMarkerChars = tokenEndMarker.toCharArray();
        this.tmpTokenStartMarkerChars = new char[tokenStartMarker.length()];
        this.tmpTokenEndMarkerChars = new char[tokenEndMarker.length()];
    }

    @Override
    protected boolean matchTokenStart() throws IOException {
        int countValidChars = this.readChars(this.tmpTokenStartMarkerChars);
        if (Arrays.equals(this.tmpTokenStartMarkerChars, this.tokenStartMarkerChars)) {
            return true;
        }
        if (countValidChars > 0) {
            this.pushbackReader.unread(this.tmpTokenStartMarkerChars, 0, countValidChars);
        }
        return false;
    }

    @Override
    protected boolean findToken() throws IOException {
        boolean endOfSource = false;
        this.tokenBuffer.setLength(0);
        int countValidChars = this.readChars(this.tmpTokenEndMarkerChars);
        while (!Arrays.equals(this.tmpTokenEndMarkerChars, this.tokenEndMarkerChars)) {
            if (countValidChars == -1) {
                endOfSource = true;
                break;
            }
            this.tokenBuffer.append(this.tmpTokenEndMarkerChars[0]);
            this.pushbackReader.unread(this.tmpTokenEndMarkerChars, 0, countValidChars);
            if (this.pushbackReader.read() == -1) {
                endOfSource = true;
                break;
            }
            countValidChars = this.readChars(this.tmpTokenEndMarkerChars);
        }
        if (endOfSource) {
            this.resolvedToken = this.tokenStartMarker + this.tokenBuffer;
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Extracted " + this.tokenStartMarker + this.tokenEndMarker + "-demarcated token to resolve: " + this.tokenBuffer));
        }
        return true;
    }

    @Override
    protected void handleResolverResult() {
        if (this.resolvedToken == null) {
            this.resolvedToken = this.tokenStartMarker + this.tokenBuffer + this.tokenEndMarker;
        }
    }
}

