/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.optimizerplugin.optimizer;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CssCompressor {
    private final StringBuilder srcsb = new StringBuilder();

    public CssCompressor(Reader in) throws IOException {
        int c;
        while ((c = in.read()) != -1) {
            this.srcsb.append((char)c);
        }
    }

    protected String preserveToken(String css, String preservedToken, String tokenRegex, boolean removeWhiteSpace, ArrayList<String> preservedTokens) {
        int maxIndex = css.length() - 1;
        int appendIndex = 0;
        StringBuilder sb = new StringBuilder();
        Pattern p = Pattern.compile(tokenRegex);
        Matcher m = p.matcher(css);
        while (m.find()) {
            int startIndex = m.start() + preservedToken.length() + 1;
            String terminator = m.group(1);
            if (m.start() < appendIndex) continue;
            if (terminator.length() == 0) {
                terminator = ")";
            }
            boolean foundTerminator = false;
            int endIndex = m.end() - 1;
            while (!foundTerminator && endIndex + 1 <= maxIndex && (endIndex = css.indexOf(terminator, endIndex + 1)) > 0) {
                if (css.charAt(endIndex - 1) == '\\') continue;
                foundTerminator = true;
                if (")".equals(terminator)) continue;
                endIndex = css.indexOf(")", endIndex);
            }
            sb.append(css, appendIndex, m.start());
            if (foundTerminator) {
                String token = css.substring(startIndex, endIndex);
                if (removeWhiteSpace) {
                    token = token.replaceAll("\\s+", "");
                }
                preservedTokens.add(token);
                String preserver = preservedToken + "(___YUICSSMIN_PRESERVED_TOKEN_" + (preservedTokens.size() - 1) + "___)";
                sb.append(preserver);
                appendIndex = endIndex + 1;
                continue;
            }
            sb.append(css, m.start(), m.end());
            appendIndex = m.end();
        }
        sb.append(css.substring(appendIndex));
        return sb.toString();
    }

    public void compress(Writer out, int linebreakpos) throws IOException {
        String oldCss;
        String s;
        int i;
        int max;
        String token;
        String css = this.srcsb.toString();
        int startIndex = 0;
        ArrayList<String> preservedTokens = new ArrayList<String>(0);
        ArrayList<String> comments = new ArrayList<String>(0);
        int totallen = css.length();
        StringBuilder sb = new StringBuilder(css);
        while ((startIndex = sb.indexOf("/*", startIndex)) >= 0) {
            int endIndex = sb.indexOf("*/", startIndex + 2);
            if (endIndex < 0) {
                endIndex = totallen;
            }
            token = sb.substring(startIndex + 2, endIndex);
            comments.add(token);
            sb.replace(startIndex + 2, endIndex, "___YUICSSMIN_PRESERVE_CANDIDATE_COMMENT_" + (comments.size() - 1) + "___");
            startIndex += 2;
        }
        css = sb.toString();
        css = this.preserveToken(css, "url", "(?i)url\\(\\s*([\"']?)data\\:\\s*image/svg\\+xml", false, preservedTokens);
        css = this.preserveToken(css, "url", "(?i)url\\(\\s*([\"']?)data\\:\\s*(?!(image/svg\\+xml))", true, preservedTokens);
        css = this.preserveToken(css, "calc", "(?i)calc\\(\\s*([\"']?)", false, preservedTokens);
        css = this.preserveToken(css, "progid:DXImageTransform.Microsoft.Matrix", "(?i)progid:DXImageTransform.Microsoft.Matrix\\s*([\"']?)", false, preservedTokens);
        sb = new StringBuilder();
        Pattern p = Pattern.compile("\"([^\"\r\n\f\\\\]|\\\\[^0-9a-fA-F]|\\\\[0-9a-fA-F]{1,6}(?>\r\n|[ \t\r\n\f])?)*+\"|'([^'\r\n\f\\\\]|\\\\[^0-9a-fA-F]|\\\\[0-9a-fA-F]{1,6}(?>\r\n|[ \t\r\n\f])?)*+'");
        Matcher m = p.matcher(css);
        while (m.find()) {
            token = m.group();
            char quote = token.charAt(0);
            if ((token = token.substring(1, token.length() - 1)).contains("___YUICSSMIN_PRESERVE_CANDIDATE_COMMENT_")) {
                max = comments.size();
                for (i = 0; i < max; ++i) {
                    token = token.replace("___YUICSSMIN_PRESERVE_CANDIDATE_COMMENT_" + i + "___", (CharSequence)comments.get(i));
                }
            }
            token = token.replaceAll("(?i)progid:DXImageTransform.Microsoft.Alpha\\(Opacity=", "alpha(opacity=");
            preservedTokens.add(token);
            String preserver = quote + "___YUICSSMIN_PRESERVED_TOKEN_" + (preservedTokens.size() - 1) + "___" + quote;
            m.appendReplacement(sb, preserver);
        }
        m.appendTail(sb);
        css = sb.toString();
        max = comments.size();
        for (i = 0; i < max; ++i) {
            token = (String)comments.get(i);
            String placeholder = "___YUICSSMIN_PRESERVE_CANDIDATE_COMMENT_" + i + "___";
            if (token.startsWith("!")) {
                preservedTokens.add(token);
                css = css.replace(placeholder, "___YUICSSMIN_PRESERVED_TOKEN_" + (preservedTokens.size() - 1) + "___");
                continue;
            }
            if (token.endsWith("\\")) {
                preservedTokens.add("\\");
                css = css.replace(placeholder, "___YUICSSMIN_PRESERVED_TOKEN_" + (preservedTokens.size() - 1) + "___");
                preservedTokens.add("");
                css = css.replace("___YUICSSMIN_PRESERVE_CANDIDATE_COMMENT_" + ++i + "___", "___YUICSSMIN_PRESERVED_TOKEN_" + (preservedTokens.size() - 1) + "___");
                continue;
            }
            if (token.length() == 0 && (startIndex = css.indexOf(placeholder)) > 2 && css.charAt(startIndex - 3) == '>') {
                preservedTokens.add("");
                css = css.replace(placeholder, "___YUICSSMIN_PRESERVED_TOKEN_" + (preservedTokens.size() - 1) + "___");
            }
            css = css.replace("/*" + placeholder + "*/", "");
        }
        String backslash9 = "\\9";
        while (css.contains("\\9")) {
            preservedTokens.add("\\9");
            css = css.replace("\\9", "___YUICSSMIN_PRESERVED_TOKEN_" + (preservedTokens.size() - 1) + "___");
        }
        css = css.replaceAll("\\s+", " ");
        sb = new StringBuilder();
        p = Pattern.compile("(^|})((^|([^{:])+):)+([^{]*\\{)");
        m = p.matcher(css);
        while (m.find()) {
            s = m.group();
            s = s.replaceAll(":", "___YUICSSMIN_PSEUDOCLASSCOLON___");
            s = s.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$");
            m.appendReplacement(sb, s);
        }
        m.appendTail(sb);
        css = sb.toString();
        css = css.replaceAll("\\s+([!{};:>+()\\],])", "$1");
        css = css.replaceAll("!important", " !important");
        css = css.replaceAll("___YUICSSMIN_PSEUDOCLASSCOLON___", ":");
        sb = new StringBuilder();
        p = Pattern.compile("(?i):first-(line|letter)([{,])");
        m = p.matcher(css);
        while (m.find()) {
            m.appendReplacement(sb, ":first-" + m.group(1).toLowerCase() + " " + m.group(2));
        }
        m.appendTail(sb);
        css = sb.toString();
        css = css.replaceAll("\\*/ ", "*/");
        sb = new StringBuilder();
        p = Pattern.compile("(?i)^(.*)(@charset)( \"[^\"]*\";)");
        m = p.matcher(css);
        while (m.find()) {
            s = m.group(1).replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$");
            m.appendReplacement(sb, m.group(2).toLowerCase() + m.group(3) + s);
        }
        m.appendTail(sb);
        css = sb.toString();
        sb = new StringBuilder();
        p = Pattern.compile("(?i)^((\\s*)(@charset)( [^;]+;\\s*))+");
        m = p.matcher(css);
        while (m.find()) {
            m.appendReplacement(sb, m.group(2) + m.group(3).toLowerCase() + m.group(4));
        }
        m.appendTail(sb);
        css = sb.toString();
        sb = new StringBuilder();
        p = Pattern.compile("(?i)@(font-face|import|(?:-(?:atsc|khtml|moz|ms|o|wap|webkit)-)?keyframe|media|page|namespace)");
        m = p.matcher(css);
        while (m.find()) {
            m.appendReplacement(sb, "@" + m.group(1).toLowerCase());
        }
        m.appendTail(sb);
        css = sb.toString();
        sb = new StringBuilder();
        p = Pattern.compile("(?i):(active|after|before|checked|disabled|empty|enabled|first-(?:child|of-type)|focus|hover|last-(?:child|of-type)|link|only-(?:child|of-type)|root|:selection|target|visited)");
        m = p.matcher(css);
        while (m.find()) {
            m.appendReplacement(sb, ":" + m.group(1).toLowerCase());
        }
        m.appendTail(sb);
        css = CssCompressor.normalizeSpace(sb.toString());
        sb = new StringBuilder();
        p = Pattern.compile("(?i):(lang|not|nth-child|nth-last-child|nth-last-of-type|nth-of-type|(?:-(?:moz|webkit)-)?any)\\(");
        m = p.matcher(css);
        while (m.find()) {
            m.appendReplacement(sb, ":" + m.group(1).toLowerCase() + "(");
        }
        m.appendTail(sb);
        css = CssCompressor.normalizeSpace(sb.toString());
        sb = new StringBuilder();
        p = Pattern.compile("(?i)([:,( ]\\s*)(attr|color-stop|from|rgba|to|url|(?:-(?:atsc|khtml|moz|ms|o|wap|webkit)-)?(?:calc|max|min|(?:repeating-)?(?:linear|radial)-gradient)|-webkit-gradient)");
        m = p.matcher(css);
        while (m.find()) {
            m.appendReplacement(sb, m.group(1) + m.group(2).toLowerCase());
        }
        m.appendTail(sb);
        css = sb.toString();
        css = css.replaceAll("(?i)\\band\\(", "and (");
        css = css.replaceAll("(?i)\\bor\\(", "or (");
        css = css.replaceAll("([!{}:;>+(\\[,])\\s+", "$1");
        css = css.replaceAll(";+}", "}");
        p = Pattern.compile("(?i)(^|: ?)((?:[0-9a-z-.]+ )*?)?(?:0?\\.)?0(?:px|em|in|cm|mm|pc|pt|ex|deg|g?rad|k?hz)");
        do {
            oldCss = css;
        } while (!(css = (m = p.matcher(css)).replaceAll("$1$20")).equals(oldCss));
        p = Pattern.compile("(?i)(: ?)((?:[0-9a-z-.]+ )*?)?(?:0?\\.)?0%");
        do {
            oldCss = css;
        } while (!(css = (m = p.matcher(css)).replaceAll("$1$20")).equals(oldCss));
        p = Pattern.compile("(?i)(^|,|\\{) ?100% ?\\{");
        do {
            oldCss = css;
        } while (!(css = (m = p.matcher(css)).replaceAll("$1to{")).equals(oldCss));
        p = Pattern.compile("(?i)(?<!hsla?|rgba?|linear-gradient?)\\( ?((?:[#0-9a-z-.]+[ ,])*)?(?:0?\\.)?0(?:px|em|%|in|cm|mm|pc|pt|ex|deg|g?rad|m?s|k?hz)");
        do {
            oldCss = css;
        } while (!(css = (m = p.matcher(css)).replaceAll("($10")).equals(oldCss));
        css = css.replaceAll("([0-9])\\.0(px|em|%|in|cm|mm|pc|pt|ex|deg|m?s|g?rad|k?hz| |;)", "$1$2");
        css = css.replaceAll(":0 0 0 0([;}])", ":0$1");
        css = css.replaceAll(":0 0 0([;}])", ":0$1");
        css = css.replaceAll("(?<!flex):0 0([;}])", ":0$1");
        sb = new StringBuilder();
        p = Pattern.compile("(?i)(background-position|webkit-mask-position|transform-origin|webkit-transform-origin|moz-transform-origin|o-transform-origin|ms-transform-origin|box-shadow|text-shadow):0([;}])");
        m = p.matcher(css);
        while (m.find()) {
            m.appendReplacement(sb, m.group(1).toLowerCase() + ":0 0" + m.group(2));
        }
        m.appendTail(sb);
        css = sb.toString();
        css = css.replaceAll("(:|\\s)0+\\.(\\d+)", "$1.$2");
        p = Pattern.compile("rgb\\s*\\(\\s*([0-9,\\s]+)\\s*\\)");
        m = p.matcher(css);
        sb = new StringBuilder();
        while (m.find()) {
            String[] rgbcolors = m.group(1).split(",");
            StringBuilder hexcolor = new StringBuilder("#");
            for (i = 0; i < rgbcolors.length; ++i) {
                int val = Integer.parseInt(rgbcolors[i]);
                if (val < 16) {
                    hexcolor.append("0");
                }
                if (val > 255) {
                    val = 255;
                }
                hexcolor.append(Integer.toHexString(val));
            }
            m.appendReplacement(sb, hexcolor.toString());
        }
        m.appendTail(sb);
        css = sb.toString();
        p = Pattern.compile("(=\\s*?[\"']?)?#([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])(:?}|[^0-9a-fA-F{][^{]*?})");
        m = p.matcher(css);
        sb = new StringBuilder();
        int index = 0;
        while (m.find(index)) {
            boolean isFilter;
            sb.append(css, index, m.start());
            boolean bl = isFilter = m.group(1) != null && !"".equals(m.group(1));
            if (isFilter) {
                sb.append(m.group(1)).append("#").append(m.group(2)).append(m.group(3)).append(m.group(4)).append(m.group(5)).append(m.group(6)).append(m.group(7));
            } else if (m.group(2).equalsIgnoreCase(m.group(3)) && m.group(4).equalsIgnoreCase(m.group(5)) && m.group(6).equalsIgnoreCase(m.group(7))) {
                sb.append("#").append((m.group(3) + m.group(5) + m.group(7)).toLowerCase());
            } else {
                sb.append("#").append((m.group(2) + m.group(3) + m.group(4) + m.group(5) + m.group(6) + m.group(7)).toLowerCase());
            }
            index = m.end(7);
        }
        sb.append(css.substring(index));
        css = sb.toString();
        css = css.replaceAll("(:|\\s)(#f00)([;}])", "$1red$3");
        css = css.replaceAll("(:|\\s)(#000080)([;}])", "$1navy$3");
        css = css.replaceAll("(:|\\s)(#808080)([;}])", "$1gray$3");
        css = css.replaceAll("(:|\\s)(#808000)([;}])", "$1olive$3");
        css = css.replaceAll("(:|\\s)(#800080)([;}])", "$1purple$3");
        css = css.replaceAll("(:|\\s)(#c0c0c0)([;}])", "$1silver$3");
        css = css.replaceAll("(:|\\s)(#008080)([;}])", "$1teal$3");
        css = css.replaceAll("(:|\\s)(#ffa500)([;}])", "$1orange$3");
        css = css.replaceAll("(:|\\s)(#800000)([;}])", "$1maroon$3");
        sb = new StringBuilder();
        p = Pattern.compile("(?i)(border|border-top|border-right|border-bottom|border-left|outline|background):none([;}])");
        m = p.matcher(css);
        while (m.find()) {
            m.appendReplacement(sb, m.group(1).toLowerCase() + ":0" + m.group(2));
        }
        m.appendTail(sb);
        css = sb.toString();
        css = css.replaceAll("(?i)progid:DXImageTransform.Microsoft.Alpha\\(Opacity=", "alpha(opacity=");
        css = css.replaceAll("\\(([\\-A-Za-z]+):([0-9]+)/([0-9]+)\\)", "($1:$2___YUI_QUERY_FRACTION___$3)");
        css = css.replaceAll("[^}{/;]+\\{}", "");
        css = css.replaceAll("___YUI_QUERY_FRACTION___", "/");
        if (linebreakpos >= 0) {
            i = 0;
            int linestartpos = 0;
            sb = new StringBuilder(css);
            while (i < sb.length()) {
                char c;
                if ((c = sb.charAt(i++)) != '}' || i - linestartpos <= linebreakpos) continue;
                sb.insert(i, '\n');
                linestartpos = i;
            }
            css = sb.toString();
        }
        css = css.replaceAll(";;+", ";");
        max = preservedTokens.size();
        for (i = 0; i < max; ++i) {
            css = css.replace("___YUICSSMIN_PRESERVED_TOKEN_" + i + "___", preservedTokens.get(i));
        }
        sb = new StringBuilder();
        p = Pattern.compile("calc\\([^;}]*\\)");
        m = p.matcher(css);
        while (m.find()) {
            String s2 = m.group();
            s2 = s2.replaceAll("\\s+", "");
            s2 = s2.replaceAll("(?<=[-|%)pxemrvhw\\d])\\+", " + ");
            s2 = s2.replaceAll("(?<=[-|%)pxemrvhw\\d])-", " - ");
            s2 = s2.replaceAll("(?<=[-|%)pxemrvhw\\d])\\*", " * ");
            s2 = s2.replaceAll("(?<=[-|%)pxemrvhw\\d])/", " / ");
            s2 = s2.replaceAll("(var\\(-\\s-\\s)", "var(--");
            m.appendReplacement(sb, s2);
        }
        m.appendTail(sb);
        css = sb.toString();
        css = css.trim();
        out.write(css);
    }

    public static String normalizeSpace(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        int size = str.length();
        char[] newChars = new char[size];
        int count = 0;
        int whitespacesCount = 0;
        boolean startWhitespaces = true;
        for (int i = 0; i < size; ++i) {
            char actualChar = str.charAt(i);
            boolean isWhitespace = Character.isWhitespace(actualChar);
            if (isWhitespace) {
                if (whitespacesCount == 0 && !startWhitespaces) {
                    newChars[count++] = 32;
                }
                ++whitespacesCount;
                continue;
            }
            startWhitespaces = false;
            newChars[count++] = actualChar == '\u00a0' ? 32 : (int)actualChar;
            whitespacesCount = 0;
        }
        if (startWhitespaces) {
            return "";
        }
        return new String(newChars, 0, count - (whitespacesCount > 0 ? 1 : 0)).trim();
    }
}

