/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.optimizerplugin;

import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.WarningLevel;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.primefaces.extensions.optimizerplugin.model.Aggregation;
import org.primefaces.extensions.optimizerplugin.model.ResourcesSet;
import org.primefaces.extensions.optimizerplugin.model.SourceMap;
import org.primefaces.extensions.optimizerplugin.optimizer.ClosureCompilerOptimizer;
import org.primefaces.extensions.optimizerplugin.optimizer.YuiCompressorOptimizer;
import org.primefaces.extensions.optimizerplugin.replacer.DataUriTokenResolver;
import org.primefaces.extensions.optimizerplugin.util.ResourcesScanner;
import org.primefaces.extensions.optimizerplugin.util.ResourcesSetCssAdapter;
import org.primefaces.extensions.optimizerplugin.util.ResourcesSetJsAdapter;

public class ResourcesOptimizerMojo
extends AbstractMojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*.css", "**/*.js"};
    private static final String[] DEFAULT_EXCLUDES = new String[0];
    private File inputDir;
    private String imagesDir;
    private String compilationLevel;
    private String warningLevel;
    private String encoding;
    private boolean failOnWarning = false;
    private String suffix;
    private boolean useDataUri = false;
    private String[] includes;
    private String[] excludes;
    private Aggregation[] aggregations;
    private SourceMap sourceMap;
    private String smapOutputDir;
    private String languageIn;
    private String languageOut;
    private List<ResourcesSet> resourcesSets;
    private DataUriTokenResolver dataUriTokenResolver;
    private long originalFilesSize = 0L;
    private long optimizedFilesSize = 0L;
    boolean resFound = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        block17: {
            try {
                if (this.resourcesSets == null || this.resourcesSets.isEmpty()) {
                    String[] incls = this.includes != null && this.includes.length > 0 ? this.includes : DEFAULT_INCLUDES;
                    String[] excls = this.excludes != null && this.excludes.length > 0 ? this.excludes : DEFAULT_EXCLUDES;
                    Aggregation[] aggrs = this.aggregations == null || this.aggregations.length < 1 ? new Aggregation[]{null} : this.aggregations;
                    for (Aggregation aggr : aggrs) {
                        aggr = this.checkAggregation(aggr) ? null : aggr;
                        File dir = aggr != null && aggr.getInputDir() != null ? aggr.getInputDir() : this.inputDir;
                        ResourcesScanner scanner = new ResourcesScanner();
                        scanner.scan(dir, incls, excls);
                        if (aggr != null && aggr.getOutputFile() == null) {
                            File[] files = dir.listFiles();
                            if (files == null) continue;
                            for (File file : files) {
                                Set<File> subDirJsFiles;
                                if (!file.isDirectory()) continue;
                                ResourcesScanner subDirScanner = new ResourcesScanner();
                                subDirScanner.scan(file, DEFAULT_INCLUDES, DEFAULT_EXCLUDES);
                                Set<File> subDirCssFiles = this.filterSubDirFiles(scanner.getCssFiles(), subDirScanner.getCssFiles());
                                if (!subDirCssFiles.isEmpty()) {
                                    DataUriTokenResolver dataUriTokenResolver = this.useDataUri ? this.getDataUriTokenResolver() : null;
                                    this.processCssFiles(file, subDirCssFiles, dataUriTokenResolver, this.getSubDirAggregation(file, aggr, "css"), null);
                                }
                                if ((subDirJsFiles = this.filterSubDirFiles(scanner.getJsFiles(), subDirScanner.getJsFiles())).isEmpty()) continue;
                                this.processJsFiles(file, subDirJsFiles, this.getSubDirAggregation(file, aggr, "js"), this.getCompilationLevel(this.compilationLevel), this.getWarningLevel(this.warningLevel), this.resolveSourceMap(null), null, this.getLanguageIn(this.languageIn), this.getLanguageOut(this.languageOut));
                            }
                            continue;
                        }
                        if (!scanner.getCssFiles().isEmpty()) {
                            DataUriTokenResolver dataUriTokenResolver = this.useDataUri ? this.getDataUriTokenResolver() : null;
                            this.processCssFiles(dir, scanner.getCssFiles(), dataUriTokenResolver, aggr, this.suffix);
                        }
                        if (scanner.getJsFiles().isEmpty()) continue;
                        this.processJsFiles(dir, scanner.getJsFiles(), aggr, this.getCompilationLevel(this.compilationLevel), this.getWarningLevel(this.warningLevel), this.resolveSourceMap(null), this.suffix, this.getLanguageIn(this.languageIn), this.getLanguageOut(this.languageOut));
                    }
                    break block17;
                }
                for (ResourcesSet rs : this.resourcesSets) {
                    String[] incls = rs.getIncludes() != null && rs.getIncludes().length > 0 ? rs.getIncludes() : (this.includes != null && this.includes.length > 0 ? this.includes : DEFAULT_INCLUDES);
                    String[] excls = rs.getExcludes() != null && rs.getExcludes().length > 0 ? rs.getExcludes() : (this.excludes != null && this.excludes.length > 0 ? this.excludes : DEFAULT_EXCLUDES);
                    Aggregation[] aggrs = rs.getAggregations() == null || rs.getAggregations().length < 1 ? (this.aggregations == null || this.aggregations.length < 1 ? new Aggregation[]{null} : this.aggregations) : rs.getAggregations();
                    for (Aggregation aggr : aggrs) {
                        File dir;
                        aggr = this.checkAggregation(aggr) ? null : aggr;
                        File file = dir = aggr != null && aggr.getInputDir() != null ? aggr.getInputDir() : rs.getInputDir();
                        if (dir == null) {
                            dir = this.inputDir;
                        }
                        ResourcesScanner scanner = new ResourcesScanner();
                        scanner.scan(dir, incls, excls);
                        if (aggr != null && aggr.getOutputFile() == null) {
                            File[] files = dir.listFiles();
                            if (files == null) continue;
                            for (File file2 : files) {
                                Set<File> subDirJsFiles;
                                if (!file2.isDirectory()) continue;
                                ResourcesScanner subDirScanner = new ResourcesScanner();
                                subDirScanner.scan(file2, DEFAULT_INCLUDES, DEFAULT_EXCLUDES);
                                Set<File> subDirCssFiles = this.filterSubDirFiles(scanner.getCssFiles(), subDirScanner.getCssFiles());
                                if (!subDirCssFiles.isEmpty()) {
                                    DataUriTokenResolver dataUriTokenResolver = this.useDataUri || rs.isUseDataUri() ? this.getDataUriTokenResolver() : null;
                                    this.processCssFiles(file2, subDirCssFiles, dataUriTokenResolver, this.getSubDirAggregation(file2, aggr, "css"), null);
                                }
                                if ((subDirJsFiles = this.filterSubDirFiles(scanner.getJsFiles(), subDirScanner.getJsFiles())).isEmpty()) continue;
                                this.processJsFiles(file2, subDirJsFiles, this.getSubDirAggregation(file2, aggr, "js"), this.resolveCompilationLevel(rs), this.resolveWarningLevel(rs), this.resolveSourceMap(rs), null, this.resolveLanguageIn(rs), this.resolveLanguageOut(rs));
                            }
                            continue;
                        }
                        if (!scanner.getCssFiles().isEmpty()) {
                            DataUriTokenResolver dataUriTokenResolver = this.useDataUri || rs.isUseDataUri() ? this.getDataUriTokenResolver() : null;
                            this.processCssFiles(dir, scanner.getCssFiles(), dataUriTokenResolver, aggr, this.suffix);
                        }
                        if (scanner.getJsFiles().isEmpty()) continue;
                        this.processJsFiles(dir, scanner.getJsFiles(), aggr, this.resolveCompilationLevel(rs), this.resolveWarningLevel(rs), this.resolveSourceMap(rs), this.suffix, this.resolveLanguageIn(rs), this.resolveLanguageOut(rs));
                    }
                }
            }
            catch (MojoExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error while executing the mojo " + ((Object)((Object)this)).getClass(), e);
            }
        }
        if (!this.resFound) {
            this.getLog().info((CharSequence)"No resources found for optimization.");
            return;
        }
        this.outputStatistic();
    }

    private void processCssFiles(File inputDir, Set<File> cssFiles, DataUriTokenResolver dataUriTokenResolver, Aggregation aggr, String suffix) throws MojoExecutionException {
        this.resFound = true;
        ResourcesSetCssAdapter rsa = new ResourcesSetCssAdapter(inputDir, cssFiles, dataUriTokenResolver, aggr, this.encoding, this.failOnWarning, suffix);
        YuiCompressorOptimizer yuiOptimizer = new YuiCompressorOptimizer();
        yuiOptimizer.optimize(rsa, this.getLog());
        this.originalFilesSize += yuiOptimizer.getTotalOriginalSize();
        this.optimizedFilesSize += yuiOptimizer.getTotalOptimizedSize();
    }

    private void processJsFiles(File inputDir, Set<File> jsFiles, Aggregation aggr, CompilationLevel compilationLevel, WarningLevel warningLevel, SourceMap sourceMap, String suffix, CompilerOptions.LanguageMode languageIn, CompilerOptions.LanguageMode languageOut) throws MojoExecutionException {
        this.resFound = true;
        ResourcesSetJsAdapter rsa = new ResourcesSetJsAdapter(inputDir, jsFiles, aggr, compilationLevel, warningLevel, sourceMap, this.encoding, this.failOnWarning, suffix, languageIn, languageOut);
        ClosureCompilerOptimizer closureOptimizer = new ClosureCompilerOptimizer();
        closureOptimizer.optimize(rsa, this.getLog());
        this.originalFilesSize += closureOptimizer.getTotalOriginalSize();
        this.optimizedFilesSize += closureOptimizer.getTotalOptimizedSize();
    }

    private boolean checkAggregation(Aggregation aggregation) throws MojoExecutionException {
        if (aggregation == null) {
            return true;
        }
        if (aggregation.isSubDirMode() && aggregation.getOutputFile() != null) {
            String errMsg = "At least one aggregation tag is ambiguous because both 'subDirMode' and 'outputFile' were set";
            if (this.failOnWarning) {
                throw new MojoExecutionException("At least one aggregation tag is ambiguous because both 'subDirMode' and 'outputFile' were set");
            }
            this.getLog().warn((CharSequence)"At least one aggregation tag is ambiguous because both 'subDirMode' and 'outputFile' were set");
            this.getLog().warn((CharSequence)"Using 'outputFile' as aggregation");
            aggregation.setSubDirMode(false);
            return false;
        }
        if (!aggregation.isSubDirMode() && aggregation.getOutputFile() == null) {
            String errMsg = "An aggregation tag is available, but no valid aggregation was configured. Check 'subDirMode' and 'outputFile'";
            if (this.failOnWarning) {
                throw new MojoExecutionException("An aggregation tag is available, but no valid aggregation was configured. Check 'subDirMode' and 'outputFile'");
            }
            this.getLog().warn((CharSequence)"An aggregation tag is available, but no valid aggregation was configured. Check 'subDirMode' and 'outputFile'");
            return true;
        }
        return false;
    }

    private Aggregation getSubDirAggregation(File dir, Aggregation aggr, String fileExtension) {
        Aggregation subDirAggr = new Aggregation();
        subDirAggr.setPrependedFile(aggr.getPrependedFile());
        subDirAggr.setRemoveIncluded(aggr.isRemoveIncluded());
        subDirAggr.setWithoutCompress(aggr.isWithoutCompress());
        subDirAggr.setSubDirMode(true);
        File outputFile = new File(dir, dir.getName() + "." + fileExtension);
        subDirAggr.setOutputFile(outputFile);
        return subDirAggr;
    }

    private CompilationLevel resolveCompilationLevel(ResourcesSet rs) throws MojoExecutionException {
        CompilationLevel compLevel = rs.getCompilationLevel() != null ? this.getCompilationLevel(rs.getCompilationLevel()) : this.getCompilationLevel(this.compilationLevel);
        return compLevel;
    }

    private WarningLevel resolveWarningLevel(ResourcesSet rs) throws MojoExecutionException {
        WarningLevel warnLevel = rs.getWarningLevel() != null ? this.getWarningLevel(rs.getWarningLevel()) : this.getWarningLevel(this.warningLevel);
        return warnLevel;
    }

    private SourceMap resolveSourceMap(ResourcesSet rs) {
        SourceMap smap = rs != null && rs.getSourceMap() != null ? rs.getSourceMap() : this.sourceMap;
        if (smap == null || !smap.isCreate()) {
            return null;
        }
        if (smap.getOutputDir() == null) {
            smap.setOutputDir(this.smapOutputDir);
        }
        if (smap.getDetailLevel() == null) {
            smap.setDetailLevel(SourceMap.DetailLevel.ALL.name());
        }
        if (smap.getFormat() == null) {
            smap.setFormat(SourceMap.Format.V3.name());
        }
        return smap;
    }

    private CompilerOptions.LanguageMode resolveLanguageIn(ResourcesSet rs) throws MojoExecutionException {
        CompilerOptions.LanguageMode langIn = rs.getLanguageIn() != null ? this.getLanguageIn(rs.getLanguageIn()) : this.getLanguageIn(this.languageIn);
        return langIn;
    }

    private CompilerOptions.LanguageMode resolveLanguageOut(ResourcesSet rs) throws MojoExecutionException {
        CompilerOptions.LanguageMode langOut = rs.getLanguageOut() != null ? this.getLanguageOut(rs.getLanguageOut()) : this.getLanguageIn(this.languageOut);
        return langOut;
    }

    private CompilationLevel getCompilationLevel(String compilationLevel) throws MojoExecutionException {
        try {
            return CompilationLevel.valueOf((String)compilationLevel);
        }
        catch (Exception e) {
            String errMsg = "Compilation level '" + compilationLevel + "' is wrong. Valid constants are: " + "'WHITESPACE_ONLY', 'SIMPLE_OPTIMIZATIONS', 'ADVANCED_OPTIMIZATIONS'";
            if (this.failOnWarning) {
                throw new MojoExecutionException(errMsg);
            }
            this.getLog().warn((CharSequence)errMsg);
            this.getLog().warn((CharSequence)"Using 'SIMPLE_OPTIMIZATIONS' as compilation level");
            return CompilationLevel.SIMPLE_OPTIMIZATIONS;
        }
    }

    private WarningLevel getWarningLevel(String warningLevel) throws MojoExecutionException {
        try {
            return WarningLevel.valueOf((String)warningLevel);
        }
        catch (Exception e) {
            String errMsg = "Warning level '" + warningLevel + "' is wrong. Valid constants are: 'QUIET', 'DEFAULT', 'VERBOSE'";
            if (this.failOnWarning) {
                throw new MojoExecutionException(errMsg);
            }
            this.getLog().warn((CharSequence)errMsg);
            this.getLog().warn((CharSequence)"Using 'QUIET' as warning level");
            return WarningLevel.QUIET;
        }
    }

    private CompilerOptions.LanguageMode getLanguageIn(String languageIn) throws MojoExecutionException {
        try {
            return CompilerOptions.LanguageMode.valueOf((String)languageIn);
        }
        catch (Exception e) {
            String errMsg = "Input language spec'" + languageIn + "' is wrong. Valid constants are: 'ECMASCRIPT3', " + "'ECMASCRIPT5','ECMASCRIPT5_STRICT','ECMASCRIPT6','ECMASCRIPT6_STRICT'," + "'ECMASCRIPT6_TYPED'";
            if (this.failOnWarning) {
                throw new MojoExecutionException(errMsg);
            }
            this.getLog().warn((CharSequence)errMsg);
            this.getLog().warn((CharSequence)"Using 'QUIET' as warning level");
            return CompilerOptions.LanguageMode.ECMASCRIPT3;
        }
    }

    private CompilerOptions.LanguageMode getLanguageOut(String languageOut) throws MojoExecutionException {
        try {
            return CompilerOptions.LanguageMode.valueOf((String)languageOut);
        }
        catch (Exception e) {
            String errMsg = "Output language spec'" + languageOut + "' is wrong. Valid constants are: 'ECMASCRIPT3', " + "'ECMASCRIPT5', 'ECMASCRIPT5_STRICT', 'ECMASCRIPT6_TYPED' (experimental)";
            if (this.failOnWarning) {
                throw new MojoExecutionException(errMsg);
            }
            this.getLog().warn((CharSequence)errMsg);
            this.getLog().warn((CharSequence)"Using 'QUIET' as warning level");
            return CompilerOptions.LanguageMode.NO_TRANSPILE;
        }
    }

    private DataUriTokenResolver getDataUriTokenResolver() {
        if (this.dataUriTokenResolver != null) {
            return this.dataUriTokenResolver;
        }
        String[] arrImagesDir = this.imagesDir.split(",");
        File[] fileImagesDir = new File[arrImagesDir.length];
        for (int i = 0; i < arrImagesDir.length; ++i) {
            fileImagesDir[i] = new File(arrImagesDir[i]);
        }
        this.dataUriTokenResolver = new DataUriTokenResolver(fileImagesDir);
        return this.dataUriTokenResolver;
    }

    private Set<File> filterSubDirFiles(Set<File> resSetFiles, Set<File> subDirFiles) {
        LinkedHashSet<File> filteredFiles = new LinkedHashSet<File>();
        if (subDirFiles == null || subDirFiles.isEmpty() || resSetFiles == null || resSetFiles.isEmpty()) {
            return filteredFiles;
        }
        for (File subDirFile : subDirFiles) {
            if (!resSetFiles.contains(subDirFile)) continue;
            filteredFiles.add(subDirFile);
        }
        return filteredFiles;
    }

    private void outputStatistic() {
        long oneMB = 0x100000L;
        String originalSizeTotal = this.originalFilesSize <= 1024L ? this.originalFilesSize + " Bytes" : (this.originalFilesSize <= oneMB ? this.round((double)this.originalFilesSize / 1024.0, 3) + " KB" : this.round((double)this.originalFilesSize / (double)oneMB, 3) + " MB");
        String optimizedSizeTotal = this.optimizedFilesSize <= 1024L ? this.optimizedFilesSize + " Bytes" : (this.optimizedFilesSize <= oneMB ? this.round((double)this.optimizedFilesSize / 1024.0, 3) + " KB" : this.round((double)this.optimizedFilesSize / (double)oneMB, 3) + " MB");
        if (this.originalFilesSize > 0L) {
            this.getLog().info((CharSequence)"=== Statistic ===========================================");
            this.getLog().info((CharSequence)("Size before optimization = " + originalSizeTotal));
            this.getLog().info((CharSequence)("Size after optimization = " + optimizedSizeTotal));
            this.getLog().info((CharSequence)("Optimized resources have " + this.round((double)this.optimizedFilesSize * 100.0 / (double)this.originalFilesSize, 2) + "% of original size"));
            this.getLog().info((CharSequence)"=========================================================");
        }
    }

    private double round(double value, int places) {
        double factor = Math.pow(10.0, places);
        double temp = (double)Math.round(value * factor * factor) / factor;
        double roundedValue = (double)Math.round(temp) / factor;
        return roundedValue;
    }
}

