/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.optimizerplugin;

import com.google.common.io.Files;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.WarningLevel;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.primefaces.extensions.optimizerplugin.AbstractOptimizer;
import org.primefaces.extensions.optimizerplugin.ResourcesSetAdapter;
import org.primefaces.extensions.optimizerplugin.ResourcesSetJsAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosureCompilerOptimizer
extends AbstractOptimizer {
    private static final List<SourceFile> EXTERNS_EMPTY = new ArrayList<SourceFile>();
    private static final String OPTIMIZED_FILE_EXTENSION = ".optjs";

    @Override
    public void optimize(ResourcesSetAdapter rsAdapter, Log log) throws MojoExecutionException {
        ResourcesSetJsAdapter rsa = (ResourcesSetJsAdapter)rsAdapter;
        CompilationLevel compLevel = rsa.getCompilationLevel();
        CompilerOptions options = new CompilerOptions();
        compLevel.setOptionsForCompilationLevel(options);
        WarningLevel warnLevel = rsa.getWarningLevel();
        warnLevel.setOptionsForWarningLevel(options);
        Compiler.setLoggingLevel((Level)Level.WARNING);
        try {
            Charset cset = Charset.forName(rsa.getEncoding());
            if (rsa.getAggregation() == null) {
                for (File file : rsa.getFiles()) {
                    log.info((CharSequence)("Optimize JS file " + file.getName() + " ..."));
                    this.addToOriginalSize(file);
                    SourceFile jsSourceFile = SourceFile.fromFile((File)file, (Charset)cset);
                    ArrayList<SourceFile> interns = new ArrayList<SourceFile>();
                    interns.add(jsSourceFile);
                    Compiler compiler = this.compile(log, interns, options, rsa.isFailOnWarning());
                    String path = file.getCanonicalPath();
                    if (StringUtils.isNotBlank((String)rsa.getSuffix())) {
                        File outputFile = this.getFileWithSuffix(path, rsa.getSuffix());
                        Files.write((CharSequence)compiler.toSource(), (File)outputFile, (Charset)cset);
                        this.addToOptimizedSize(outputFile);
                        continue;
                    }
                    String pathOptimized = FileUtils.removeExtension((String)path) + OPTIMIZED_FILE_EXTENSION;
                    File outputFile = new File(pathOptimized);
                    Files.touch((File)outputFile);
                    Files.write((CharSequence)compiler.toSource(), (File)outputFile, (Charset)cset);
                    FileUtils.rename((File)outputFile, (File)file);
                    this.addToOptimizedSize(file);
                }
            } else if (rsa.getAggregation().getOutputFile() != null) {
                File outputFile;
                if (!rsa.getAggregation().isWithoutCompress()) {
                    ArrayList<SourceFile> interns = new ArrayList<SourceFile>();
                    for (File file : rsa.getFiles()) {
                        log.info((CharSequence)("Optimize JS file " + file.getName() + " ..."));
                        this.addToOriginalSize(file);
                        interns.add(SourceFile.fromFile((File)file, (Charset)cset));
                    }
                    Compiler compiler = this.compile(log, interns, options, rsa.isFailOnWarning());
                    int filesCount = rsa.getFiles().size();
                    if (rsa.getAggregation().getPrependedFile() != null) {
                        this.addToOriginalSize(rsa.getAggregation().getPrependedFile());
                        ++filesCount;
                    }
                    if (filesCount > 1) {
                        log.info((CharSequence)"Aggregation is running ...");
                    }
                    outputFile = this.getOutputFile(rsa);
                    long sizeBefore = outputFile.length();
                    if (rsa.getAggregation().getPrependedFile() != null) {
                        this.prependFile(rsa.getAggregation().getPrependedFile(), outputFile, cset, rsa);
                    }
                    Files.append((CharSequence)compiler.toSource(), (File)outputFile, (Charset)cset);
                    this.addToOptimizedSize(outputFile.length() - sizeBefore);
                    if (filesCount > 1) {
                        log.info((CharSequence)(filesCount + " files were successfully aggregated."));
                    }
                } else {
                    outputFile = this.aggregateFiles(rsa, cset, log, true);
                }
                this.deleteFilesIfNecessary(rsa, log);
                this.renameOutputFileIfNecessary(rsa, outputFile);
            } else {
                log.error((CharSequence)"Wrong plugin's internal state.");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Resources optimization failure: " + e.getLocalizedMessage(), e);
        }
    }

    protected Compiler compile(Log log, List<SourceFile> interns, CompilerOptions options, boolean failOnWarning) throws MojoExecutionException {
        Compiler compiler = new Compiler();
        Result result = compiler.compile(EXTERNS_EMPTY, interns, options);
        this.evalResult(result, log, failOnWarning);
        return compiler;
    }

    protected void evalResult(Result result, Log log, boolean failOnWarning) throws MojoExecutionException {
        if (result.warnings != null) {
            for (JSError warning : result.warnings) {
                log.warn((CharSequence)warning.toString());
            }
        }
        if (result.warnings != null && result.warnings.length > 0 && failOnWarning) {
            throw new MojoExecutionException("Resources optimization failure. Please fix warnings and try again.");
        }
        if (result.errors != null) {
            for (JSError error : result.errors) {
                log.error((CharSequence)error.toString());
            }
        }
        if (result.errors != null && result.errors.length > 0) {
            throw new MojoExecutionException("Resources optimization failure. Please fix errors and try again.");
        }
        if (!result.success) {
            throw new MojoExecutionException("Resources optimization failure. Please fix errors and try again.");
        }
    }
}

