/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl;

import org.krysalis.barcode4j.BarGroup;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.TextAlignment;
import org.krysalis.barcode4j.impl.DrawingUtil;
import org.krysalis.barcode4j.impl.HeightVariableBarcodeBean;
import org.krysalis.barcode4j.output.Canvas;
import org.krysalis.barcode4j.tools.MessagePatternUtil;

public abstract class AbstractVariableHeightLogicHandler
implements ClassicBarcodeLogicHandler {
    protected HeightVariableBarcodeBean bcBean;
    protected Canvas canvas;
    protected double x = 0.0;
    protected double y = 0.0;
    private String formattedMsg;
    private TextAlignment textAlignment = TextAlignment.TA_CENTER;

    public AbstractVariableHeightLogicHandler(HeightVariableBarcodeBean bcBean, Canvas canvas) {
        this.bcBean = bcBean;
        this.canvas = canvas;
    }

    public void setTextAlignment(TextAlignment align) {
        if (align == null) {
            throw new NullPointerException("align must not be null");
        }
        this.textAlignment = align;
    }

    private double getStartX() {
        if (this.bcBean.hasQuietZone()) {
            return this.bcBean.getQuietZone();
        }
        return 0.0;
    }

    @Override
    public void startBarcode(String msg, String formattedMsg) {
        this.formattedMsg = MessagePatternUtil.applyCustomMessagePattern(formattedMsg, this.bcBean.getPattern());
        BarcodeDimension dim = this.bcBean.calcDimensions(msg);
        this.canvas.establishDimensions(dim);
        this.x = this.getStartX();
    }

    @Override
    public void endBarcode() {
        if (this.bcBean.getMsgPosition() != HumanReadablePlacement.HRP_NONE) {
            double texty = this.getTextY();
            DrawingUtil.drawText(this.canvas, this.bcBean, this.formattedMsg, this.getStartX(), this.x, texty, this.textAlignment);
        }
    }

    protected double getTextY() {
        double texty = 0.0;
        if (this.bcBean.getMsgPosition() != HumanReadablePlacement.HRP_NONE) {
            if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                texty += this.bcBean.getHumanReadableHeight();
            } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                texty += this.bcBean.getHeight();
                if (this.bcBean.hasQuietZone()) {
                    texty += this.bcBean.getVerticalQuietZone();
                }
            }
        }
        return texty;
    }

    @Override
    public void startBarGroup(BarGroup barGroup, String string) {
    }

    @Override
    public void endBarGroup() {
    }
}

